/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/

package net.java.plaf.windows.common;

import java.awt.Container;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

/**
 * PLAF workaround for JOptionPane in the Windows Look and Feel. Fixes the
 * button area so that the buttons are at least 75 pixels wide. This is issue
 * 32 on winlaf.dev.java.net.
 * 
 * @author Brian.Duff@oracle.com
 */
public class WindowsOptionPaneUI extends 
  com.sun.java.swing.plaf.windows.WindowsOptionPaneUI
{
  public static ComponentUI createUI( JComponent comp )
  {
    return new WindowsOptionPaneUI();
  }

  /**
   * Creates and returns a Container containing the buttons. The buttons
   * are created by calling <code>getButtons</code>.
   */
  protected Container createButtonArea() 
  {
    JPanel bottom = new JPanel();
    bottom.setBorder(UIManager.getBorder("OptionPane.buttonAreaBorder")); //$NON-NLS-1$
    bottom.setLayout( new MyLayout() );
    addButtonComponents(bottom, getButtons(), getInitialValueIndex());
    bottom.setBorder( BorderFactory.createEmptyBorder( 17, 0, 0, 0 ));
    
    return bottom;
  }
  
// D'OH! this would have been quite simple, if it weren't for the inanely
// STUPID piece of code at the end of addButtonComponents that casts the 
// layout of the button panel. I can fix this by moving ButtonBarLayout
// back into this as an inner class, and making it a subclass of the
// cast class. Ugh. Ugh. Ugh.

  private class MyLayout extends ButtonAreaLayout
  {
    ButtonBarLayout m_buttonBarLayout = new ButtonBarLayout( 75, 6 );
  
    MyLayout()
    {
      super( true, 6 );
    }
  
    public Dimension minimumLayoutSize( Container container ) 
    {  
      return m_buttonBarLayout.minimumLayoutSize( container );
    }
    
    public void layoutContainer(Container container) 
    {    
      m_buttonBarLayout.layoutContainer( container );
    }
  }
  
}