/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/

package net.java.plaf.windows.common;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class WindowsRadioButtonMenuItemUI 
  extends com.sun.java.swing.plaf.windows.WindowsRadioButtonMenuItemUI
{
  // Utility to avoid duplicate code.
  private final WindowsMenuItemCommonUI m_commonUI = new WindowsMenuItemCommonUI();

  public static ComponentUI createUI( JComponent comp )
  {
    return new WindowsRadioButtonMenuItemUI();
  }
  
  /**
   * This requires 1.4...
   */
  protected void paintBackground( Graphics g, JMenuItem item, Color bgColor )
  {
    m_commonUI.paintBackground( g, item, bgColor, m_mouseOver );
  }

  protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text)
  {
    m_commonUI.paintText( g, menuItem, textRect, text, selectionForeground, 
      super.getPropertyPrefix() );   
  }

  // Ugly hack because methods on the superclass are private (bduff: check
  // might not be in 1.4.2)
  protected MouseInputListener createMouseInputListener( JComponent jc )
  {
    return new XPMouseInputHandler();
  }

  protected class XPMouseInputHandler extends MouseInputHandler
  {
    public void mouseEntered( MouseEvent me )
    {
      super.mouseEntered( me ); 
      
      m_mouseOver = true;
      menuItem.repaint();      
      
    }

    public void mouseExited( MouseEvent me )
    {
      super.mouseExited( me );  
      m_mouseOver = false;
      menuItem.repaint();
    }
    
    public void mousePressed( MouseEvent me )
    {
      super.mousePressed( me );
      m_mouseOver = false;
    }
  }

  private boolean m_mouseOver = false;  
}