/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by 
	Brian Duff are Copyright(C) Brian Duff. 
	All Rights Reserved.

	Contributor(s): ______________________________________.
*/
package net.java.plaf.windows.xp;

import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

import net.java.plaf.Environment;
import net.java.plaf.LookAndFeelPatch;

/**
 * Patches various icons so that they use nice alpha-blended Windows XP ones
 * if the color depth = 32 and the 8-bit equivalents from XP otherwise
 * 
 * @author Brian.Duff@oracle.com
 */
public class XPIconPatch implements LookAndFeelPatch 
{
  public XPIconPatch()
  {
  }

  public boolean isApplicable(Environment env)
  {
    // These icons are used regardless of whether XP is running in themed
    // or classic mode.
    return env.isWindowsXP() && env.isWindowsLookAndFeel();
  }
  
  private Object getIcon( Environment env, String baseName )
  {
    StringBuffer iconName = new StringBuffer( baseName.length() + 16 );
    
    iconName.append( "image/" ); //$NON-NLS-1$
    iconName.append( baseName );
  
    if ( !env.isAlphaIconCapable() )
    {
      iconName.append( "-8bit.png" ); //$NON-NLS-1$
    }
    else
    {
      iconName.append( ".png" ); //$NON-NLS-1$
    }
    
    return LookAndFeel.makeIcon( getClass(), iconName.toString() );
  }

  public void patch(Environment env)
  {
		UIDefaults defaults = UIManager.getDefaults();
    
    defaults.put( "Tree.openIcon", getIcon( env, "xpfolder-open"  ) );  //$NON-NLS-1$//$NON-NLS-2$
    defaults.put( "Tree.closedIcon", getIcon( env, "xpfolder" ) );  //$NON-NLS-1$//$NON-NLS-2$
    defaults.put( "OptionPane.errorIcon", getIcon( env, "msgbox-error" ) );  //$NON-NLS-1$//$NON-NLS-2$
    defaults.put( "OptionPane.warningIcon", getIcon( env, "msgbox-warn" ) );  //$NON-NLS-1$//$NON-NLS-2$
    defaults.put( "OptionPane.informationIcon", getIcon( env, "msgbox-info" ) ); //$NON-NLS-1$ //$NON-NLS-2$
  }

  public void unpatch()
  {
  }
}