/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/

package net.java.plaf.windows.xp;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import net.java.plaf.Environment;
import net.java.plaf.LookAndFeelPatch;

/**
 * Patches the password field on Windows XP, fixing the following issues:
 * 
 * <ul>
 *  <li><b>Issue 19:</b> Password echo character is still * in JPasswordField
 *  </li>
 * </ul>
 */
public class XPPasswordFieldPatch implements LookAndFeelPatch
{
  public boolean isApplicable( Environment env )
  {
    return env.isWindowsLookAndFeel() && env.isWindowsXP();
  }
  
  public void patch( Environment env )
  {
    UIDefaults defaults = UIManager.getDefaults();
    
    defaults.put( "PasswordFieldUI", "net.java.plaf.windows.xp.XPPasswordFieldUI" ); //$NON-NLS-1$ //$NON-NLS-2$
  }
  
  public void unpatch() {}
}