/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/

package net.java.plaf.windows.xp;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

import javax.swing.JPasswordField;
import javax.swing.text.Element;
import javax.swing.text.PasswordView;

/**
 * Text view for password fields under the Windows XP Look and feel.
 * Rather than rendering a character, the XP password view renders an 
 * oval glyph.
 * 
 * @author Brian.Duff@oracle.com
 */
class XPPasswordView extends PasswordView
{
  public XPPasswordView( Element element )
  {
    super( element );
  }

  protected int drawEchoCharacter( Graphics g, int x, int y, char c )
  {
    // The oval looks lame unless it's anti-aliased.
    ((Graphics2D)g).setRenderingHint( RenderingHints.KEY_ANTIALIASING, 
      RenderingHints.VALUE_ANTIALIAS_ON );
    Container cont = getContainer();
    if (cont instanceof JPasswordField) 
    {
      JPasswordField f = (JPasswordField) cont;
	    char echoChar = f.getEchoChar();
	    FontMetrics m = f.getFontMetrics(f.getFont());
      int glyphSize = m.charWidth( echoChar );

      int ovalSize = Math.max( 2, glyphSize - 2 );
      // y is the very bottom of the text field. -2 is a "fudge factor" to
      // center the glyphs. Without knowing the height of the text field, 
      // I'm unsure how to vertically center properly.
      g.fillOval( x + 1, y - ovalSize-2, ovalSize, ovalSize );

      return x + glyphSize;      
    }

    return super.drawEchoCharacter( g, x, y, c );
  }
}