/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/

package net.java.plaf.windows.xp;
import java.awt.Insets;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.InsetsUIResource;
import net.java.plaf.Environment;
import net.java.plaf.LookAndFeelPatch;

/**
 * Patches the following winlaf issues:
 * 
 * <ul>
 *  <li><b>Issue 14:</b>
 *    Internal insets of JTextField are wrong under Windows XP L&F
 *  </li>
 * </ul>
 */
public class XPTextFieldMarginPatch implements LookAndFeelPatch
{
  public boolean isApplicable( Environment env )
  {
    return env.isWindowsLookAndFeel() && env.isWindowsXPThemed();
  }

  public void patch( Environment env )
  {
    UIDefaults defaults = UIManager.getDefaults();
    
    // Patch text field insets on Windows XP look and feel.
    Insets textFieldInsets = new InsetsUIResource( 2, 2, 2, 2 );
    
    defaults.put( "TextField.margin", textFieldInsets ); //$NON-NLS-1$
    defaults.put( "PasswordField.margin", textFieldInsets ); //$NON-NLS-1$
    defaults.put( "FormattedTextField.margin", textFieldInsets ); //$NON-NLS-1$
  }
  
  public void unpatch()
  {
    
  }
  
}