function guessFormat(file_path){
	try {
		var efile = new air.File(file_path);
		var stream = new air.FileStream();
		stream.open(efile, air.FileMode.READ);
		
		var bytes = new air.ByteArray();
		stream.readBytes(bytes,0,2);
		
		var b1 = bytes[0];
		var b2 = bytes[1];
		
		if (b1 == 71 && b2 == 73) {//0x47 0x49
            return "image/gif";
        }
        else if (b1 == 137 && b2 == 0x50) {//89 
            return "image/png";
        } 
		else if (b1 == 0xff && b2 == 0xd8) {
            return "image/jpeg";
        } 
		else if (b1 == 0x42 && b2 == 0x4d) {
            return "image/bmp";
        }
		else if (b1 == 0x4D && b2 == 0x4D) // Motorola byte order TIFF
        {
            return "image/tiff";
        } 
		else if (b1 == 0x49 && b2 == 0x49) // Intel byte order TIFF
        {
            return "image/tiff";
        } 
		else if (b1 == 0x38 && b2 == 0x42) {
            return "image/psd";
        } 
		else if (b1 == 0x50 && b2 == 0x31) {
            return "image/pbm";
        } 
		else if (b1 == 0x50 && b2 == 0x34) {
            return "image/pbm";
        } 
		else if (b1 == 0x50 && b2 == 0x32) {
            return "image/pgm";
        } 
		else if (b1 == 0x50 && b2 == 0x35) {
            return "image/pgm";
        } 
		else if (b1 == 0x50 && b2 == 0x33) {
            return "image/ppm";
        } 
		else if (b1 == 0x50 && b2 == 0x36) {
            return "image/ppm";
        }
	} catch(e){
	}
	return 'unknown/unreadable';
}