// Utililty prototype custom remove function

//Changing to avoid naming conflict
Array.prototype.remove_slice = function(from, to) {
  var rest = this.slice((to || from) + 1 || this.length);
  this.length = from < 0 ? this.length + from : from;
  return this.push.apply(this, rest);
};

var ptbar = null;

var invocation_arguments = null;
var cli_perf_mode = false;
var appUpdater;
var opener;
var win;
var browserTest = false;
var thumbnailregion;

var appName = "EMET";

var firstTimeElemAdd = false;

//JS DS to Alter array contents
var arrayData = [];
//Reference to store object for dynamic updation
var store = null;
var emet_data_store = null;

//Essential Data that needs to be persisted
var csv_location = '';							//!
var csv_all_prefix = 'EMET_EXTRACTION';			//!
var csv_error_prefix = 'EMET_Error_Report';		//!
var cvs_is_error=true;							//!


// Preferences Saving & Loading Logic
var prefsFile; // The preferences file
var prefsXML; // The XML data
var prefsStream; // The FileStream object used to read and write prefsFile data.

function init_prefs(){
	window.nativeWindow.addEventListener(air.Event.CLOSING, windowClosingHandler); 
	prefsFile = air.File.applicationStorageDirectory;
	prefsFile = prefsFile.resolvePath("preferences.xml"); 
	readXML();
}

function readXML()
{
	prefsStream = new air.FileStream();
	if (prefsFile.exists) {
		prefsStream.open(prefsFile, air.FileMode.READ);
		processXMLData();
	}
	else
	{
		saveData();
	}
	window.nativeWindow.visible = true;
}
function processXMLData()
{
	prefsXML = prefsStream.readUTFBytes(prefsStream.bytesAvailable);
	prefsStream.close();
	var domParser = new DOMParser();
	prefsXML = domParser.parseFromString(prefsXML, "text/xml");
	var windowState = prefsXML.getElementsByTagName("appState")[0];
	csv_location = windowState.getAttribute("csv_location");
	csv_all_prefix = windowState.getAttribute("csv_all_prefix");
	csv_error_prefix = windowState.getAttribute("csv_error_prefix");
	
	if(csv_location){
		if(csv_location.length > 0){
			csv_location_changed = true;
		}
	}
	
	if(windowState.getAttribute("cvs_is_error") === 'true'){
		cvs_is_error = true;
	}
	else{
		cvs_is_error = false;
	}
	
	//alert(csv_location + csv_all_prefix + csv_error_prefix + cvs_is_error);
}
function windowClosingHandler(event) 
{
		air.trace("\nClosing Application\n")
		
		air.trace(blindScanFail);
		air.trace(blindScanTotal);

		
		DbCache.cleanup();
		event.preventDefault();
		nativeWindow.removeEventListener("closing", windowClosingHandler)
		saveData();
		air.NativeApplication.nativeApplication.exit();
}
function saveData()
{
		createXMLData();
		writeXMLData();
}
function createXMLData()
{
	var cr = air.File.lineEnding;
	prefsXML =   "<?xml version='1.0' encoding='utf-8'?>" + cr
					+ "<preferences>" + cr 
					+ "    <appState" + cr
					+ "        csv_location = '" + csv_location + "'" + cr
					+ "        csv_all_prefix = '" + csv_all_prefix + "'" + cr
					+ "        csv_error_prefix = '" + csv_error_prefix + "'" + cr
					+ "        cvs_is_error = '" + cvs_is_error + "'" + "/>" + cr
					+ "    <saveDate>"
					+            new Date().toString() 
					+     "</saveDate>" + cr
					+ "</preferences>"; 
}
function writeXMLData()
{
	prefsStream = new air.FileStream();
	prefsStream.open(prefsFile, air.FileMode.WRITE);
	prefsStream.writeUTFBytes(prefsXML);
	prefsStream.close();
}

var csv_location_changed = false;
var csv_exif_prefix = 'EXIF_ALL';				
var csv_error_prefix_flag=false;				
var csv_error_chk_flag=!csv_error_prefix_flag;

var images_view_grid;

var button_1;

var store_collection = {};

var header_fields = ["artstor:WorkCreator",
	"artstor:WorkTitle",
	"artstor:WorkDescription",
	"artstor:WorkDate",
	"artstor:WorkRepository",
	"artstor:WorkRepositoryAccessionNumber",
	"artstor:WorkCity",
	"artstor:WorkCountry",
	"artstor:Photographer",
	"artstor:Copyright",
	"artstor:PLUSCreatorNumber",
	"artstor:PLUSLicenseNumber",
	"crs:AlreadyApplied",
	"exif:ExifVersion",
	"exif:PixelXDimension",
	"exif:PixelYDimension",
	"exif:ColorSpace",
	"photoshop:History",	//Disabled History from Extracted Fields
	"photoshop:ColorMode",
	"photoshop:ICCProfile",
	"tiff:Orientation",
	"tiff:ImageWidth",
	"tiff:ImageLength",
	"tiff:PhotometricInterpretation",
	"tiff:SamplesPerPixel",
	"tiff:XResolution",
	"tiff:YResolution",
	"tiff:ResolutionUnit",
	"xmp:CreateDate",
	"xmp:ModifyDate",
	"xmp:MetadataDate",
	"xmp:CreatorTool",
	"xmpMM:DocumentID",
	"xmpMM:InstanceID",
	"dc:format"];

function stopClicksWhenProcessing(){
	if(recursorRunning){
		Ext.MessageBox.alert(appName, "You can not proceed with this action while EMET is processing. If you wish to cancel processing, please the cancel processing button next to the progress bar.");
		return true;
	}
	return false;
}

refresh_first_time = true;

function refresh_paging_toolbar(){
	//Limits The Range of the STORE when loaded with data
	//store.reload();
	if (refresh_first_time) {
		store.load({
			params: {
				start: 0,
				limit: 25
			}
		});
		refresh_first_time = false;
	}
	else{
		store.reload();
	}
	air.trace("\n\n"+"Paging Record");
	air.trace("Cursor\tPageSize\tTotalCount\t")
	air.trace(ptbar.cursor + "\t" + ptbar.pageSize + "\t" + ptbar.store.getTotalCount());
	var activePage = Math.ceil((ptbar.cursor + ptbar.pageSize) / ptbar.pageSize);
	var maxPage = Math.ceil((ptbar.store.getTotalCount()-1) / ptbar.pageSize);
	air.trace("Current\tMax Page");
	air.trace(activePage + "\t" + maxPage);
	if(activePage != maxPage){
		if(activePage > maxPage){
			//Change to MaxPage
			air.trace("Switching Page to "+activePage);
			ptbar.changePage(maxPage);
		}
		else if(maxPage > activePage){
			//Stick to current Page
		}
	}



	
	//var count = get_total_count();
	/*
	air.trace(typeof images_view_grid['bbar']);
	for(var key in ptbar){
		air.trace(">>> "+key);
	}
	*/
	
	//asdfas;
	
}

function get_total_count(){
	return arrayData.length;
}
function get_corrupted_count(){
	var corruptedCount = 0;
	for(var j=0; j<arrayData.length;j++){
		if(arrayData[j][6] === 'Yes'){
			corruptedCount += 1;
		}
	}
	return corruptedCount;
}

function store_id_generator(store_key){
	if(store_key in store_collection){
		store_collection[store_key] += 1;
	}
	else{
		store_collection[store_key] = 1;
	}
	return store_collection[store_key];
}

/**
 * Example usage : add_elem_into_store(["Sample", './img/ndiip_title.jpg', 32499, '10-14-2008']);
 */
function replace_store(arr){
	arrayData = arr;
	store.loadData(arrayData);
}
function exists_in_store(key, value){
	for(var p=0; p<arrayData.length; p++){
		if(value === arrayData[p][key]){
			//Duplicate Detected
			return true;
		}
	}
	return false;
}
/*
 * Adds Element to store and has duplicity checking in it now
 */
function add_elem_into_store(elem){
	var add_to_store = false;
	if(exists_in_store(2, elem[2])){
	}
	else{
		add_to_store = true;
	}
	if (add_to_store) {
		arrayData.push(elem);
		refresh_paging_toolbar();
		updateTotalCountInFooter();
	}
	//air.trace("Element Location" + elem[2] + "Exists Status" + add_to_store);
	return add_to_store;
}
function remove_elem_from_store(index){
	//Change this to reference based
	for(var i=0; i<arrayData.length; i++)
	{
		if(arrayData[i][0] === index){
			arrayData.remove_slice(i);
		}
	}
	refresh_paging_toolbar();
	updateTotalCountInFooter();
}
function clear_store_selected(){
	//air.trace('----');
	var selections = images_view_grid.getSelectionModel().getSelections();
	for (var i = 0 ; i < selections.length ;i++) {
		var temp_id = selections[i].data['id'];
		//air.trace(temp_id);
		remove_elem_from_store(temp_id);
	}
	refresh_paging_toolbar();
	updateTotalCountInFooter();
	
}
function clear_store(){
	if(stopClicksWhenProcessing()){
		return;
	}
	//air.trace('In Clear');
	var selections = images_view_grid.getSelectionModel().getSelections();
	
	if (selections.length == 0) {
		if (arrayData.length > 0) {
			Ext.Msg.confirm(appName, 
				"No rows selected.You can make your selection using shift & control/command.\n" +
					"Do you wish to clear your workspace?",
				function(btn){
					if (btn == 'yes'){
						while(arrayData.length > 0){
							arrayData.pop();
						}
						refresh_paging_toolbar();
						updateTotalCountInFooter();	//This is essential because this function essentially represents a fork in the code
					}
				}
			);
		}
		else{
			Ext.MessageBox.alert(appName, "Please make a selection using either the browse button or drag files/directories into main grid window.");
		}
	}
	else {
		for (var i = 0; i < selections.length; i++) {
			var temp_id = selections[i].data['id'];
			////air.trace(temp_id);
			remove_elem_from_store(temp_id);
		}
	}
	updateTotalCountInFooter();
}

var fileToOpen = air.File.documentsDirectory;

/*
 * Inserts File Object into Store
 */

var insert_cache_fl_names = [];
function insertFileObjectInStore(file_obj){
	//There should be a Filter Check here
	insert_cache_fl_names.push(file_obj);
}
//fl_names_obj

function insertFileObjectInStoreProcess(){
	//Pseudo Recursive method of updation. Allows Progress bar to update
	pseudo_recursor.action = function (){
		var index = this.index;
		insertFileObjectInStore_worker(this.li[this.index]);
		pbar_update((this.index+1), pbar2, 'loader', this.li.length);
		if(this.index == (this.li.length - 1)){
			recursorRunning = false;
			if(cli_perf_mode){
				extracter_new(csv_error_chk_flag);
			}
		}
	},
	pseudo_recursor.ignition(insert_cache_fl_names, 0, null, null, null);
	
	/*
	// Sequential Method of Updation
	for(var k=0; k<insert_cache_fl_names.length; k++){
		pbar_update((k+1), pbar2, 'dummy', insert_cache_fl_names.length);
		insertFileObjectInStore_worker(insert_cache_fl_names[k]);
	}
	*/
	insert_cache_fl_names = [];
}

function recursiveOfAbove(index, maxindex){
	if (index < maxindex) {
		insertFileObjectInStore_worker(insert_cache_fl_names[index]);
		//var elem = document.getElementById("ndiip_footer_total");
		//elem.innerHTML = '<p style="color:white">'+(index+1)+' Images</p>';
		//recursiveOfAbove(index + 1, maxindex)
		pbar_update(index+1, pbar2, 'loader', maxindex);
		
		//air.trace("\n\n\n\n\n\\n");
		
		setTimeout(recursiveOfAbove(index + 1, maxindex), 50);
	}
	return;
}

/*
 * The below function needs the variables given to it
 */
function insertFileObjectInStore_worker(file_obj){
	var name = file_obj.name;
	var size = Math.ceil(file_obj.size/1000);
	var path = file_obj.url;
	var date = file_obj.modificationDate.toString();
	var panel_present = "No";
	var corrupted = "No";
	var native_path = file_obj.nativePath;
	try {
		if (containsNDIPPanel(path)) {
			panel_present = "Yes";
		}
		//alert(mt_guess_mime_from_path(path) + ' -- ' + guessFormat(path));
		/* Removing Mime Check enforcement */
		if(mt_guess_mime_from_path(path) == "image/jpeg"){
			if(guessFormat(path) == "image/jpeg"){	
			}
			else{
				panel_present = "NA";
				corrupted = "Yes";
			}
		}
		else if(mt_guess_mime_from_path(path) == "image/tiff"){
			if(guessFormat(path) == "image/tiff"){
			}
			else{
				//alert(guessFormat(path));
				panel_present = "NA";
				corrupted = "Yes";
			}
		}
	} 
	catch (exc) {
		air.trace(">>>" + exc.message + "<<<");
		if(exc.message.search("2030") > -1){
			//End Of File Error
			panel_present = "NA";
			corrupted = "Yes";
		}
		else{
			//Other Error
			panel_present = "NA";
			corrupted = "Yes";
		}
	}
	var acquired_id = store_id_generator('ndiipp-grid');
	var entry = [acquired_id, name, path, size, date, panel_present, corrupted, native_path];
	add_elem_into_store(entry);
}

/*
 * Event Called when Files are selected
 */
function fileSelected(event){
	var flag = false;
	for( var f = 0; f < event.files.length; f++ ) {
		var temp = event.files[f];
		if (!temp.isDirectory) {
			if (temp.extension) { //This is the case for files without extensions
				if (mt_get_mime_type(temp.extension) == "image/jpeg" ||
					mt_get_mime_type(temp.extension) == "image/tiff") {
					flag = true;
					air.trace(temp.url);
					insertFileObjectInStore(temp); //Add processing logic in here
				}
			}
		}
	}
	if (flag == true) {
		insertFileObjectInStoreProcess();
	}
	else{
		Ext.MessageBox.alert(appName, "The files you selected were not EMET Compatible. Please make a new selection");
	}
}

function browse_button(){
	//air.trace("In browse");
	if (stopClicksWhenProcessing()) {
		return;
	}
	else {
		var imgFilter = new air.FileFilter("Text", "*.jpg;*.jpeg;*.tif;*.tiff");
		fileToOpen.browseForOpenMultiple("Open", new window.runtime.Array(imgFilter));
		fileToOpen.addEventListener(air.FileListEvent.SELECT_MULTIPLE, fileSelected);
	}
}

function help_button(){
	//refresh_paging_toolbar();
	if(air.HTMLLoader.pdfCapability == air.HTMLPDFCapability.STATUS_OK) {
		air.trace("PDF content can be displayed");
		window.open("help.html", "win", "height=480,width=640,top=10,left=10,toolbar=no,scrollbars=no");
		//window.open('help.html');
	} else {
		air.trace("PDF cannot be displayed. Error code:", air.HTMLLoader.pdfCapability);
		window.open('help-plain.html');
	}
}

function log_debug_info(obj){
	if(browserTest){
		//Do nothing for now
	}
	else{
		air.trace(obj);
	}
}

 
function panel_corrupt_status(path){
	var enforce_mime_check = false;
	var panel_present = "No";
	var corrupted = "No";
	//var native_path = file_obj.nativePath;
	try {
		if (containsNDIPPanel(path)) {
			panel_present = "Yes";
		}
		if (enforce_mime_check) {
			if (mt_guess_mime_from_path(path) == "image/jpeg") {
				if (!fileIsJpegExternal(path)) {
					panel_present = "NA";
					corrupted = "Yes";
				}
			}
			else 
				if (mt_guess_mime_from_path(path) == "image/tiff") {
					if (!fileIsTiffExternal(path)) {
						panel_present = "NA";
						corrupted = "Yes";
					}
				}
		}		
	} 
	catch (exc) {
		air.trace(">>>" + exc.message + "<<<");
		if(exc.message.search("2030") > -1){
			//End Of File Error
			panel_present = "NA";
			corrupted = "Yes";
		}
		else{
			//Other Error
			panel_present = "NA";
			corrupted = "Yes";
		}
	}
	return {'panel': panel_present, 'corrupted': corrupted};
}

function renderArtstorPanel(value, p, record){
	var retobj = panel_corrupt_status(record.data['url']);
    return String.format('{0}', retobj['panel']);
}
function renderCorrupted(value, p, record){
	var retobj = panel_corrupt_status(record.data['url']);
    return String.format('{0}', retobj['corrupted']);
}

function drawThumbnailView(){
	arrayData = [];
	log_debug_info(arrayData);
	var arrayReader = new Ext.data.ArrayReader({id: 'id'},
		[	{name: 'id',  mapping: 0  },
			{name: 'name',  mapping: 1  },
			{name: 'url', mapping: 2  },
			{name:'size', type: 'float', mapping:3}, 
			{name:'lastmod', mapping:4},
			{name:'artstor-panel', mapping:5},
			{name:'corrupted', mapping:6}]
		);
	
	var memoryProxy = new Ext.ux.data.PagingMemoryProxy(arrayData),
	//var memoryProxy  = new Ext.data.MemoryProxy(arrayData);
	
	emet_data_store = new Ext.data.Store({proxy  : memoryProxy,
								remoteSort:true,
								reader : arrayReader});
	
	emet_data_store.on('loadexception', function(){
	    log_debug_info('Load Exception' + store.getTotalCount()  )
    });
	emet_data_store.on('load', function(){
	    //log_debug_info( 'Success got initial data' + store.getTotalCount()  )
    });
	
	log_debug_info("Any minute now");
	emet_data_store.load();
	
	var tpl = opener.Templates.thumb;
	
	ptbar = new Ext.PagingToolbar({ pageSize: 25, 
										store: emet_data_store,
										displayInfo: true});
	
	images_view_grid = new Ext.grid.GridPanel({
			id: 'images-view-grid',
			store: emet_data_store,
			enableDragDrop: true,
			enableColumnHide:false,
			enableCtxMenu: false,
			columns: [
	            {header: 'id', width: 0, sortable: true, dataIndex:'id', hidden: true},

				{header: 'Name', width: 200, sortable: true,dataIndex: 'name'},
				{header: 'Size(K)', width: 100, sortable: true,dataIndex: 'size'},
				{header: 'Modified', width: 100, sortable: true,dataIndex: 'lastmod'},
				{header: 'Artstor Panel', width: 100, sortable: true,dataIndex: 'artstor-panel'}, //renderer: renderArtstorPanel},
	        	{header: 'Corrupted', width: 100, sortable: true,dataIndex: 'corrupted'}, //renderer: renderCorrupted},
			],
			
			bbar: ptbar,
		});

	images_view_grid.on('rowdblclick', function(grid, rowIndex, e) {
		var file_url = emet_data_store.data.items[rowIndex].data['url'];
		file = new air.File();
		file.url = file_url;
		file.openWithDefaultApplication();
	})

    var panel = new Ext.Panel({
        id:'images-view',
		region: 'center',
		xtype: 'panel',
		height: 700,
		//bodyStyle: 'background-color:#333333;border: 0px;',
		//frame:true,
		
        width:500,	//Need to make these dynamic
		height: 500,
        
		//autoHeight:true,
        //autoWidth:true,
        
		//collapsible:true,
		autoScroll: false,
		
        layout:'fit',
		items: images_view_grid,
    });
	thumbnailregion = panel;
	
	store = emet_data_store;	//Another Hack
}

/**
 * Functions below handle stor Progress bar for asset copy to pane.
 * Usage: 	To reset --> pbar2.reset();
 * 			To set any limit --> pbar_update(item_number, pbar2, dummy, total_count);
 */
varpbar2 = null;
function pbar_update(v, pbar, mode, count){
	if(mode == 'loader'){
	    air.trace('\n\nPROGRESS:'+'Loading item ' + v + ' of '+count+'...'+arrayData[v-1][2]);
		pbar.updateProgress(v/count, 'Loading item ' + v + ' of '+count+'...');
	}
	else if(mode == 'stage1'){
	    air.trace('\n\nPROGRESS:'+'Compiling Exif fields ' + v + ' of '+count+'...'+arrayData[v-1][2]);
		pbar.updateProgress(v/count, 'Compiling Exif fields ' + v + ' of '+count+'...');
	}
	else if(mode == 'stage2'){
	    air.trace('\n\nPROGRESS:'+'Compiling XMP & IPTC fields ' + v + ' of '+count+'...'+arrayData[v-1][2]);
		pbar.updateProgress(v/count, 'Compiling XMP & IPTC fields ' + v + ' of '+count+'...');
	}
	else if(mode == 'stage3'){
	    air.trace('\n\nPROGRESS:'+'Extracting & Reporting ' + v + ' of '+count+'...'+arrayData[v-1][2]);
		pbar.updateProgress(v/count, 'Extracting & Reporting ' + v + ' of '+count+'...');
	}
	if(v == count){
		progressBarResetWorker();
	}
}
function progressBarResetWorker(){
	pbar2.reset();
    pbar2.updateText('Ready');
}
function progressBarReset(){
	setTimeout(progressBarResetWorker,500);
}
function progressBar(){
	pbar2 = new Ext.ProgressBar({
		    text:'Ready',
	        id:'pbar2',
	        cls:'left-align',
	        renderTo:'p2',
			//animate: true
	    });	
}
/**
 * Function to parse XMP returned XML and get Key Value Pairs
 */
function process_button(){
	if(stopClicksWhenProcessing()){
		return;
	}
	chkASPanBExtract();
	//extracter_new(csv_error_chk_flag);
}
/*
 * Gets the formatted Data from the Map
 */
function getformattedDatafromXMP_file(path){
	var xmp_data = ddGetDumpXmp(path);
	return xmpStr2Map(xmp_data);
}
/*
 * XMP String to Map Conversion Function
 */
function xmpStr2Map(xmp_sample){
	var appXml = new DOMParser();
	var xmlobject = appXml.parseFromString(xmp_sample, "text/xml");
	var x = xmlobject.getElementsByTagName("Description");
	var ret_obj = {}; /* This is the map of all the attributes inside the app*/
	if (x != null) {
		if (x.length > 0) {
			var nodeMap = x[0]['attributes'];
			for(var i=0, len=nodeMap.length; node=nodeMap[i], i < len; i++){
				if(node instanceof Attr){
					ret_obj[node.name] = node.value;
				}
			}
			/*for (i = 0; i <= nodeMap.length; i++) {
				node = nodeMap[i];
				if (node instanceof Attr) {
					air.trace(node.name + node.value);
					ret_obj[node.name] = node.value;
				}
			}
			*/
		}
	}
	return ret_obj;
}
/*
 * Gets Minimized Map based on prefix filter e.g. artstor
 */
function getminimizedMap(passedMap, prefix){
	var newMap = {};
	for(mapkey in passedMap){
		if(mapkey.indexOf(prefix) === 0){
		//if(mapkey.substr(0,prefix.length) == prefix){
			newMap[mapkey] = passedMap[mapkey];
		}
	}
	return newMap;
}
/*
 * Checks for the presence of the NDIPP Panel
 * 
 * TODO:
 * - Insert Optimization to load all data and save into database with ID for quick retreival
 */
function containsNDIPPanel(path){
	var prefix = 'artstor';
	var ret_map = getformattedDatafromXMP_file(path);
	for(var mapkey in ret_map){
		if (mapkey.indexOf(prefix) === 0) {
			return true;
		}
	}
	return false;
}
/*
 * Converts Map to String for debugging purposes
 */
function map2String(passedMap){
	var debug_str = '';
	var mapkey;
	for(mapkey in passedMap){
		debug_str += mapkey +' -- '+ passedMap[mapkey];
	}
	return debug_str;
}
/*
 * Escapes Field according to the CSV Standard format
 */
function escapeField(ftext){
	var tstr = '' + ftext;
	var turn_on_quotes = false;
	if(tstr.search(',') >= 0){
		turn_on_quotes = true;
	}
	else if(tstr.search('\r') >= 0){
		turn_on_quotes = true;
	}
	else if(tstr.search('\n') >= 0){
		turn_on_quotes = true;
	}
	else if(tstr.search('"') >= 0){
		turn_on_quotes = true;
	}
	//Escape Quotes here
    tstr = tstr.replace(/"/g, '""');
    if(turn_on_quotes){
		tstr = '"' + tstr + '"';
	}
    return tstr;
}
/*
 * Converts Map into escaped maps without Commas, New Lines or Spaces which may interfere with the CSV Generation
 */
function escapeMap(passedMap){
	var debug_str = '';
	var mapkey;
	for(mapkey in passedMap){
		var rrc = passedMap[mapkey];
		if (typeof(rrc) == "string" || typeof(rrc) == "object") {
			rrc = escapeField(rrc);
			rrc = superUTFFix(rrc);
		}
		passedMap[mapkey] = rrc;
	}
	return passedMap;
}
function superUTFFix(instr){
	//There was an instance of a bug that did'nt let you append anything to a String.
	//By Writing and reading UTF8 bytes, the bug ceases to exist.
	var a = new air.ByteArray();
	a.writeUTFBytes(instr);
	a.position = 0;
	return a.readUTFBytes(a.length);
}

/*
 * Filter based on hardcoded Headers. Returns Array
 */
function filterOnHeader(passedMap){
	var i = 0;
	var mapkey;
	var return_record = [];
	for(i=0; i<header_fields.length; i++){
		var candidate = header_fields[i];
		if(candidate in passedMap){
			var rrc = passedMap[candidate];
			return_record.push(rrc);
		}
		else{
			return_record.push('');
		}
	}
	return return_record;
}
/**
 * Function returns current working version of the application
 */
function getMyApplicationVersion(){
	var xmlString = air.NativeApplication.nativeApplication.applicationDescriptor; 
	var appXml = new DOMParser(); 
	var xmlobject = appXml.parseFromString(xmlString, "text/xml");
	var root = xmlobject.getElementsByTagName('application')[0];
	var appVersion = root.getElementsByTagName("version")[0].firstChild.data; 
	return appVersion;
}
/**
 * Function Determines if Current version is the latest available and prompts the user if it is'nt
 * - This is an asynchronous function and will not block the user
 */
function updaterLogic(){
	//alert("ULogic")
	var file = new air.File("app:/config/update-config.xml"); 
	var fileStream= new air.FileStream(); 
	fileStream.addEventListener(air.Event.COMPLETE, processXMLData); 
	fileStream.openAsync(file, air.FileMode.READ);	
	var xmlString = "";
	var appVersionUrl = "";
	function processXMLData(event){
	    try{
		    var xmlString = fileStream.readUTFBytes(fileStream.bytesAvailable);
        	log_debug_info(xmlString);
        	var appXml = new DOMParser();
        	var xmlobject = appXml.parseFromString(xmlString, "text/xml"); 
	
        	appVersionUrl = xmlobject.getElementsByTagName("url")[0].firstChild.data;
        	log_debug_info(appVersionUrl);
	
        	var xhttp = new XMLHttpRequest();
        	xhttp.open("GET", appVersionUrl, false);
        	xhttp.send("");
        	var xmlDoc=xhttp.responseXML;
        	appVersion = xmlDoc.getElementsByTagName("version")[0].firstChild.data;
	
        	log_debug_info("Local Version" + getMyApplicationVersion());
        	log_debug_info("Remote Version" + appVersion);
	
        	if(appVersion == getMyApplicationVersion()){
        		//Do Nothing
        		log_debug_info("Version Upto Date");
				//alert("Version Upto Date")
        	}
        	else{
				//alert("Invoking Update")
        		//log_debug_info("Version not latest");
        		checkForUpdate();
				
        	}
		}
		catch(exc){
			//alert("Network Not Found");
		    air.trace(">>>" + exc.message + "<<<");
		    air.trace("Possible network issue. Application Descriptor unavailable");
		}
	}
}
/**
 * This is trigger that can be called for manually getting the check updates
 * This should be useless given the updaterLogic method available
 */
function checkForUpdate()
{
	appUpdater.checkNow();
	/*Test Stub*/
	//var fileToOpen = air.File.documentsDirectory;
	//var html_message = "Your Current CSV Export Folder is set to your Documents directory. To change this Click Here."
}
/**
 * Function Invoked if this is Air
 * - Initializes & Executes Updater Logic
 */
function init()
{	
	init_prefs();

	appUpdater = new air.ApplicationUpdaterUI();
	appUpdater.configurationFile = new air.File("app:/config/update-config.xml");
	appUpdater.initialize();
	appUpdater.addEventListener(runtime.air.update.events.UpdateEvent.INITIALIZED,updaterLogic);
	
}
/**
 * Displays an error message when the updater dispatches an error event.
 */
function onError(event)
{
	Ext.MessageBox.alert(appName, event.toString());
}

/**
 * Add Tool Tips
 */
function insertToolTips(){
	
	/*'<img id="browse-button"  src="img/emet_btn_select_images_off.gif" alt="NDIPP_TITLE" style="padding-left:10px"/>'+
	'<img id="process-button" src="img/emet_btn_extract_data_off.gif" alt="NDIPP_TITLE" style="padding-left:10px"/>'+
	'<img id="clear-button"   src="img/emet_btn_clear_images_off.gif" alt="NDIPP_TITLE" style="padding-left:10px"/>'+
	'<img id="setting-button" src="img/emet_btn_settings_off.gif" alt="NDIPP_TITLE" style="padding-left:10px"/>'+
	'<img id="help-button"    src="img/emet_btn_help_off.gif" alt="NDIPP_TITLE" style="padding-left:10px"/>'+
	'<img id="update-button"  src="img/emet_btn_updates_off.gif" alt="NDIPP_TITLE" style="padding-left:10px"/>'+
	*/
	
	var tooltips = [
		{target: 'process-button',	title: 'Extract',				over:'img/emet_btn_extract_data_on.gif',	out:'img/emet_btn_extract_data_off.gif',	offset:[-10, -10]},
		{target: 'clear-button',	title: 'Clear Selected Images',	over:'img/emet_btn_clear_images_on.gif',	out:'img/emet_btn_clear_images_off.gif',	offset:[-10, -10]},
		{target: 'browse-button',	title: 'Select Images',			over:'img/emet_btn_select_images_on.gif',	out:'img/emet_btn_select_images_off.gif',	offset:[-10, -10]},
		{target: 'update-button',	title: 'Check for Updates',		over:'img/emet_btn_updates_on.gif',			out:'img/emet_btn_updates_off.gif',			offset:[-100, -10]},
		{target: 'setting-button',	title: 'Settings',				over:'img/emet_btn_settings_on.gif',		out:'img/emet_btn_settings_off.gif',		offset:[-10, -10]},
		{target: 'help-button',		title: 'Help',					over:'img/emet_btn_help_on.gif',			out:'img/emet_btn_help_off.gif',			offset:[-10, -10]},
		{target: 'pbar-cancel',		title: 'Cancel Processing',		over:'img/emet_btn_clear_bar_off.gif',		out:'img/emet_btn_clear_bar_off.gif',		offset:[-100, -10]}
	];
	for(var counter=0; counter<tooltips.length; counter++){
		var tooltip = tooltips[counter];

		new Ext.ToolTip({
				target: tooltip['target'],
				title: tooltip['title'],
				mouseOffset: tooltip['offset']
		});
	
		Ext.get(tooltip['target']).on('mouseover', function(e){
			//air.trace(e.target.id);
			//air.trace(e.target.src);
			
			for(var counter2=0; counter2<tooltips.length; counter2++){
				if(e.target.id == tooltips[counter2]['target']){
					//air.trace(tooltips[counter2]['target']);
					Ext.getDom(tooltips[counter2]['target']).src = tooltips[counter2]['over'];
				}
			}
		}, this, true);
		Ext.get(tooltip['target']).on('mouseout', function(e){
			
			for(var counter2=0; counter2<tooltips.length; counter2++){
				if(e.target.id == tooltips[counter2]['target']){
					//air.trace(tooltips[counter2]['target']);
					Ext.getDom(tooltips[counter2]['target']).src = tooltips[counter2]['out'];
				}
			}
		}, this, true);
	
	}
}

/**
 * Gets the content for the top bar of the air application
 */
function getHeaderHTML(){
	var headerHTML = 	'<div style="margin-right:22px;margin-left:22px;margin-top:16px;">' +
						'<div class="ndiip_header"">'+
							'<div id="crap-button1" style="float:left"><img width="270px" src="img/emet_logo.gif" alt="N_TITLE"/></div>'+
						    '<div id="crap-button2" style="float:right;">'+
								
								'<img id="browse-button"  src="img/emet_btn_select_images_off.gif" alt="NDIPP_TITLE" style="padding-left:10px"/>'+
						        '<img id="process-button" src="img/emet_btn_extract_data_off.gif" alt="NDIPP_TITLE" style="padding-left:10px"/>'+
						        '<img id="clear-button"   src="img/emet_btn_clear_images_off.gif" alt="NDIPP_TITLE" style="padding-left:10px"/>'+
						        '<img id="setting-button" src="img/emet_btn_settings_off.gif" alt="NDIPP_TITLE" style="padding-left:10px"/>'+
						        '<img id="help-button"    src="img/emet_btn_help_off.gif" alt="NDIPP_TITLE" style="padding-left:10px"/>'+
						        '<img id="update-button"  src="img/emet_btn_updates_off.gif" alt="NDIPP_TITLE" style="padding-left:10px"/>'+
						        
						    '</div>' +
					    '</div>' +
						'</div>';
	return headerHTML;
}

function updateTotalCountInFooter(){
	//var target = document.getElementById('ndiip_footer_total');
	var target = Ext.get('ndiip_footer_total')
	target.update('<p style="color:white">'+arrayData.length+' Images</p>');
}
/**
 * Gets the content for the top bar of the air application
 */
function getFooterHTML(){
	//'<img id="clear-button"   src="img/emet_btn_clear_images_off.gif" alt="NDIPP_TITLE" style="padding-left:10px"/>'+				        
	//'<div class="ndiip_footer" style="padding:22;float:22">'+
    
	//'<div id="p2" style="padding-top:5;padding-bottom:5;padding-right:22;padding-left:22"></div>'+//<br/>'+				
	var footerHTML = 	''+//'<button id="btn2">Show</button><br />'+
    					'<div style="padding-top:5;padding-bottom:5;padding-right:22;padding-left:22;">'+
							'<table width="100%" style="float:left;">'+
								'<tr>'+
									'<td width="97%" style="float:left;">'+
										'<div id="p2"></div>'+
									'<td/>'+
									'<td width="3%" style="float:right;">'+
										'<img id="pbar-cancel" src="img/emet_btn_clear_bar_off.gif" style="width:20px;height:20px"/>'+	
									'<td/>'+
								'</tr>'+	       
							'</table>'+ 
						'</div>'+
						'<div class="ndiip_footer" style="padding-right:22;padding-left:22">'+
							'<div style="float:left;padding-top:5;">'+
								'<img src="img/emet_artstor_logo.gif"/>'+
						    '</div>'+
							/*'<div style="float:left;padding-top:3;padding-left:10">'+
								'<a target="_blank" href="http://www.artstor.org/our-organization/o-html/privacy-policy.shtml">'+
									'<p style="color:white;font-size:12px;font-family:Times">Privacy Policy</p>'+
								'</a>'+
						    '</div>'+*/
							'<div style="float:left;padding-top:3;padding-left:7">'+
								'<a target="_blank" href="http://www.artstor.org/global/g-pdf/emet-terms-of-use.pdf">'+
									'<p style="color:white;font-size:12px;font-family:Times">Terms of Use</p>'+
								'</a>'+
						    '</div>'+
							'<div id="ndiip_footer_total" style="float:right">'+ //padding-top:5;padding-bottom:5;
								'<p style="color:white">0 Images</p>'+
						    '</div>'+
					    '</div>';
	return footerHTML;
}

function xmlTest(){
	var xmlexample = "\
	<a>\
		<tiff:BitsPerSample>\
            <rdf:Seq>\
               <rdf:li>16</rdf:li>\
               <rdf:li>16</rdf:li>\
               <rdf:li>16</rdf:li>\
            </rdf:Seq>\
         </tiff:BitsPerSample> \
		<xmpMM:History>\
            <rdf:Seq>\
               <rdf:li rdf:parseType=\"Resource\">\
                  <stEvt:action>created</stEvt:action>\
                  <stEvt:instanceID>xmp.iid:E82A1390C52068119109CEE0353D89D7</stEvt:instanceID>\
				  <stEvt:when>2010-02-02T11:37:18-05:00</stEvt:when>]\
                  <stEvt:softwareAgent>Adobe Photoshop CS4 Macintosh</stEvt:softwareAgent>\
               </rdf:li>\
			   <rdf:li rdf:parseType=\"Resource\">\
				   <stEvt:action>saved</stEvt:action>\
				   <stEvt:instanceID>xmp.iid:E92A1390C52068119109CEE0353D89D7</stEvt:instanceID>\
				   <stEvt:when>2010-02-02T11:37:18-05:00</stEvt:when>\
				   <stEvt:softwareAgent>Adobe Photoshop CS4 Macintosh</stEvt:softwareAgent>\
				   <stEvt:changed>/</stEvt:changed>\
				</rdf:li>\
            </rdf:Seq>\
         </xmpMM:History>\
 	</a>\
	";
	var parseresult = startParser(xmlexample);
	/*
	for(var key in parseresult){
		air.trace("==>"+key+"\t\t"+parseresult[key]);
	}
	*/
}

/**
 * Command Line Interface Macro to schedule processing
 */
function cliProcessingStart(){
	air.trace("Analysing Command Line Arguments");
	var flist = [];
	air.trace("Analysing Command Line Arguments");
	if(invocation_arguments !== null){
		air.trace("Analysing Command Line Arguments");
		if(invocation_arguments.length > 1){
			if (invocation_arguments[0] == 'pload') {
				air.trace("M2");
				cli_perf_mode = true;
				for (var i = 1; i < invocation_arguments.length; i++) {
					var file = new air.File()
					file.nativePath = invocation_arguments[i];
					flist.push(file);
				}
				air.trace("Invoking RP on Flist", flist.length);
				recursiveProcessor(flist);
				insertFileObjectInStoreProcess();
			//Terminate
			}
			else if (invocation_arguments[0] == 'load') {
				for (var i = 1; i < invocation_arguments.length; i++) {
					var file = new air.File()
					file.nativePath = invocation_arguments[i];
					flist.push(file);
				}
				recursiveProcessor(flist);
				insertFileObjectInStoreProcess();
			}
		}
	}
}

/**
 * Entry Point of application
 * - Draws All UI Elements
 * - Registers Callbacks to Buttons
 * - Inserts ToolTips
 */
function basicLayout(){
	air.NativeApplication.nativeApplication.addEventListener(air.InvokeEvent.INVOKE,function (event){
		invocation_arguments = event.arguments;
		cliProcessingStart();
	});
	populateMappings();
	if (Ext.isWebKit && !cli_perf_mode) {
		init();
	}
	win = window.nativeWindow;
	opener = Ext.air.NativeWindow.getRootHtmlWindow();
	log_debug_info(opener);
	drawThumbnailView();
	bl2();
	/*
	 * Registers Callbacks to the various process buttons involved
	 */
	Ext.get('clear-button').on('click', function(e){
		//air.trace("Cleared");
		clear_store();
	});
	Ext.get('browse-button').on('click', function(e){
		//air.trace("Browse");
		browse_button();
	});
	
	Ext.get('update-button').on('click', function(e){
		//air.trace("Update");
		checkForUpdate();
	});
	
	Ext.get('setting-button').on('click', function(e){
		if(stopClicksWhenProcessing()){
			return;
		}
		var artstor_csv_prefix = new Ext.form.TextField({
		 	fieldLabel: 'Error Report Prefix',
	        name: 'ArtStorCSVPrefix',
			allowBlank:false,
			value: csv_error_prefix,
			disabled:csv_error_prefix_flag,
			vtype: 'alphanum',
			});
		var all_csv_prefix = new Ext.form.TextField({
		 	fieldLabel: 'Extract Prefix',
	        name: 'AllCSVPrefix',
			allowBlank:false,
			value: csv_all_prefix,
			vtype: 'alphanum',
			});
		var is_cvs_error=new Ext.form.Checkbox({
			fieldLabel : 'Generate Error Report?',
			name:'radioErrorRpt',
			checked: cvs_is_error
			});
		is_cvs_error.on('check', function(arg){
			csv_error_chk_flag=this.getValue();
			artstor_csv_prefix.setDisabled(!csv_error_chk_flag);
		});
		
		csv_error_chk_flag = cvs_is_error;
		//csv_error_chk_flag=this.getValue();
	 	artstor_csv_prefix.setDisabled(!csv_error_chk_flag);
		
		var message_str = "Change Location from Documents Directory";
		if(csv_location_changed){
			message_str = 'Change Location from ' + csv_location;
		}
		button_1 = { 
						text: message_str,
						handler:function(){
								var csv_loc = new air.File(); 
								csv_loc.addEventListener(air.Event.SELECT, dirSelected); 
								csv_loc.browseForDirectory("Select a directory"); 
								function dirSelected(event) {
									csv_location = csv_loc.nativePath;
									csv_location_changed = true;
									Ext.MessageBox.alert(appName, "Location changed to "+ csv_loc.nativePath +
																	'\nButton text will be updated next time you open settings'
									);
									//button_1.setText('test');
								}									
							}
						};
	
		
		var w = new Ext.Window({
			width: 280,
			height: 200,
			modal: true,
			layout: 'form',
			items:[	all_csv_prefix,
					artstor_csv_prefix,
					is_cvs_error,
					{buttons: [button_1]}
			],
			});
		w.addButton('Save', function() {
			if(all_csv_prefix.isValid() && artstor_csv_prefix.isValid()){
				csv_error_prefix = artstor_csv_prefix.getValue();
				csv_all_prefix = all_csv_prefix.getValue();
				cvs_is_error=is_cvs_error.getValue();
				csv_error_prefix_flag=!csv_error_chk_flag;
				w.hide();
			}
			else{
				Ext.MessageBox.alert(appName, 'Please Input Non Empty Valid AlphaNumerics')
			}
		});
	    //w.addKeyListener(27, w.hide, w); 
		w.addButton('Cancel', function() {w.hide();});
		w.show();
		/*
		Ext.get('csv_upload').on('click', function(e){
			var csv_loc = new air.File(); 
			csv_loc.addEventListener(air.Event.SELECT, dirSelected); 
			csv_loc.browseForDirectory("Select a directory"); 
			function dirSelected(event) {
				csv_location = csv_loc.nativePath;
				csv_location_changed = true;
				Ext.MessageBox.alert(appName, "Location changed to "+ csv_loc.nativePath);
			}
		});
		*/
	});
	Ext.get('help-button').on('click', function(e){
		//air.trace("Help");
		help_button();
	});
	Ext.get('process-button').on('click', function(e){
		//air.trace("Process");
		process_button();
	});
	Ext.get('pbar-cancel').on('click', function(e){
		if (recursorRunning) {
			recursorRunning = false;
			progressBarReset();
		}
		else{
			Ext.MessageBox.alert(appName, "There is no ongoing processing to cancel");
		}
	})
	insertToolTips();
	progressBar();
}

/*
 * Draws the viewport for the main application placement
 */
function bl2(){
	var viewport = new Ext.Viewport({
		layout: 'border',
		border: false,
		split: false,
		renderTo: Ext.getBody(),
		items: [
		/* This Region is just for providing a spacer */
		{
			region: 'north',
			xtype: 'panel',
			html: getHeaderHTML(),
			height: 95,
			bodyStyle: 'background-color:#666666;border: 0px;',
		}, 
		/* This Region is just for providing a spacer */
		{
			region: 'west',
			xtype: 'panel',
			html: '&nbsp;',
			width: 22,
			bodyStyle: 'background-color:#666666;border: 0px;',
		}, 
		/* This is the body of the app which houses the viewer */
		thumbnailregion,
		/* This Region is just for providing a spacer */
		{
			region: 'east',
			xtype: 'panel',
			html: '&nbsp;',
			width: 22,
			bodyStyle: 'background-color:#666666;border: 0px;',
		}, 
		/* This Region is for the bottom options of the application */
		{
			region: 'south',
			height: 60,
			xtype: 'panel',
			html: getFooterHTML(), //'&nbsp;',
			//html: '<p>Loading Bar [-----] </p><br/><p>Browse, Upload, Done/Total</p>',
			bodyStyle: 'background-color:#666666;border: 0px;',
		}]
	});
	
	/*
	 * Subscribe View Grid to UI Callbacks
	 * - Drag/Drop
	 */
	var target = document.getElementById('images-view-grid');
	target.addEventListener("dragenter", dragEnterOverHandler); 
	target.addEventListener("dragover", dragEnterOverHandler); 
	target.addEventListener("drop", dropHandler);
}

/*
 * -----------------------------------------
 * Callbacks for UI events on Selection Grid
 * -----------------------------------------
 */

/*
 * This is the callback function for a drop Event
 */
function dropHandler(event){
	if(stopClicksWhenProcessing()){
		return;
	}
	var selList = event.dataTransfer.getData("application/x-vnd.adobe.air.file-list");
	//var ts1 = getTimeStamp();
	//alert("Start Recursive Processor");
	
	var precount = insert_cache_fl_names.length;
	noneMatch = true;
	recursiveProcessor(selList);
	
	if (noneMatch) {
		Ext.MessageBox.alert(appName, "The selection does not contain any jpg or tiff files.");
	}
	
	var postcount = insert_cache_fl_names.length;
	if(precount == postcount){
		//Turn recursor off
		recursorRunning = false;
	}
	else{
		insertFileObjectInStoreProcess();
	}
	//var ts2 = getTimeStamp();
	//alert(ts1 +"   "+ ts2);
}
function dragEndHandler(event){
	//air.trace(event.type + ": " + event.dataTransfer.dropEffect);
}
function dragEnterOverHandler(event){
	event.preventDefault();
}

/*
 * -----------------------------------------
 * Miscellaneous Utility Functions
 * -----------------------------------------
 */
/*
 * Gets Timestamp
 */
function getTimeStamp(){
	var dt = new Date();
	var dt_stamp =  ''+dt.getFullYear()+'_'+
					(dt.getMonth()+1)+'_'+	//Month is counted by default from 0 to 11, hence 1 is added
					dt.getDate()+'_'+
					dt.getHours()+'_'+
					dt.getMinutes()+'_'+
					dt.getSeconds();
	return dt_stamp;
}
/*
 * Function to write CSV Content
 */
function write_csv(csv_content, mode){
	var flname = '';
	if (mode == 1) {
		flname = csv_error_prefix + getTimeStamp() + '.csv';
	}
	if (mode == 2) {
		flname = csv_all_prefix + getTimeStamp() + '.csv';
	}
	if (mode == 3) {
		flname = csv_exif_prefix + getTimeStamp() + '.csv';
	}
	var file;
	if (csv_location_changed) {
		file = new air.File();
		file.nativePath = csv_location + '/' + flname;
	}
	else {
		file = air.File.documentsDirectory.resolvePath(flname);
	}
	var stream = new air.FileStream();
	stream.open(file, air.FileMode.WRITE);
	stream.writeMultiByte(csv_content, air.File.systemCharset);
	stream.close();

	if (!cli_perf_mode) {
		file.openWithDefaultApplication();
	}
	return flname;
}
/*
 * The function will check the ArtStor Panel Column 
 * for All Images before generating Extraction Report
 */
function chkASPanBExtract(){
	var unpresent_indices = []
	for (var i = 0; i < arrayData.length; i++) {
		if (arrayData[i][5] == 'No' ||
			arrayData[i][5] == 'NA') {
			//unpresent_indices.push(i);
			unpresent_indices.push(arrayData[i][1]);
		}
	}
	if (csv_error_chk_flag || unpresent_indices.length > 0) {
		recursiveCall(0, unpresent_indices);
	}
	else{//Take directly to end case
		extracter_new(csv_error_chk_flag);
	}
}

function  recursiveCall(index,indexlist){
	if(index>=indexlist.length){	//Termination Case
		extracter_new(csv_error_chk_flag);
		return;
	}
	else{
		Ext.Msg.show({
			title:'Do you want to continue?', 
			msg:'ArtStor Panel is not present for '+indexlist[index]+'\n',
			fn: function(btn){
				switch(btn){ 
					case 'yes':
						recursiveCall(index + 1, indexlist);
						break;
					case 'no':
						extracter_new(csv_error_chk_flag);
						break;
					case 'cancel':
						return;
						break;
				}
			},
			buttons:{
				yes:'Yes',
				cancel:'No',
				no:'Continue All'
			}
		});
	}
}
