/*
 * Inserts File Object into Store
 * 
 * Example Usage:-
	pseudo_recursor.action = function (){
		//Long Running Heavy Process
		globalSpaceProcessingFunction(this.li[this.index]);
		// this.li -> is the reference to the list itself
		// this.index -> reference to the index that its supposed to process
	},
	pseudo_recursor.ignition(workList, 0, null, null, null);

Good Bye and Good Day
 */
var recursorRunning = false;

var pseudo_recursor = {
	ignition: function (li, index, next, action, ignition){
		if (next !== null){
			this.next = next;
		}
		else{
			//first Invocation
			recursorRunning = true;
		}
		if (action !== null){
			this.action = action;
		}
		if (ignition !== null){
			this.ignition = ignition
		}
		this.li = li;
		this.index = index;
		this.next();
	},
	next : function (){
		if(!recursorRunning){
			return;
		}
		var action = this.action;
		var index = this.index+1;
		var li = this.li;
		var next = this.next;
		var action = this.action;
		var ignition = this.ignition;
		
		if(this.index < this.li.length){
			this.action(this.index);
			setTimeout(function (){ignition(li, index, next, action, ignition)},10);
		}		
	},
	action : function (){
		//Do Nothing Prototype
	},
}