/*
 * @author afrobeard
 * 
 * This is the adapter that lets you Cache Function Results off local SQL Lite Database
 * For Example usage please see test function at the end of this file
 */
ArrayCache = {
	'datastore' : {},
	'bootStrap' : function (){},	//Do Nothing
	'cleanup' : function (){},		//Do Nothing
	'retreiveRecord': function (name, key){
						if (name in this.datastore) {
							if(key in this.datastore[name]){
								return this.datastore[name][key];
							}
						}
						return false;
					},
	'storeRecord': function(name, key, value){
						if (name in this.datastore) {
							//pass
						}
						else{
							this.datastore[name] = {}
						}
						this.datastore[name][key] = value;
					}
}

DbCache = {
	'dbfile': null,
	'conn': null,
	'tempFile': null,
	'cleanup' : function (){
		if (this.tempFile != null) {
			this.tempFile.deleteFile();
			this.tempFile = null;
		}
	},
	'connect': function (){
					this.conn = new air.SQLConnection();
					this.tempFile = air.File.createTempFile();
					//alert(this.tempFile.nativePath);
					try {
						this.conn.open(this.tempFile);
						return true;
					}
					catch(e){
						air.trace(e);
						return false;
					}
				},
	'execute': function (sql, mode, param){
					//air.trace("Executing, ", sql, "with", JSON.stringify(param));
					var stmt = new air.SQLStatement();
					stmt.sqlConnection = this.conn;
					stmt.text = sql;
					for(var pkey in param){
						stmt.parameters[pkey] = param[pkey];
					}
					try{
						stmt.execute();
						if (mode == "silent") {
							return true;
						}
						else if(mode == "response"){
							return stmt.getResult();
						}
					}catch(e){
						air.trace(e);
					}
					return false;
				},
	'clearCache': function (){			
						var sql = "DROP TABLE IF EXISTS cache";
						return this.execute(sql, "silent", {});
					},
	'initTable': function (){
					var sql = "CREATE TABLE IF NOT EXISTS cache(" +
								"id INTEGER PRIMARY KEY AUTOINCREMENT," +
								"name VARCHAR2(200)," +
								"key VARCHAR2(200)," +
								"value TEXT )";
					return this.execute(sql, "silent", {});
					},
	'bootStrap': function (){
						air.trace("Connecting", this.connect());
						//air.trace("Clearing table", this.clearCache());
						air.trace("Making new table for run", this.initTable());
					},
	'escapeQuotes' : function (instr){
		return instr.replace("'", "''");
	},
	'retreiveRecord': function (name, key){
						var sql = "SELECT value FROM cache WHERE name=:name AND key=:key";
						var response = this.execute(sql, "response", {':name':name,
																	  ':key':key});
						//air.trace("RD", response.data);
						if(response.data !== null){
							if (response.data.length > 0) {
								return JSON.parse(response.data[0].value);
							}
						}
						return false;
					},
	'storeRecord': function (name, key, value){
						var sql = "INSERT INTO cache (name,key,value)"
									+ "VALUES (:name,:key,:value)";
						return this.execute(sql, "silent", {':name':name,
															':key':key,
															':value':JSON.stringify(value)});
					}
}
DbCache = ArrayCache;	//This line makes use of in memory store rather than SQL Lite
function testCAdapter(){
	DbCache = ArrayCache;
	DbCache.bootStrap();
	//Get unknown Record
	air.trace(DbCache.retreiveRecord('f1', 'mojo'));
	//Insert key
	air.trace(DbCache.storeRecord('f2', 'jojo', 'the juggernaut'));
	//Get that key
	air.trace(DbCache.retreiveRecord('f2', 'jojo'));
	
	//Insert key
	air.trace(DbCache.storeRecord('f2', "hello", "jo'j''o"));
	//Get that key
	air.trace(DbCache.retreiveRecord('f2', "hello"));
	
	//Insert Json obj
	air.trace(DbCache.storeRecord('f3', 'jojo', {'asf':23, 'asff':'23242'}));
	//Get Json obj
	air.trace("One Sec", DbCache.retreiveRecord('f3', 'jojo'));
	var abc = DbCache.retreiveRecord('f3', 'jojo');
	air.trace("Okay", abc);
	for(var key in abc){
		air.trace(key, abc[key]);
	}
	//Sanitization
}