var xmlTextArray
var xmlTextListArray
var xmlAttrListArray

var xmlCDataArray
var xmlAttrArray
var console = {};
console.log = function (logtext){
	air.trace(logtext);
}
function showTagInfo(xpath){
    var textValue = trim(xmlTextArray[xpath]);
    if (textValue == "" || textValue == null) {
        textValue = "No text value for this node";
    }
    var cdataValue = trim(xmlCDataArray[xpath]);
    if (cdataValue == "" || cdataValue == null) {
        cdataValue = "No CDATA value for this node";
    }
    var tagRepr={'xpath':xpath, 'textValue':textValue, 'cdataValue': cdataValue,'textList': [], 'attrObj':{}};
	if(xpath in xmlTextListArray){
		tagRepr.textList = xmlTextListArray[xpath];
	}
	if(xpath in xmlAttrArray){
		var current = xmlAttrArray[xpath];
		for(var key in current){
			if(typeof(current[key]) != 'function'){
				tagRepr.attrObj[key] = current[key];
			}
		}
	}
	//air.trace(xmlTextArray[xpath]);
	//air.trace(xmlCDataArray[xpath]);
	//air.trace('\n');
	
	//air.trace(tagRepr.textValue);
	//air.trace(tagRepr.cdataValue);
	return tagRepr;
} // end function showTagInfo

/*
 * Parser 2 Requirements : History is a special Case need to use the same method
 * 
 * Other than history: Try to Extract Properties from fields inside rdf Description in addition to rdf Description
 * 
 * Exclusions are elements that are nested e.g. lists
 * Properties that have a dependence on a tag name inside rdf:Description
 */

function startParser(ixml) {
	var parsed_result = {};
	var arr,src='' ,parser = new SAXDriver();
    var handler = new xmlHandler();
    
    // pass handlers to the sax2 parser
    parser.setDocumentHandler(handler);
    parser.setErrorHandler(handler);
    parser.setLexicalHandler(handler);

    parser.parse(ixml);// start parsing

    // get errors from sax2 parser
    var err='\n'+handler.getError();
    xmlTextArray=handler.getText_Array();
    xmlTextListArray=handler.getTextList_Array();

    xmlCDataArray=handler.getCDATA_Array();
    xmlAttrArray=handler.getAttr_Array();
    xmlAttrListArray=handler.getAttrList_Array();

    arr=handler.getPath_Array();
	
	var sequenceContainers = [];
	var removalList = {};
	
	for (var i=0;i<arr.length;i++){
		var tagpath = arr[i];
		air.trace("--", tagpath);
		var split_elements = tagpath.split('/');
		var split_len = split_elements.length;
		
		if(split_elements[split_len-1].toLowerCase() == "rdf:li"){
			//Case 1: Sequence Type of RDF Description
			//split_len-2 is sequence container could be rdf:Seq or rdf:Bag or rdf:Alt
			var malformed = false;
			switch(split_elements[split_len-2].toLowerCase()){
				case "rdf:seq":
					break;
				case "rdf:bag":
					break;
				case "rdf:alt":
					break;
				default:
					malformed = true;
					break;
			}
			if(malformed){
				continue
			}
			if(split_len >=5){
				if (split_elements[split_len - 3].toLowerCase() == 'rdf:li') {
					if (split_elements[split_len - 4].toLowerCase() in {'rdf:seq': '','rdf:bag': '','rdf:alt': ''}) {
						var tag_name = split_elements[split_len-5];
						for(var subkey in xmlAttrListArray[tagpath]){
							parsed_result[tag_name+":"+subkey] = xmlAttrListArray[tagpath][subkey].join(',');
						}
						parsed_result[tag_name] = xmlTextListArray[tagpath].join(",");
						continue;
					}
				}
			}
			
			var tag_name = split_elements[split_len-3];
			var nodeinfo = showTagInfo(tagpath);
			
			if(tag_name == "xmpMM:History"){//Being Handled specially Later
				continue;
			}
			//air.trace(tag_name);
			air.trace("text Value" + nodeinfo.textValue);
			//air.trace("textList" + nodeinfo.textList.join('*'));
			console.log("cData Value " + nodeinfo.cdataValue);
			
			if (xmlAttrListArray[tagpath] !== undefined) {
				for (var k1 in xmlAttrListArray[tagpath]) {
					//air.trace("Inputting");
					//air.trace(k1);
					//air.trace(xmlAttrListArray[tagpath][k1].join(','));
					parsed_result[tag_name + ":" + k1] = xmlAttrListArray[tagpath][k1].join(',');
					removalList[k1] = "";
				}
			}
			

			//This line will populate by default however, proceeding default behaviour could be overwritten with ease 
			parsed_result[tag_name] = nodeinfo.textList.join(',');
		}
		else if(split_elements[split_len-2].toLowerCase() == "rdf:description"){
			//Case 2: Child of RDF:Description. Obviously this would contain properties
			
			//Browse in properties. if a valid property is found, make it so: tagname:property:value
			
			//air.trace(tagpath);
			var tag_name = split_elements[split_len-1];
			if(tag_name == "xmpMM:History"){//Being Handled specially Later
				continue;
			}
			//air.trace(tag_name);
			var nodeinfo = showTagInfo(tagpath);
			if (xmlAttrListArray[tagpath] !== undefined) {
				for (var k1 in xmlAttrListArray[tagpath]) {
					//air.trace("Inputting");
					//air.trace(k1);
					//air.trace(xmlAttrListArray[tagpath][k1].join(','));
					parsed_result[tag_name + ":" + k1] = xmlAttrListArray[tagpath][k1].join(',');
					removalList[k1] = "";
				}
			}
		}
	}
	
	//Below is logic for the much needed history fields
	
	var historySig = "/xmpMM:History/rdf:Seq/rdf:li";
	var historyPacket = false;
	var historyTagNum = -1;
	var historyTagList = [];
	//First Loop to try to get History Fields
    for (var i=0;i<arr.length;i++){
		var tagpath = arr[i];
        var nodeinfo = showTagInfo(tagpath);
		
		if(tagpath.search(historySig) >= 0){
			//air.trace("Pickle");
			if((tagpath.search(historySig) + historySig.length) == tagpath.length){
				//air.trace("!" + tagpath)
				historyPacket = true;
				historyTagNum = historyTagNum + 1;
				historyTagList.push({});
				for(var key in nodeinfo.attrObj){
					var nattrval = nodeinfo.attrObj[key];
					console.log("->" + key + " " + nattrval);
					historyTagList[historyTagNum][key] = nattrval;
				}
			}
			else{
				var tagparts = tagpath.split('/');
				var tagend = tagparts[tagparts.length - 1];
				//air.trace("!!" + tagpath);
				if(historyTagList[historyTagNum]){
					historyTagList[historyTagNum][tagend] = nodeinfo.textValue;
				}
			}
		}
		else{
			//EndPacket
			historyPacket = false;
			//historyTagNum = historyTagNum + 1;
		}

    }
	
	
	//Final Loop looks for attributes that might have been missed
    for (var i = 0; i < arr.length; i++) {
		var tagpath = arr[i];
		var nodeinfo = showTagInfo(tagpath);
		var split_elements = tagpath.split('/');
		var split_len = split_elements.length;
		
		//If xmpMM:History in Path then Ignore		
		//Experimental
		if (split_elements[split_len - 1].toLowerCase() == "rdf:description") {			
			if (xmlAttrListArray[tagpath] !== undefined) {
				for (var k1 in xmlAttrListArray[tagpath]) {
					parsed_result[k1] = xmlAttrListArray[tagpath][k1].join(',');
					//removalList[k1] = "";
				}
			}
			/*
			if (xmlAttrArray[tagpath] !== undefined) {
				for(key in xmlAttrArray[tagpath]){
					if(typeof(xmlAttrArray[tagpath][key]) == "string"){
						if(!(key in parsed_result)){
							air.trace(tagpath + " ]][[ " + key + " ]][[ " + xmlAttrArray[tagpath][key]);
							parsed_result[key] = xmlAttrArray[tagpath][key];
						}
					}
				}
			}
			*/
		}
	}
	
	var historyTagListFormatted = [];
	//console.log(historyTagList.length);
	for(var i=0; i< historyTagList.length; i++){
		var tag = "xmpMM:History" + "[" + i + "]";
		var tagvallist = [];
		//air.trace(i + " " + historyTagList[i]);

		if(!('stEvt:action' in historyTagList[i])){
			if(i > 0){
				if ('stEvt:action' in historyTagList[i-1]) {
					historyTagList[i]['stEvt:action'] = historyTagList[i-1]['stEvt:action'];
				}
			}
		}
		
		for(var key in historyTagList[i]){
			tagvallist.push(key + ":" + historyTagList[i][key]);
			//console.log(i + " " + key + " " + historyTagList[i][key]);
		}
		
		var tagval = tagvallist.join('|');
		parsed_result[tag] = tagval;
	}
	return [parsed_result, removalList];
}// end function startParser
xmlHandler = function() {
    this.m_strError=''
    this.m_treePath=[]
    this.m_xPath=[''] // stores current path info
    this.m_text=['']
	this.m_textList=['']
    this.m_cdata=['']
    this.m_attr=['']
	this.m_attrList=['']
    this.m_pi=['']
    this.cdata=false
}
xmlHandler.prototype.characters = function(data, start, length) {
    // capture characters from CDATA and Text entities
    var text=data.substr(start, length);
    if (text=='\n' ) return null // get ride of blank text lines
    if (this.m_treePath.length>0){
        if(this.cdata==false){
            if (!this.m_text[this.m_xPath.join('/')]) {
                this.m_text[this.m_xPath.join('/')]='';
            }
            this.m_text[this.m_xPath.join('/')]+=text;
			
			if(this.m_xPath.join('/') in this.m_textList){
				this.m_textList[this.m_xPath.join('/')].push(text);
			}
			else{
				this.m_textList[this.m_xPath.join('/')] = [text];				
			}
			
        }
        else {
            if (!this.m_cdata[this.m_xPath.join('/')]) {
                this.m_cdata[this.m_xPath.join('/')]='';
            }
            this.m_cdata[this.m_xPath.join('/')]+=text;	//I beleive you are the culprit
        }
    }

} // end function characters
xmlHandler.prototype.comment = function(data, start, length) {
    var comment=data.substr(start, length)
} // end function comment
xmlHandler.prototype.endCDATA = function() {
    // end of CDATA entity
    this.cdata=false
} // end function endCDATA
xmlHandler.prototype.endDocument = function() {
} // end function end Document
xmlHandler.prototype.endElement = function(name) {
    this.m_xPath=this.m_xPath.slice(0,-1)
} // end function endElement
xmlHandler.prototype.error = function(exception) {
    this.m_strError+='Error:'+exception.getMessage()+'\n'
} // end function error
xmlHandler.prototype.fatalError = function(exception) {
    this.m_strError+='fata error:'+exception.getMessage()+'\n'

} // end function fatalError
xmlHandler.prototype.getTextList_Array= function() {
    return this.m_textList;
}   // end function getAttr_Array
xmlHandler.prototype.getAttr_Array= function() {
    return this.m_attr;
}   // end function getAttr_Array
xmlHandler.prototype.getAttrList_Array= function() {
    return this.m_attrList;
}   // end function getAttr_Array
xmlHandler.prototype.getCDATA_Array= function() {
    return this.m_cdata;
}  // end function getCDATA_Array
xmlHandler.prototype.getError = function() {
    return this.m_strError;
}  // end function getError
xmlHandler.prototype.getPath_Array = function() {
	return this.m_treePath;
}  // end function getPath_Array
xmlHandler.prototype.getText_Array = function() {
    return this.m_text;
} // getTextArray
xmlHandler.prototype.processingInstruction = function(target, data) {
} // end function processingInstruction
xmlHandler.prototype.setDocumentLocator = function(locator) {
    this.m_locator = locator;
}  // end function setDocumentLocator
xmlHandler.prototype.startCDATA = function() {
    this.cdata=true
} // end function startCDATA
xmlHandler.prototype.startDocument = function() {
} // end function startDocument
xmlHandler.prototype.startElement = function(name, atts){
    var cpath,att_count=atts.getLength()
    this.m_xPath[this.m_xPath.length]=name
    cpath=this.m_xPath.join('/')
    this.m_treePath[this.m_treePath.length]=cpath
	
    if (att_count) {
        var attr={}
		if(cpath in this.m_attrList){
			//Pass
		}
		else{
			this.m_attrList[cpath] = {}
		}
        for (i=0;i<att_count;i++){
			var key = atts.getName(i);
            attr[key]=atts.getValue(i)
			if(key in this.m_attrList[cpath]){
				this.m_attrList[cpath][key].push(attr[key]);
			}
			else{
				this.m_attrList[cpath][key] = [attr[key]];
			}
        }
        this.m_attr[cpath]=attr;
    }
} // end function startElement
xmlHandler.prototype.warning = function(exception) {
    this.m_strError+='Warning:'+exception.getMessage()+'\n'
} // end function warning


