/**
 * @author Iqbal Talaat Bhatti
 */

EXIF_TAG_MAP = {
	0x9202: 'ApertureValue',
	0x0102: 'BitsPerSample',
	0x9203: 'BrightnessValue',
	0xa001: 'ColorSpace',		
	0x0103: 'Compression',
	0x0132: 'DateTime',				
	0x829a: 'ExposureTime',
	0x829d: 'FNumber',			
	0x0101: 'ImageLength',			
	0xa420: 'ImageUniqueID',	
	0x0100: 'ImageWidth',			
	0x8827: 'ISOSpeedRatings',	
	0x010f: 'Make',					
	0x0110: 'Model',				
	0x0112: 'Orientation',			
	0x0128: 'ResolutionUnit',
	0x0115: 'SamplesPerPixel',		
	0x9201: 'ShutterSpeedValue',	
	0x0131: 'Software',				
	0x011a: 'XResolution',
	0x011b: 'YResolution',
	
	
	//0x00fe: 'NewSubFileType',
	//0x0106: 'PhotometricInterpretation',
	0x010a: 'FillOrder',
	0x010d: 'DocumentName',
	0x010e: 'ImageDescription',
	0x0111: 'StripOffsets',
	0x0116: 'RowsPerStrip',
	0x0117: 'StripByteCounts',

	0x011c: 'PlanarConfiguration',
	0x0128: 'ResolutionUnit',
	0x012d: 'TransferFunction',
	0x013b: 'Artist',
	0x013e: 'WhitePoint',
	0x013f: 'PrimaryChromaticities',
	0x0142: 'TileWidth',
	0x0143: 'TileLength',
	0x0144: 'TileOffsets',
	0x0145: 'TileByteCounts',
	0x014a: 'SubIFDs',
	0x0156: 'TransferRange',
	0x015b: 'JPEGTables',
	0x0201: 'JPEGInterchangeFormat',
	0x0202: 'JPEGInterchangeFormatLength',
	0x0211: 'YCbCrCoefficients',
	0x0212: 'YCbCrSubSampling',
	0x0213: 'YCbCrPositioning',
	0x0214: 'ReferenceBlackWhite',
	0x828d: 'CFARepeatPatternDim',
	0x828e: 'CFAPattern',
	0x828f: 'BatteryLevel',
	0x8298: 'Copyright',
	0x83bb: 'IPTC_NAA',
	0x8773: 'InterColorProfile',
	0x8822: 'ExposureProgram',
	0x8824: 'SpectralSensitivity',
	0x8825: 'GPSInfo',
	0x8828: 'OECF',
	0x8829: 'Interlace',
	0x882a: 'TimeZoneOffset',
	0x882b: 'SelfTimerMode',
	0x8769: 'ExifOffset',
	0x9000: 'ExifVersion',
	0x9003: 'DateTimeOriginal',
	0x9004: 'DateTimeDigitized',
	0x9101: 'ComponentsConfiguration',
	0x9102: 'CompressedBitsPerPixel',
	0x9204: 'ExposureBiasValue',
	0x9205: 'MaxApertureValue',
	0x9206: 'SubjectDistance',
	0x9207: 'MeteringMode',
	0x9208: 'LightSource',
	0x9209: 'Flash',
	0x920a: 'FocalLength',
	0x920b: 'FlashEnergy',
	0x920c: 'SpatialFrequencyResponse',
	0x920d: 'Noise',
	0x920e: 'FocalPlaneXResolution',
	0x920f: 'FocalPlaneYResolution',
	0x9210: 'FocalPlaneResolutionUnit',
	0x9211: 'ImageNumber',
	0x9212: 'SecurityClassification',
	0x9213: 'ImageHistory',
	0x9214: 'SubjectLocation',
	0x9215: 'ExposureIndex',
	0x9216: 'TIFF_EPStandardID',
	0x9217: 'SensingMethod',
	0x927c: 'MakerNote',
	0xa002: 'ExifImageWidth',
	0xa003: 'ExifImageHeight',
	0xa005: 'Interoperability_IFD_Pointer',
	
}


var stream;
var efile;
var efilepath;
var tiff_desc = {};


var sys_enc = air.File.systemCharset;
sys_enc = 'utf_8';	//Hardcoded because it is returning Macintosh
var errors = '';

function parse_exif_tag(value_map){
	//air.trace("Tag Location", stream.position);
	var tag_id = exif_read_short();
	var type_no = exif_read_short();
	var count = exif_read_long();
	var tag = '';
	var sbytes = new air.ByteArray();
	var tag_len;
	var tag_offset;
	
	if(tag_id in EXIF_TAG_MAP){
		tag = EXIF_TAG_MAP[tag_id];
		//air.trace("Acquired " + tag_id + ' type_no ' + type_no + ' tag '+tag + ' count '+count);
		if(type_no == 2){
			tag_len = 1 * count;
			if(tag_len > 4){
				tag_offset = exif_read_long();
				//air.trace("OffSet", tag_offset);
				stream.position = tag_offset;
				//tiff.seek(tag_offset);
			}
			//air.trace("Type 2 Value");
			
			//var tmplist = [];
			
			var tmp_pos_off = stream.position;
			var tmp_len = 0;
			
			while(true){
				var tmp = stream.readByte();
				if(tmp == 0){
					break;
				}
				else{
					//tmplist.push(tmp);
					tmp_len ++;
				}
			}
			//air.trace(tmplist);
			stream.position = tmp_pos_off;
			var tmpval = stream.readUTFBytes(tmp_len)
			//air.trace(tmpval);
			
			value_map[tag] = tmpval;
		}
		if(type_no == 3){
			var tmpval = exif_read_short();
			//air.trace("Type 3 Value", tmpval);
			value_map[tag] = tmpval;
		}
		if(type_no == 5){
			var tmpval = exif_read_long()+ '/'+ exif_read_long();
			//air.trace("Type 5 Value ", tmpval);
			value_map[tag] = tmpval;
		}
	}
	else{
		//air.trace("Skipped" + tag_id);
	}
	return value_map;
}

function exif_read_short(){
	air.trace(stream.position);
	var bytes = new air.ByteArray();
	stream.readBytes(bytes, 0, 2);
	var hi = bytes[tiff_desc['S1']];
	var lo = bytes[tiff_desc['S0']];
	return hi*256 + lo;
}

function exif_read_long(){
	var bytes = new air.ByteArray();
	stream.readBytes(bytes, 0, 4);	
	return ( 4294967296 * bytes[tiff_desc['L3']]
			+65536 * bytes[tiff_desc['L2']]
			+256 * bytes[tiff_desc['L1']]
			+bytes[tiff_desc['L0']]);
}

function parse_tiff_fortiff(){
	var value_map = {};
	var order = new air.ByteArray();
	var stags = [];
	var num_entries;
	
	var pos;
	var tag_id;
	var type_no;
	var length;
	var valoff;
	
	stream.readBytes(order, 0, 2);
	
	//air.trace(order[0] + '-' + order[1]);
	
	if(exif_read_short() == 42){
		//air.trace('S1');
		offset = exif_read_long();
		//air.trace("Offset" + offset);
		stags = [];
		
		while(offset > 0){
			stream.position = offset;
			num_entries = exif_read_short();
			
			//air.trace("IFD " + num_entries + " " + offset);
			for(var cnt=0; cnt<num_entries; cnt++){
				pos = stream.position;
				tag_id = exif_read_short();
				type_no = exif_read_short();
				length = exif_read_long();
				valoff = exif_read_long();
				
				if(tag_id == 34665){
					//arrayData.push([tag_id, valoff]);
					//air.trace("PUL"+tag_id+" "+valoff);
				}
				else if(length < 1024){
					stags.push([tag_id, pos]);
				}
			}
			offset = exif_read_long();
			break;
		}
		
		for(var cnt=0; cnt<stags.length; cnt++){
			tag_id = stags[cnt][0];
			pos  = stags[cnt][1];
			
			if(tag_id == 34665){
				//parse_ifd. We can let this go for now
			}
			else{
				stream.position = pos
				value_map = parse_exif_tag(value_map);
			}
		}
	}

	
	return value_map
}

function fileIsTiffExternal(file_path){
	try {
		efile = new air.File(file_path);
		stream = new air.FileStream();
		stream.open(efile, air.FileMode.READ);
		return fileIsTiff();
	} catch(e){
	}
	return false;
}

function fileIsTiff(){
	//Insert Stricter Checking here.
	
	var data = new air.ByteArray();
	stream.readBytes(data,0,12);
	
	var is_tiff = false;
	
	if(data[0] == 73 && data[1] == 73){
		if(data[2] == 42){
			is_tiff = true;
			
			tiff_desc['S0'] = 0;
			tiff_desc['S1'] = 1;
			tiff_desc['L0'] = 0;
			tiff_desc['L1'] = 1;
			tiff_desc['L2'] = 2;
			tiff_desc['L3'] = 3;
		}
	}
	else if(data[0] == 77 && data [1] == 77){
		if(data[2] == 42){
			is_tiff = true;
			
			tiff_desc['S0'] = 1;
			tiff_desc['S1'] = 0;
			tiff_desc['L0'] = 3;
			tiff_desc['L1'] = 2;
			tiff_desc['L2'] = 1;
			tiff_desc['L3'] = 0;
		}
	}
	else{
		//Not TIFF
	}
	stream.position = 0;
	air.trace("File is TIFF, ", is_tiff);
	return is_tiff;
}
function exif_extracter(file_path){
	air.trace(file_path);
	efilepath = file_path;
	var inp_charset = sys_enc;
	var out_charset = 'utf_8';
	var data = {};	//Empty Data Specifying EXIF Stuff
	var result = null;
	var fh = ''; //Load File Name into handler here
	var bytes = new air.ByteArray();
	
	try {
		//Defined at the top
		//air.trace(efilepath);
		efile = new air.File(file_path);
		stream = new air.FileStream();
		stream.open(efile, air.FileMode.READ);
		if(fileIsTiff()){
			return parse_tiff_fortiff();
		}
	} catch(e){
		//There could be anything possibly wrong with the data/file, hence cry like a baby
		result = null;
	}
	return {};
}


function exif_test(){
	var exif_result;
	
	air.trace("Starting");
	
	//air.trace(fileIsTiffExternal("/Users/afrobeard/test10.tif"));
	
	/*
	exif_result = exif_extracter("/Users/afrobeard/test10.tif");
		
	air.trace('\n\n\n');
	for(var exif_key in exif_result){
		air.trace(exif_key + ':' + exif_result[exif_key]);
	}
	
	*/
}
