/**
 * @author Iqbal Talaat Bhatti
 */
var stream;
var efile;
var efilepath;

var sys_enc = air.File.systemCharset;
sys_enc = 'utf_8';	//Hardcoded because it is returning Macintosh
var errors = '';
var c_marker_err = {	0: "Marker scan failed",						//0
	                	217: "Marker scan hit end of image marker",		//0xd9
	                	218: "Marker scan hit start of image data"}		//0xda
var c_charset = {100: 'iso8859_1', 101: 'iso8859_2', 109: 'iso8859_3',
                  110: 'iso8859_4', 111: 'iso8859_5', 125: 'iso8859_7',
                  127: 'iso8859_6', 138: 'iso8859_8',
                  196: 'utf_8'}
var c_datasets = {
    // 0: 'record version',    // skip -- binary data
    5: 'object name',
    7: 'edit status',
    8: 'editorial update',
    10: 'urgency',
    12: 'subject reference',
    15: 'category',
    20: 'supplemental category',
    22: 'fixture identifier',
    25: 'keywords',
    26: 'content location code',
    27: 'content location name',
    30: 'release date',
    35: 'release time',
    37: 'expiration date',
    38: 'expiration time',
    40: 'special instructions',
    42: 'action advised',
    45: 'reference service',
    47: 'reference date',
    50: 'reference number',
    55: 'date created',
    60: 'time created',
    62: 'digital creation date',
    63: 'digital creation time',
    65: 'originating program',
    70: 'program version',
    75: 'object cycle',
    80: 'by-line',
    85: 'by-line title',
    90: 'city',
    92: 'sub-location',
    95: 'province/state',
    100: 'country/primary location code',
    101: 'country/primary location name',
    103: 'original transmission reference',
    105: 'headline',
    110: 'credit',
    115: 'source',
    116: 'copyright notice',
    118: 'contact',
    120: 'caption/abstract',
    121: 'local caption',
    122: 'writer/editor',
	//#  125: 'rasterized caption', # unsupported (binary data)
    130: 'image type',
    131: 'image orientation',
    135: 'language identifier',
    200: 'custom1', //# These are NOT STANDARD, but are used by
    201: 'custom2', //# Fotostation. Use at your own risk. They're
    202: 'custom3', //# here in case you need to store some special
    203: 'custom4', //# stuff, but note that other programs won't
    204: 'custom5', //# recognize them and may blow them away if
    205: 'custom6', //# you open and re-save the file. (Except with
    206: 'custom7', //# Fotostation, of course.)
    207: 'custom8',
    208: 'custom9',
    209: 'custom10',
    210: 'custom11',
    211: 'custom12',
    212: 'custom13',
    213: 'custom14',
    214: 'custom15',
    215: 'custom16',
    216: 'custom17',
    217: 'custom18',
    218: 'custom19',
    219: 'custom20'
}

function iptc_log(message){
	//air.trace(message);
}
						
function ord(read_byte){
	var convtonum = read_byte + 0;
	if(convtonum >= 0){
		return convtonum;
	}
	else if(convtonum < 0){
		return (convtonum + 256)
	}
}
function ord2(string) {
    var str = string + '';    
    var code = str.charCodeAt(0);
    if (0xD800 <= code && code <= 0xDBFF) { // High surrogate (could change last hex to 0xDB7F to treat high private surrogates as single characters)
        var hi = code;
        if (str.length === 1) {
            return code; // This is just a high surrogate with no following low surrogate, so we return its value;
                                    // we could also throw an error as it is not a complete character, but someone may want to know
        }
        var low = str.charCodeAt(1);
        if (!low) {
            
        }
        return ((hi - 0xD800) * 0x400) + (low - 0xDC00) + 0x10000;
    }
    if (0xDC00 <= code && code <= 0xDFFF) { // Low surrogate
        return code; // This is just a low surrogate with no preceding high surrogate, so we return its value;
        // we could also throw an error as it is not a complete character, but someone may want to know
    }
    return code;
}

function IPTCData(dict){
	//Blank
}
function unpack(var1, var2){
	//Prototype Defined here : http://docs.python.org/library/struct.html
	//Need to figure out what this does. At the moment returning 2 for valid
	return 2;
}
/*
 * Reads exactly length bytes and throws an exception if EOF is hitten before.
 * For convinience Sake we need some form of an iterable
 */
function readExactly(fh, length){
	var buf = fh.read(length);
	//if buf is None or buf.len < length raise EOFException
	return buf;
}
/*
 * Seeks length bytes from the current position and checks the result
 */
function seekExactly(fh, length){
	var pos = fh.tell();
	fh.seek(length, 1);
	if(fh.tell() - pos != length){
		//EOFException()
	}
}
/*
 * Gets length of current variable-length section. File position
 * at start must be on the marker itself, e.g. immediately after call
 * to JPEGNextMarker. File position is updated to just past the
 * length field.
 */
function jpegGetVariableLength(){
	iptc_log("VLENGHT");
	iptc_log(stream.position);
	var bytes = new air.ByteArray();
	stream.readBytes(bytes, 0, 2);
	iptc_log('Vlen'+bytes[0]);
	iptc_log('Vlen'+bytes[1]);
	var vlength = bytes[0] * 256 + bytes[1];
	
	iptc_log("Length Computed " + vlength);
	
	if(vlength < 1){
		iptc_log("JPEGGetVariableLength: erroneous JPEG marker length");
		return 0;
	}
	return (vlength - 2);
}
function collectIMMInfo(){
	var bytes = new air.ByteArray();
	var imm_dictionary = {};
	iptc_log("collectIIMInfo Start " + stream.position);
	while(true){
		stream.readBytes(bytes, 0, 5);
		
		var tag = bytes[0];
		var record = bytes[1];
		var dataset = bytes[2];
		var length = bytes[3] * 256 + bytes[4];
		
		iptc_log("Header data" + tag + ' ' + record + ' ' + dataset + ' ' + length);
		
		if(!(tag == 28 && record == 2)){
			return imm_dictionary;
		}
		
		alist = {'tag': tag,'record': record, 'dataset': dataset,
                              'length': length};
	    var value = stream.readUTFBytes(length);
		//iptc_log("Extract Round ", length, " ", value);
		
		if(dataset in imm_dictionary){
			imm_dictionary[dataset] += ',' + value;
		}
		else{
			imm_dictionary[dataset] = value;
		}
		//iptc_log(dataset + " --- " + imm_dictionary[dataset]);
	}
}
var blindScanFail = 0;
var blindScanTotal = 0;

function blindScan(MAX){
	iptc_log("blindScan: starting scan, max length " + MAX);
	blindScanTotal += 1;
	var offset = 0;
	var record;
	var dataset;
	var bytes = new air.ByteArray();
	var temp;
	var inp_charset;
	var cs;
	var jpvarlen;
	var initposition = stream.position;
	iptc_log("Initial Position" + initposition);
	var position = 0;
	stream.readBytes(bytes, 0, MAX);
	while (offset <= MAX) {
		temp = bytes[position];
		position++;
		iptc_log("Temp " + temp);
		if (temp == 28) { //0x1c
			record = bytes[position]
			position++;
			dataset = bytes[position]
			position++;
			//iptc_log("PreCond");
			if (record == 1 && dataset == 90) {
				jpvarlen = bytes[position] * 256 + bytes[position + 1] - 2;
				position += 2;
				cs = bytes[position] * 256 + bytes[position + 1];
				position += jpvarlen;
				if (cs in c_charset) {
					inp_charset = c_charset[cs];
				}
				//iptc_log("BlindScan: found character set " + inp_charset + " at offset " + offset);
			}
			else 
				if (record == 2) {
					iptc_log("BlindScan: found IIM start at offset " + offset);
					position = position - 3;
					air.trace("Offset" + offset);
					//Maybe need more advanced Logic here
					stream.position = initposition + position;//Update stream.position
					return offset;
				}
				else {
					position = position - 2;
				}
		}
		offset += 1;
	}
	stream.postion += position;
	return false;
}
function jpegScan(){
	stream.position = 0;
	var bytes = new air.ByteArray();
	stream.readBytes(bytes, 0, 2);	
	//iptc_log(stream.position);
	
	var ff = bytes.readByte();
	var soi = bytes.readByte();
	
	if (ff == -1 && soi == -40){
	}
	else{
		return null;
	}
	
	var count = 1;
	while (true) {
		var err = null;
		iptc_log("SP " + stream.position)
		var marker = jpegNextMarker();
		//iptc_log(marker);
		if (ord(marker) == 237) { //0xed
			break;
		}
		if(ord(marker) in c_marker_err){
			err = c_marker_err[ord(marker)];
		}
		if(err === null && jpegSkipVariable() == 0){
			err = "JpegSkipVariable failed";
		}
		if(err !== null){
			//iptc_log(err);
			errors = err;
			return null;
		}
		/*
		if(count >=100){
			//Warning Test Block Remove entire condition from production
			return;
		}
		*/
		//iptc_log("End " + stream.position + "\n");
		count = count + 1;
	}
	////iptc_log(jpegGetVariableLength());
	return blindScan(jpegGetVariableLength())
}
function jpegSkipVariable(){
	var length = jpegGetVariableLength();
	if(length == 0){
		return null;
	}
	//Seek Exactly to Length
	//iptc_log("Skipping " + length + " from " + stream.position);
	if(length < efile.size){
		stream.position = stream.position + length;
		//iptc_log("Now " + stream.position);
		return true;
	}
	else{
		return null;
	}
}

function jpegNextMarker(){
	var bytes = new air.ByteArray();
	var b = 0;
	
	//iptc_log("Next Marker " + stream.position)
	
	stream.readBytes(bytes, 0, 1);
	b = bytes[0];
	//b = bytes.readByte();
	//iptc_log("Almost");
	//iptc_log(stream.position)
	//iptc_log(b);
	//iptc_log(ord(b))
	
	while(ord(b) != 255){
		//iptc_log("JpegNextMarker: warning: bogus stuff in Jpeg file");
		stream.readBytes(bytes, 0, 1);
		b = bytes[0];
		//b = bytes.readByte();
	}
	//iptc_log('L' + stream.position);
	////iptc_log("L--"+stream.position());

	while(true){
		//iptc_log("Hallo");
		//Skip Valid -1's which are valid padding
		stream.readBytes(bytes, 0, 1);
		//iptc_log("What the faraz");
		//iptc_log(bytes.length)
		//iptc_log(bytes[0])
		b = bytes[0]
		//iptc_log("Yaay");
		//iptc_log(b);
		//alert("a");
		//break;
		if(b != -1){
			break;
		}
	}
	//iptc_log("Location "+stream.position);
	return b;
}
function fileIsJpegExternal(file_path){
	try {
		//Defined at the top
		efile = new air.File(file_path);
		stream = new air.FileStream();
		stream.open(efile, air.FileMode.READ);
		return fileIsJpeg();
	} catch(e){
	}
	return false;
}
function fileIsJpeg(){
	//Insert Stricter Checking here.
	var bytes = new air.ByteArray();
	stream.readBytes(bytes,0,2);
	var ff = bytes[0];
	var soi = bytes[1];
	var app0;
	var ered = false;
	if (!((ff == 255) && (soi == 216))) {
		ered = false;
	}
	else{
		stream.readBytes(bytes,0,2);
		ff = bytes[0];
		app0 = bytes[1];
		if(ff != 255){
			ered = false;
		}
		else{
			ered = true;
		}
	}
	stream.position = 0;
	return ered;
}
function tiffinfo(){
	var header = new air.ByteArray();
	var bytes = new air.ByteArray();
	
	stream.readBytes(header, 0, 8);
	
	var iptc_present = null;
	var mime = 'image/tiff';
	var intel = 0;
	var valid = 0;
	var iptc = {};
	
	//iptc_log(header[0] + '-' + header[1] + '-' + header[2] + '-' + header[3]);
	
	var extracting_im = false;
	if( header[0] == 77
		&& header[1] == 77
		&& header[2] == 0
		&& header[3] == 42){
		//	MOTOROLASIGNATURE = 'MM\x00\x2a';
		//iptc_log("Motorolla Signature");
		//Use Big Endian
		valid = 1;
		intel = 0;
		
		extracting_im = true;
		
		}
	else if( header[0] == 73
		&& header[1] == 73
		&& header[2] == 42
		&& header[3] == 0){
		
		valid = 1;
		intel = 0;	
		extracting_im = true;
		//iptc_log("Intel Signature");

		}
	else{
		//iptc_log("Signature non Intel & Non motorolla");
	}
	
	if(extracting_im == true){
		//iptc_log("Begin Process");
		valid = 1;
		intel = 1;
		header.position = 4;
		var offset = header.readInt();
		//iptc_log("Offset" + offset);
		stream.position = stream.position + offset;
		var length = stream.readShort();
		//iptc_log("Length" + length);
		var app = new air.ByteArray();
		stream.readBytes(app, 0, length * 12);
		var app_start = 0;
		
		//iptc_log("Hello");
		for(var tagCount=0; tagCount < length; tagCount++){
			//iptc_log("Testing");
			app_start = tagCount * 12;
			app.position = app_start;
			
			var tag = app.readShort();		//2
			var type = app.readShort();		//2
			var length = app.readInt();		//4
			var offset = app.readShort();	//2
			var value = app.readShort();	//2
			
			//iptc_log("Testing");

			var debug_str = "[["+tagCount+"/"+length+"] tag: "+tag+", type "+type+", len "+length+", value "+offset+", offset "+value+")";
			//iptc_log(debug_str);
			
			//iptc_log("Why man");

			
			if(tag == 34377){	// IPTC TIFF TAG
				//iptc_log("IPTC Exists");
				return blindScan(jpegGetVariableLength());
			}
		}
	}

}
function scanToFirstIMMTag(){
	//iptc_log("FIJ " + fileIsJpeg());
	if(fileIsJpeg()){
		return jpegScan();	//Jpeg Scan
	}
	else{
		var tmime = mt_guess_mime_from_path(efilepath);
		//iptc_log(tmime);
		if(tmime == "image/tiff"){
			//Disable this for support removal
			return tiffinfo();	//Tiff Scan
		}
		else{
			//iptc_log("Only works for JFIF/JPEG && TIFF, others dont support raw IPTC through IIM");
		}
		////iptc_log("Trying Blindscan");
		//return blindScan(8192);
	}
	return null;
}
function iptc_extracter(file_path){
	//iptc_log(file_path);
	efilepath = file_path;
	//var file_path = efilepath;
	var inp_charset = sys_enc;
	var out_charset = 'utf_8';
	var data = {};	//Empty Data Specifying IPTC Stuff
	/*
	var data = IPTCData({'supplemental category': [],
							'keywords': [],
                            'contact': []});
    */
	var result = null;
	var fh = ''; //Load File Name into handler here
	var bytes = new air.ByteArray();
	
	try {
		//Defined at the top
		//iptc_log(efilepath);
		efile = new air.File(file_path);
		stream = new air.FileStream();
		stream.open(efile, air.FileMode.READ);
		
		//iptc_log(efile.size);
		//iptc_log(stream.position);
		
			/*
		 while(stream.position < (efile.size - 30) ){
		 stream.readBytes(bytes, 0, 30);
		 ////iptc_log(stream);
		 }
		 */
		datafound = scanToFirstIMMTag();
		iptc_log("DataFound " + datafound);
		
		if (datafound !== null && datafound !== false) {
			result = collectIMMInfo(fh);
			for (key in result) {
				//iptc_log(key);
			}
			//iptc_log("Result Dict")
		}
	
	} catch(e){
		//There could be anything possibly wrong with the data/file, hence cry like a baby
		result = null;
		air.trace("Exception Encountered")
	}
	
	var reformatted_result = null
	
	if(result !== null){
		reformatted_result = {}
		
		var iptc_field_name;
		var iptc_field_key;
		var iptc_field_value;
		
		for(key in result){
			if (result[key]) {	//Should exclude nulls & undefined's
				//iptc_log("K-->" + key);
				//iptc_log("V-->" + result[key]);
				if(key in c_datasets){
					iptc_field_key = key;
					iptc_field_name = c_datasets[key];
					iptc_field_value = result[key];

					//iptc_log(iptc_field_key + "\t" + iptc_field_name + "\t\t\t\t" + iptc_field_value);

					if (iptc_field_key) {
						if (iptc_field_name) {
							if (iptc_field_value) {
								//iptc_log(iptc_field_key + "\t" + iptc_field_name + "\t\t\t\t" + iptc_field_value);
								reformatted_result["IPTCRAW:" + iptc_field_name] = iptc_field_value;
							}
						}
					}
				}
			}
			/*
			iptc_field_key = key;
			iptc_field_name = c_datasets[key];
			iptc_field_value = result[key];
			//iptc_log(iptc_field_key + "\t" + iptc_field_name + "\t\t\t\t" + iptc_field_value);
			reformatted_result["IPTCRAW:" + iptc_field_key] = iptc_field_value;
			*/
			//reformatted_result["IPTCRAW:" + iptc_field_name] = iptc_field_value;
		}
	}
	
	return reformatted_result;
}


function iptc_test(){
	var iptc_result;
	
	//iptc_log("Starting");
	
	iptc_result = iptc_extracter("/Users/afrobeard/Desktop/Hotstuff/BAB212.jpg");
	//iptc_log("\n\n"+iptc_result+"\n\n");
	/*
	iptc_result = iptc_extracter("/Users/afrobeard/test2.jpg");
	//iptc_log("\n\n"+iptc_result+"\n\n");
	
	iptc_result = iptc_extracter("/Users/afrobeard/test3.jpg");
	//iptc_log("\n\n"+iptc_result+"\n\n");
	
	iptc_result = iptc_extracter("/Users/afrobeard/test4.jpg");
	//iptc_log("\n\n"+iptc_result+"\n\n");
	
	iptc_result = iptc_extracter("/Users/afrobeard/test5.tiff");
	//iptc_log("\n\n"+iptc_result+"\n\n");
	*/
}
