/**
 * @author afrobeard
 */

var stream;
var efile;
var efilepath;

function jpeg_read_short(bytes){
	var hi = bytes[0];
	var lo = bytes[1];
	return hi*256 + lo;
}
function jpeg_read_short_bopp(bytes){
	var hi = bytes[0];
	var lo = bytes[1];
	return lo*256 + hi;
}
function jpeg_read_long(bytes){
	iptc_log(bytes[0] + '-' + bytes[1] + '-' + bytes[2] + '-' + bytes[3]);
	var res = 16777216 * bytes[0]
			+65536 * bytes[1]
			+256 * bytes[2]
			+bytes[3];
	return res;
}
function jpeg_read_long_bopp(bytes){
	iptc_log(bytes[0] + '-' + bytes[1] + '-' + bytes[2] + '-' + bytes[3]);
	var res = 16777216 * bytes[3]
			+65536 * bytes[2]
			+256 * bytes[1]
			+bytes[0];
	return res;
}
var StartOfScanSegment = {
	type:'sos',
	loadme : function (marker, data, stream_position, size) {
		this.marker = marker;
		this.data = data;
	},
	parse_data: function(value_map){
		return value_map;
	}
}

function ExifSegment(marker, data, stream_position, size) {
	this.type = 'exif';
	this.marker = marker;
	this.data = data;
	this.stream_position = stream_position;
	this.size = size;
	this.ifds = [];
	this.e = '<';
	this.tiff_endian = 'II';
	
	this.parse_data = function (value_map) {
		iptc_log("Len" + this.data.length);
		var bytes = new air.ByteArray();
		var tiff_bytes = new air.ByteArray();
		var Nbytes = new air.ByteArray();
		this.data.readBytes(tiff_bytes, 6, this.data.length)
		stream.position = this.stream_position;

		stream.readBytes(bytes,0,6);	// 4 bytes
		if(bytes[0] == 69 && bytes[1] == 120 && bytes[2] == 105 && bytes[3] == 102){ //Exif
			//iptc_log("Exif Segment Detected");
		}
		else{
			//iptc_log("Bad Exif Segment");
			return;
		}
		
		var tiff_endian = new air.ByteArray();
		stream.readBytes(tiff_endian, 0, 2);
		//iptc_log(bytes[0], bytes[1]);
		
		if(tiff_endian[0] == 77 && tiff_endian[1] == 77){	//MM
			this.e = '>';
		}
		else if(tiff_endian[0] == 73 && tiff_endian[1] == 73){	//II
			this.e = '<';			
		}
		else{
			//Raise Exception
			return;
		}
		
		var tiff_tag = stream.readShort();		//2
		if(this.e == '<'){
			tiff_tag = tiff_tag / 256; // Endianness
		}
		iptc_log("E " + this.e);
		iptc_log("T " + tiff_tag);
		if (this.e == '>') {
			var tiff_offset = 65536 * stream.readShort() + stream.readShort(); //4
		}
		else{
			var tiff_offset = 2056 - (stream.readShort() + 65536 * stream.readShort()); //4
		}
		iptc_log("O " + tiff_offset)
		
		stream.readBytes(bytes,0,2);			//2
		
		
		var has_exif_extended = false;
		var exif_extended_offset = 0;
		
		for (var two = 0; two < 2; two++) {
			if (two == 0) {
			//Do Nothing as this is the normal Exif thing
			}
			else if (has_exif_extended) {
				tiff_offset = exif_extended_offset;
			}
			else {
				//No Extended offset Stop Work
				break;
			}

			var offset = tiff_offset;
			var count = 0;
			
			//tiff_data = this.data.splice(6, this.size);
			
			while (offset) {
				iptc_log("OffSet" + offset);
				count += 1;
				stream.position = offset;
				var num_entries = 0;
				if (this.e == '<') {
					num_entries = this.data[6 + offset] + 128 * this.data[6 + offset + 1];
				}
				else 
					if (this.e == '>') {
						num_entries = 128 * this.data[6 + offset] + this.data[6 + offset + 1]
					}
				iptc_log("Entries "+num_entries);
				var outer_start = 2 + offset + (num_entries * 12);
				//iptc_log('\n');
				if(count > 2){
					break;
				}
				
				if (count == 1) {
					var entries = [];
					this.data.position = 6 + offset;
					var next = 0;
					var num_entries = 0;
					if (this.e == ">") {
						num_entries = this.data.readShort();
						iptc_log("Short off " + num_entries); //!!
						this.data.position = 6 + offset + 2 + 12 * num_entries;
						next = this.data.readInt();
					}
					else{
						var tb = new air.ByteArray();
						this.data.readBytes(tb, 0, 2);
						num_entries = jpeg_read_short_bopp(tb);
						this.data.position = 6 + offset + 2 + 12 * num_entries;
						this.data.readBytes(tb, 0, 4);
						next = jpeg_read_long_bopp(tb);
					}
					iptc_log("Nentries", num_entries);
					iptc_log("OFFSET", offset, "-", next);
					
					
					for (var i = 0; i < num_entries; i++) {
						var start = i * 12 + 2 + offset;
						this.data.position = 6 + start;
						var tag_id = this.data.readShort();
						var type_no;
						var components;
						var the_data_int;
						
						if (this.e == ">") {
							tag_id = this.data[6 + start] * 256 + this.data[6 + start + 1];
							type_no = this.data.readShort();
							components = this.data.readInt(); //components of the data for fractions
							the_data_int = this.data.readInt();
						}
						else {
							tag_id = this.data[6 + start] + this.data[6 + start + 1] * 256;
							var tb = new air.ByteArray();
							this.data.readBytes(tb, 0, 2);
							type_no = jpeg_read_short_bopp(tb);
							this.data.readBytes(tb, 0, 4);
							components = jpeg_read_long_bopp(tb);
							this.data.readBytes(tb, 0, 4);
							the_data_int = jpeg_read_long_bopp(tb);
						}
						
						iptc_log("TAGInfo", tag_id, type_no, components, the_data_int);
						
						var exif_type_size = {
							1: 1, //byte
							2: 1, //ascii
							3: 2, //short
							4: 4, //long
							5: 8, //rational
							7: 1, //undef
							9: 4, //slong
							10: 8 //srational
						}
						var byte_size = exif_type_size[type_no] * components;
						var the_data = new air.ByteArray();
						if (byte_size > 4) {
							this.data.position = 6 + the_data_int;
							this.data.readBytes(the_data, 0, byte_size);
						}
						else {
							this.data.position = 6 + start + 8;
							this.data.readBytes(the_data, 0, byte_size);
						}
						//iptc_log("Dlen", the_data.length)
						if (tag_id == 0x8769) { //Extended Exif
							iptc_log('\n\tExtendedExif ' + the_data_int + ' \n')
							//Call this functinality in function
							//Offset : the_data
							has_exif_extended = true;
							exif_extended_offset = the_data_int;
						}
						else 
							if (tag_id in EXIF_TAG_MAP) {
								//iptc_log("ITAG" + tag_id + " - " + EXIF_TAG_MAP[tag_id]);
								tag = EXIF_TAG_MAP[tag_id];
								if (type_no == 1) { //Bytes
								}
								if (type_no == 2) { //ASCII
									var tmpval = the_data.readUTFBytes(the_data.length);
									value_map[tag] = tmpval;
									iptc_log(value_map[tag]);
								}
								if (type_no == 3) {
									if (this.e == ">") {
										var tmpval = the_data.readShort();
										if (tmpval < 1) {
											tmpval = 65535 - tmpval;
										}
										value_map[tag] = tmpval;
									}
									else{
										value_map[tag] = the_data_int;
									}
									iptc_log(value_map[tag]);
								}
								if (type_no == 4) {
									if (this.e == ">") {
										var tmpval = the_data.readInt(); //Check signed & unsigned
										value_map[tag] = tmpval;
									}
									else{
										value_map[tag] = the_data_int;
									}
									iptc_log(value_map[tag]);
								}
								if (type_no == 5) {
									if (this.e == ">") {
										the_data.readBytes(Nbytes, 0, 4);
										var tmp_val1 = jpeg_read_long(Nbytes);
										the_data.readBytes(Nbytes, 0, 4);
										var tmp_val2 = jpeg_read_long(Nbytes);
										var tmpval = tmp_val1 + '/' + tmp_val2;
										value_map[tag] = tmpval;
									}
									else{
										the_data.readBytes(Nbytes, 0, 4);
										var tmp_val1 = jpeg_read_long_bopp(Nbytes);
										the_data.readBytes(Nbytes, 0, 4);
										var tmp_val2 = jpeg_read_long_bopp(Nbytes);
										var tmpval = tmp_val1 + '/' + tmp_val2;
										value_map[tag] = tmpval;
									}
									iptc_log(value_map[tag]);
								}
							}
							else {
							//iptc_log("Tag Skipped" + tag_id);
							}
					}
					
					
				}
				
				this.data.position = 6 + outer_start;
				var MBytes = new air.ByteArray();
				this.data.readBytes(MBytes, 0, 4);
				if (this.e == ">") {
					offset = jpeg_read_long(MBytes);
				} else{
					offset = jpeg_read_long_bopp(MBytes);
				}
				//iptc_log("||\t\t\t" + offset)
			}
		}
		return value_map;
	}
}

var DefaultSegment = {
	type:'default',
	loadme : function (marker, data, stream_position, size) {
		this.marker = marker;
		this.data = data;
	},
	parse_data: function(value_map){
		return value_map;
	}
}
var jpeg_markers = {
    0xc0: ["SOF0", []],
    0xc2: ["SOF2", []],
    0xc4: ["DHT", []],

    0xda: ["SOS", []],	//218	StartOfScanSegment
    0xdb: ["DQT", []],
    0xdd: ["DRI", []],
    
    0xe0: ["APP0", []],				//220
    0xe1: ["APP1", ['ExifSegment']],	//221
    0xe2: ["APP2", []],				//222
    0xe3: ["APP3", []],				//223
    0xe4: ["APP4", []],				//223
    0xe5: ["APP5", []],				//224
    0xe6: ["APP6", ['ExifSegment']],	//225
    0xe7: ["APP7", []],				//226
    0xe8: ["APP8", []],				//227
    0xe9: ["APP9", []],				//228
    0xea: ["APP10", []],			//229
    0xeb: ["APP11", []],			//230
    0xec: ["APP12", []],			//231
    0xed: ["APP13", []],			//232
    0xee: ["APP14", []],			//233
    0xef: ["APP15", []],			//234
    
    0xfe: ["COM", []],
}

function jpeg_process(){
	//iptc_log("IN JPEG Process");
	var value_map = {}
	var bytes = new air.ByteArray();
	stream.readBytes(bytes,0,2);
	var ff = bytes[0];
	var soi = bytes[1];
	if (!((ff == 255) && (soi == 216))) {	//SOI d8
		//iptc_log("Invalid File Error");
		ered = false;
		return;
	}
	var segments = [];
	var possible_segment_classes = [];

	while (true) {
		stream.readBytes(bytes, 0, 2);
		var delim = bytes[0];
		var mark = bytes[1];
		iptc_log("Delim " + delim + " Mark " + mark);
		if (delim != 255) {
			//Error
			iptc_log("Invalid Delim " + delim + " Mark " + mark);
			break;
		}
		if (mark == 217) { //d9 or EOI
			//Error
			iptc_log("Marker Endpoint");
			break;
		}
		var head2 = new air.ByteArray();
		var size = stream.readShort(); //length
		var stream_position = stream.position;
		var data = new air.ByteArray();
		stream.readBytes(data, 0, size - 2);
		
		iptc_log("JPEG MARKER", mark)
		iptc_log("JPEG MARKER Size", size)
		
		possible_segment_classes = jpeg_markers[mark][1].slice();
		//iptc_log(possible_segment_classes);
		//possible_segment_classes.push(DefaultSegment);
		for (var i = 0; i < possible_segment_classes.length; i++) {
			//This needs to be try breaked later
			//var segment_class = possible_segment_classes[i];
			if(possible_segment_classes[i] == "ExifSegment"){
				var segment_class = new ExifSegment(mark, data, stream_position, size);
				iptc_log("SCT", segment_class.type);
				iptc_log("SCM", segment_class.marker);
				segments.push(segment_class);
				iptc_log("Post Push");				
			}

		}
		iptc_log("Booyaa");
	}
	iptc_log("Preprocess");
	for(var i=0; i<segments.length; i++){
		var seg = segments[i];
		iptc_log("Loading Segment", seg.marker);
		seg.parse_data(value_map);
		for(var key in value_map){
		iptc_log(key + ": " + value_map[key]);
		}

	}
	
	//alert("draaaa");
	for(var key in value_map){
		iptc_log(key + ": " + value_map[key]);
	}
	//alert("asdfa");
	return value_map;
	
}

function jpeg_extracter(file_path){
	iptc_log(file_path);
	efilepath = file_path;
	//var file_path = efilepath;
	var inp_charset = sys_enc;
	var out_charset = 'utf_8';
	var data = {};	//Empty Data Specifying IPTC Stuff
	var result = null;
	var fh = ''; //Load File Name into handler here
	var bytes = new air.ByteArray();
	var value_map = {};
	try {
		//Defined at the top
		iptc_log(efilepath);
		efile = new air.File(file_path);
		stream = new air.FileStream();
		stream.open(efile, air.FileMode.READ);
		//iptc_log(efile.size);
		//iptc_log(stream.position);
		value_map = jpeg_process();

	} catch(e){
		//There could be anything possibly wrong with the data/file, hence cry like a baby
		result = null;
	}
	for(var key in value_map){
		iptc_log("Debug", key, value_map[key]);
	}
	return value_map;
}
function jpeg_test(){
	var file_path = "/Users/afrobeard/Desktop/Hotstuff/BAB212.jpg";
	iptc_log("Executing TEST ");
	jpeg_extracter(file_path);
}