/*
 * @author: afrobeard
 * 
 * Example MASTER_MAPPING File
 * {
	'directMapping' : {"photoshop:ColorMode": {'1': 'Gray Scale', '3':'RGB', '4': 'CMYK'}},
	'fractionToDecimal' : ["exif:ApertureValue", 
								"exif:FocalLength", 
								"exif:FNumber", 
								"exif:MaxApertureValue",
								"exif:ShutterSpeedValue",
								"exif:CompressedBitsPerPixel",
								"tiff:XResolution",
								"tiff:YResolution",
								"aux:LenInfo"],
	'exclusionFields' : ["rdf:about"],
}
 * 
 */

//Master Mapping Data Can be loaded from File as well
var MASTER_MAPPING = {
}
/*
 * This updates the MASTER_MAPPINGS Structure to Define Throwaway Data Structures for either speed or ease
 */
function preProcessInternalMappings(){
	if(('directMapping' in MASTER_MAPPING) != true){
		MASTER_MAPPING['directMapping'] = {};
	}
	var listToDictIndex = function (key){
		if((key in MASTER_MAPPING) != true){
			MASTER_MAPPING[key] = [];
			return;
		}
		MASTER_MAPPING['indexed_'+key] = {};
		for(var i=0; i < MASTER_MAPPING[key].length; i++){
			var elem_name = MASTER_MAPPING[key][i];
			MASTER_MAPPING['indexed_'+key][elem_name] = null;
		}
	}
	listToDictIndex('fractionToDecimal');
	listToDictIndex('exclusionFields');
}
/*
 * This Function Populates Master Mapping DataStructure form internal File
 */
function populateMappings(){
	//Open Internal Mappings File
	//Populate Internal Mappings DATA Structure
	var mappingsFile = air.File.applicationDirectory;
	mappingsFile = mappingsFile.resolvePath("mappings.json");
	if (mappingsFile.exists) {
		var mappingsStream = new air.FileStream();
		mappingsStream.open(mappingsFile, air.FileMode.READ);
		mappingsString = mappingsStream.readUTFBytes(mappingsStream.bytesAvailable);
		mappingsStream.close();
		air.trace(mappingsString);
		MASTER_MAPPING = JSON.parse(mappingsString);
	}
	else{
		air.trace("Mappings File does not exist. Assuming Blank Mappings");
	}
	preProcessInternalMappings();
	air.trace("Current Mapping State" + JSON.stringify(MASTER_MAPPING));
}

function apply_transformations(map){
	var directMapping = MASTER_MAPPING['directMapping'];
	var fractionValueMap = MASTER_MAPPING['indexed_' + 'fractionToDecimal'];
	for(var key in map){
		if(key in directMapping){
			var innerMappingStructure = directMapping[key];
			if(map[key] in innerMappingStructure){
				map[key] = innerMappingStructure[map[key]];
			}
		}
		//Removing Decimal to fraction transformations 
		if(key in fractionValueMap){
			var temp_fraction = map[key];
			var temp_type = typeof temp_fraction;
			if(temp_type == "string"){
				air.trace(typeof temp_fraction);
				air.trace(temp_fraction);
				var fractionbits = temp_fraction.split('/');
				if (fractionbits.length == 2) {
					var intNumen = parseInt(fractionbits[0], 10);
					var intDemon = parseInt(fractionbits[1], 10);
					if (intNumen == NaN || intDemon == NaN) {
					//Pass
					}
					else {
						map[key] = intNumen / intDemon;
						//For the purposes of representation & sanitization we're converting to string
						map[key] = map[key].toString();
					}
				}
			}
		}
	}
	return map;
}
