/*
 * Decompiled with CFR 0.152.
 */
package tarlog.encoder.tool.api;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tarlog.encoder.tool.ui.inner.HistoryManager;
import tarlog.ui.swt.ddialog.impl.DynamicInputDialog;
import tarlog.ui.swt.ddialog.utils.AbstractSelectionListener;
import tarlog.ui.swt.ddialog.utils.Utils;

public abstract class AbstractEncoder
extends AbstractSelectionListener {
    private String name;
    private Text targetText;
    private Text sourceText;
    private HistoryManager historyManager;
    private String encodingMethod = null;
    protected Shell shell;

    public AbstractEncoder() {
        try {
            Class<?> realClass = this.getClass();
            if (realClass.getMethod("encode", String.class).getDeclaringClass() == AbstractEncoder.class && realClass.getMethod("encode", byte[].class).getDeclaringClass() == AbstractEncoder.class) {
                throw new RuntimeException(String.format("The encoder class %s must override at least one 'encode' method", realClass.getName()));
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void widgetSelected(SelectionEvent e) {
        try {
            boolean sourceBytes = ((Button)this.sourceText.getData()).getSelection();
            String inText = this.sourceText.getText();
            if (this.beforeEncode() != 0) {
                return;
            }
            Object out = sourceBytes ? this.encode(Utils.bytesFromHex(inText)) : this.encode(inText);
            if (out == null) {
                return;
            }
            if (out instanceof byte[]) {
                String bytes = Utils.bytesToHex((byte[])out);
                ((Button)this.targetText.getData()).setSelection(true);
                this.targetText.setText(bytes);
            } else {
                ((Button)this.targetText.getData()).setSelection(false);
                this.targetText.setText(String.valueOf(out));
            }
            this.historyManager.addStep(this.historyInfo(), this.sourceText, this.targetText);
        }
        catch (Exception e1) {
            Utils.showException(this.shell, e1);
        }
    }

    protected String historyInfo() {
        return this.getName();
    }

    protected int beforeEncode() {
        return this.openInputDialog();
    }

    protected int openInputDialog() {
        List<DynamicInputDialog.FieldWrapper> fields = DynamicInputDialog.getInputFields(this);
        if (!fields.isEmpty()) {
            return new DynamicInputDialog(this.shell, String.format("Input for %s", this.getName()), this, fields).open();
        }
        return 0;
    }

    public Object encode(String source) {
        try {
            return this.encode(source.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Utils.showException(this.shell, e);
            return null;
        }
    }

    public Object encode(byte[] source) {
        try {
            return this.encode(new String(source, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Utils.showException(this.shell, e);
            return null;
        }
    }

    public void setTarget(Text targetText) {
        this.targetText = targetText;
    }

    public void setSource(Text sourceText) {
        this.sourceText = sourceText;
    }

    public final void setShell(Shell shell) {
        this.shell = shell;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    protected void showInformationMessage(String title, String text) {
        Utils.showInformationMessage(this.shell, title, text);
    }

    protected void showException(Throwable t) {
        Utils.showException(this.shell, t);
    }

    protected void showErrorMessage(String title, String text) {
        Utils.showErrorMessage(this.shell, title, text);
    }

    public void setHistoryManager(HistoryManager historyManager) {
        this.historyManager = historyManager;
    }

    public HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public void setEncodingMethod(String encodingMethod) {
        this.encodingMethod = encodingMethod;
    }

    public String getEncodingMethod() {
        return this.encodingMethod;
    }
}

