/*
 * Decompiled with CFR 0.152.
 */
package tarlog.encoder.tool.api;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import tarlog.encoder.tool.api.AbstractEncoder;
import tarlog.ui.swt.ddialog.api.fields.InputField;
import tarlog.ui.swt.ddialog.api.fields.InputTextField;
import tarlog.ui.swt.ddialog.api.fields.Validator;

public abstract class KeyStoreAwareEncoder
extends AbstractEncoder
implements Validator {
    protected KeyStore keystore;
    @InputField(name="Key Store File", required=true, order=-300)
    private File file;
    @InputField(name="Key Store Type", order=-200)
    @InputTextField(values={"JKS", "PKCS12"}, validateNotEmpty=true)
    private String type = "JKS";
    @InputField(name="Key Store Password", order=-100)
    @InputTextField(password=true)
    private String password;

    @Override
    public String isValid() {
        try {
            this.keystore = KeyStore.getInstance(this.type);
        }
        catch (KeyStoreException e) {
            return e.getMessage();
        }
        try {
            this.keystore.load(new FileInputStream(this.file), this.password.toCharArray());
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    @Override
    protected int beforeEncode() {
        int inputStatus = super.beforeEncode();
        if (inputStatus != 0) {
            return inputStatus;
        }
        try {
            this.keystore = KeyStore.getInstance(this.type);
        }
        catch (KeyStoreException e) {
            this.showException(e);
            return 1;
        }
        try {
            this.keystore.load(new FileInputStream(this.file), this.password.toCharArray());
        }
        catch (Exception e) {
            this.showException(e);
            return 1;
        }
        return inputStatus;
    }
}

