/*
 * Decompiled with CFR 0.152.
 */
package tarlog.encoder.tool.eclipse.preferences;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import tarlog.encoder.tool.eclipse.preferences.EncoderClasspathWrapper;
import tarlog.encoder.tool.eclipse.preferences.PropertiesStore;
import tarlog.encoder.tool.eclipse.preferences.StringWrapper;

class ContentProvider
implements ITreeContentProvider {
    ContentProvider() {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof PropertiesStore.EncodersGroup) {
            PropertiesStore.EncodersGroup encodersGroup = (PropertiesStore.EncodersGroup)parentElement;
            return encodersGroup.getList().toArray();
        }
        if (parentElement instanceof PropertiesStore.EncoderDef) {
            PropertiesStore.EncoderDef encoderDef = (PropertiesStore.EncoderDef)parentElement;
            ArrayList<Object> list = new ArrayList<Object>(3);
            list.add(new StringWrapper("Class", encoderDef.className));
            if (encoderDef.encodingMethod != null) {
                list.add(new StringWrapper("Encoding Method", encoderDef.encodingMethod));
            }
            if (encoderDef.classPath != null && encoderDef.classPath.length > 0) {
                list.add(new EncoderClasspathWrapper(encoderDef.classPath));
            }
            return list.toArray();
        }
        if (parentElement instanceof EncoderClasspathWrapper) {
            EncoderClasspathWrapper classpathWrapper = (EncoderClasspathWrapper)parentElement;
            return classpathWrapper.classpath;
        }
        System.out.println("ContentProvider.getChildren() " + parentElement.getClass().getName());
        return null;
    }

    public Object getParent(Object element) {
        System.out.println("ContentProvider.getParent() ");
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof PropertiesStore.EncodersGroup) {
            PropertiesStore.EncodersGroup encodersGroup = (PropertiesStore.EncodersGroup)element;
            return encodersGroup.getList().size() > 0;
        }
        if (element instanceof PropertiesStore.EncoderDef) {
            return true;
        }
        if (element instanceof StringWrapper) {
            return false;
        }
        if (element instanceof String) {
            return false;
        }
        if (element instanceof EncoderClasspathWrapper) {
            EncoderClasspathWrapper classpathWrapper = (EncoderClasspathWrapper)element;
            return classpathWrapper.classpath != null && classpathWrapper.classpath.length > 0;
        }
        System.out.println("ContentProvider.hasChildren() " + element.getClass().getName());
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == null) {
            return new Object[0];
        }
        if (inputElement instanceof PropertiesStore) {
            PropertiesStore encodersStore = (PropertiesStore)inputElement;
            return encodersStore.getStore();
        }
        System.out.println("ContentProvider.getElements() " + inputElement.getClass().getName());
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

