/*
 * Decompiled with CFR 0.152.
 */
package tarlog.encoder.tool.eclipse.preferences;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import tarlog.encoder.tool.eclipse.Activator;
import tarlog.encoder.tool.eclipse.preferences.ContentProvider;
import tarlog.encoder.tool.eclipse.preferences.LabelProvider;
import tarlog.encoder.tool.eclipse.preferences.PreferenceInitializer;
import tarlog.encoder.tool.eclipse.preferences.PropertiesStore;
import tarlog.ui.swt.ddialog.impl.DynamicInputDialog;
import tarlog.ui.swt.ddialog.utils.AbstractSelectionListener;
import tarlog.ui.swt.ddialog.utils.Utils;

public class EncoderToolPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final Pattern WORD_PATTERN = Pattern.compile("\\w.*\\w");
    private PropertiesStore store;
    private TreeViewer treeViewer;
    private Button addEncoderButton;
    private Button editButton;
    private Button upButton;
    private Button downButton;
    private Button removeButton;
    private Button addGroupButton;
    private Composite contentsComposite;

    public EncoderToolPreferencePage() {
        this(Activator.getDefault().getPreferenceStore());
    }

    public EncoderToolPreferencePage(String string) throws IOException {
        this((IPreferenceStore)new PreferenceStore(string));
    }

    private EncoderToolPreferencePage(IPreferenceStore preferencePage) {
        this.setPreferenceStore(preferencePage);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        this.store.store(preferenceStore);
        if (preferenceStore instanceof PreferenceStore) {
            try {
                ((PreferenceStore)preferenceStore).save();
            }
            catch (IOException e) {
                Utils.showException(this.getShell(), e);
                return false;
            }
        }
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        this.initialize();
        this.contentsComposite = new Composite(parent, 0);
        this.contentsComposite.setLayout((Layout)new GridLayout(2, false));
        this.contentsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fillContents();
        return this.contentsComposite;
    }

    private void fillContents() {
        this.createTree(this.contentsComposite);
        this.createButtons(this.contentsComposite);
    }

    private void reloadContents() {
        for (Control control : this.contentsComposite.getChildren()) {
            if (control.isDisposed()) continue;
            control.dispose();
        }
        this.fillContents();
        this.contentsComposite.layout();
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
        this.addGroupButton = this.createAddGroupButton(composite);
        this.addEncoderButton = this.createAddEncoderButton(composite);
        this.editButton = this.createEditButton(composite);
        this.removeButton = this.createRemoveButton(composite);
        this.upButton = this.createUpButton(composite);
        this.downButton = this.createDownButton(composite);
    }

    private Button createAddGroupButton(Composite composite) {
        Button addGroupButton = new Button(composite, 8);
        addGroupButton.setLayoutData((Object)new GridData(4, 128, true, false));
        addGroupButton.setText("Add Group");
        addGroupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EncoderToolPreferencePage.this.editGroupName("");
            }
        });
        return addGroupButton;
    }

    private Button createEditButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        button.setText("Edit");
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EncoderToolPreferencePage.this.edit();
            }
        });
        return button;
    }

    private void edit() {
        DynamicInputDialog dynamicInputDialog;
        int rc;
        TreeSelection selection = (TreeSelection)this.treeViewer.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof PropertiesStore.EncodersGroup) {
            PropertiesStore.EncodersGroup group = (PropertiesStore.EncodersGroup)firstElement;
            String name = this.editGroupName(group.getGroupName());
            if (name != null) {
                group.setGroupName(name);
                this.treeViewer.refresh();
            }
        } else if (firstElement instanceof PropertiesStore.EncoderDef && (rc = (dynamicInputDialog = new DynamicInputDialog(this.getShell(), "Edit Encoder", firstElement)).open()) == 0) {
            this.treeViewer.refresh();
        }
    }

    private Button createAddEncoderButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        button.setText("Add Encoder");
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object firstElement = ((TreeSelection)EncoderToolPreferencePage.this.treeViewer.getSelection()).getFirstElement();
                PropertiesStore.EncodersGroup encodersGroup = (PropertiesStore.EncodersGroup)firstElement;
                PropertiesStore.EncoderDef encoderDef = new PropertiesStore.EncoderDef();
                DynamicInputDialog dynamicInputDialog = new DynamicInputDialog(EncoderToolPreferencePage.this.getShell(), "Add Encoder", encoderDef);
                int rc = dynamicInputDialog.open();
                if (rc == 0) {
                    encodersGroup.getList().add(encoderDef);
                    EncoderToolPreferencePage.this.treeViewer.refresh();
                }
            }
        });
        return button;
    }

    private Button createUpButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        button.setText("Up");
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeSelection selection = (TreeSelection)EncoderToolPreferencePage.this.treeViewer.getSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof PropertiesStore.EncodersGroup) {
                    PropertiesStore.EncodersGroup group = (PropertiesStore.EncodersGroup)firstElement;
                    EncoderToolPreferencePage.this.store.moveUp(group);
                } else if (firstElement instanceof PropertiesStore.EncoderDef) {
                    PropertiesStore.EncodersGroup group = (PropertiesStore.EncodersGroup)selection.getPaths()[0].getFirstSegment();
                    PropertiesStore.EncoderDef encoderDef = (PropertiesStore.EncoderDef)firstElement;
                    group.moveUp(encoderDef);
                }
                EncoderToolPreferencePage.this.treeViewer.refresh();
                EncoderToolPreferencePage.this.treeViewer.setSelection(EncoderToolPreferencePage.this.treeViewer.getSelection());
            }
        });
        return button;
    }

    private Button createDownButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        button.setText("Down");
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeSelection selection = (TreeSelection)EncoderToolPreferencePage.this.treeViewer.getSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof PropertiesStore.EncodersGroup) {
                    PropertiesStore.EncodersGroup group = (PropertiesStore.EncodersGroup)firstElement;
                    EncoderToolPreferencePage.this.store.moveDown(group);
                } else if (firstElement instanceof PropertiesStore.EncoderDef) {
                    PropertiesStore.EncodersGroup group = (PropertiesStore.EncodersGroup)selection.getPaths()[0].getFirstSegment();
                    PropertiesStore.EncoderDef encoderDef = (PropertiesStore.EncoderDef)firstElement;
                    group.moveDown(encoderDef);
                }
                EncoderToolPreferencePage.this.treeViewer.refresh();
                EncoderToolPreferencePage.this.treeViewer.setSelection(EncoderToolPreferencePage.this.treeViewer.getSelection());
            }
        });
        return button;
    }

    private Button createRemoveButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        button.setText("Remove");
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeSelection selection = (TreeSelection)EncoderToolPreferencePage.this.treeViewer.getSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof PropertiesStore.EncodersGroup) {
                    PropertiesStore.EncodersGroup group = (PropertiesStore.EncodersGroup)firstElement;
                    EncoderToolPreferencePage.this.store.remove(group);
                } else if (firstElement instanceof PropertiesStore.EncoderDef) {
                    PropertiesStore.EncodersGroup group = (PropertiesStore.EncodersGroup)selection.getPaths()[0].getFirstSegment();
                    PropertiesStore.EncoderDef encoderDef = (PropertiesStore.EncoderDef)firstElement;
                    group.remove(encoderDef);
                }
                EncoderToolPreferencePage.this.treeViewer.refresh();
                EncoderToolPreferencePage.this.treeViewer.setSelection(EncoderToolPreferencePage.this.treeViewer.getSelection());
            }
        });
        return button;
    }

    private void createTree(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 68356);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        TreeColumn mainColumn = new TreeColumn(tree, 0);
        mainColumn.setWidth(200);
        mainColumn.setText("Name");
        TreeColumn enabledColumn = new TreeColumn(tree, 0);
        enabledColumn.setWidth(200);
        enabledColumn.setText("Enabled");
        tree.setMenu(this.createTreeMenu(tree));
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        tree.setLayout((Layout)new FillLayout());
        tree.setVisible(true);
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                EncoderToolPreferencePage.this.edit();
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.treeViewer.setInput((Object)this.store);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof PropertiesStore.EncodersGroup) {
                    PropertiesStore.EncodersGroup group = (PropertiesStore.EncodersGroup)firstElement;
                    EncoderToolPreferencePage.this.addGroupButton.setEnabled(true);
                    EncoderToolPreferencePage.this.addEncoderButton.setEnabled(true);
                    EncoderToolPreferencePage.this.editButton.setEnabled(true);
                    EncoderToolPreferencePage.this.removeButton.setEnabled(true);
                    EncoderToolPreferencePage.this.downButton.setEnabled(EncoderToolPreferencePage.this.store.canMoveDown(group));
                    EncoderToolPreferencePage.this.upButton.setEnabled(EncoderToolPreferencePage.this.store.canMoveUp(group));
                } else if (firstElement instanceof PropertiesStore.EncoderDef) {
                    PropertiesStore.EncodersGroup group = (PropertiesStore.EncodersGroup)selection.getPaths()[0].getFirstSegment();
                    PropertiesStore.EncoderDef encoderDef = (PropertiesStore.EncoderDef)firstElement;
                    EncoderToolPreferencePage.this.addGroupButton.setEnabled(false);
                    EncoderToolPreferencePage.this.addEncoderButton.setEnabled(false);
                    EncoderToolPreferencePage.this.removeButton.setEnabled(true);
                    EncoderToolPreferencePage.this.editButton.setEnabled(true);
                    EncoderToolPreferencePage.this.downButton.setEnabled(group.canMoveDown(encoderDef));
                    EncoderToolPreferencePage.this.upButton.setEnabled(group.canMoveUp(encoderDef));
                } else {
                    EncoderToolPreferencePage.this.addGroupButton.setEnabled(false);
                    EncoderToolPreferencePage.this.removeButton.setEnabled(false);
                    EncoderToolPreferencePage.this.addEncoderButton.setEnabled(false);
                    EncoderToolPreferencePage.this.editButton.setEnabled(false);
                    EncoderToolPreferencePage.this.downButton.setEnabled(false);
                    EncoderToolPreferencePage.this.upButton.setEnabled(false);
                }
            }
        });
    }

    private Menu createTreeMenu(Tree tree) {
        Menu menu = new Menu((Control)tree);
        final MenuItem enabledMenuItem = new MenuItem(menu, 32);
        enabledMenuItem.setText("Enabled");
        enabledMenuItem.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                boolean enabledMenuSelection = ((MenuItem)e.widget).getSelection();
                TreeSelection selection = (TreeSelection)EncoderToolPreferencePage.this.treeViewer.getSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof PropertiesStore.EncodersGroup) {
                    PropertiesStore.EncodersGroup group = (PropertiesStore.EncodersGroup)firstElement;
                    group.setEnabled(enabledMenuSelection);
                } else if (firstElement instanceof PropertiesStore.EncoderDef) {
                    PropertiesStore.EncoderDef def = (PropertiesStore.EncoderDef)firstElement;
                    def.setEnabled(enabledMenuSelection);
                }
                EncoderToolPreferencePage.this.treeViewer.refresh();
            }
        });
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                TreeSelection selection = (TreeSelection)EncoderToolPreferencePage.this.treeViewer.getSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof PropertiesStore.EncodersGroup) {
                    PropertiesStore.EncodersGroup group = (PropertiesStore.EncodersGroup)firstElement;
                    enabledMenuItem.setEnabled(true);
                    enabledMenuItem.setSelection(group.isEnabled());
                } else if (firstElement instanceof PropertiesStore.EncoderDef) {
                    PropertiesStore.EncoderDef def = (PropertiesStore.EncoderDef)firstElement;
                    enabledMenuItem.setEnabled(true);
                    enabledMenuItem.setSelection(def.isEnabled());
                } else {
                    enabledMenuItem.setEnabled(false);
                }
                EncoderToolPreferencePage.this.treeViewer.refresh();
                EncoderToolPreferencePage.this.treeViewer.setSelection(EncoderToolPreferencePage.this.treeViewer.getSelection());
            }
        });
        return menu;
    }

    private void initialize() {
        try {
            IPreferenceStore preferenceStore = this.getPreferenceStore();
            if (preferenceStore instanceof PreferenceStore) {
                ((PreferenceStore)preferenceStore).load();
                PreferenceInitializer.loadDefault(preferenceStore);
            }
            this.store = new PropertiesStore(preferenceStore, false);
        }
        catch (IOException e) {
            Utils.showException(this.getShell(), e);
        }
    }

    private String editGroupName(String string) {
        InputDialog inputDialog = new InputDialog(this.getShell(), "Enter group name", "Enter group name", string, new IInputValidator(){

            public String isValid(String newText) {
                if (newText.trim().equals("")) {
                    return "Group name cannot be empty";
                }
                Matcher matcher = WORD_PATTERN.matcher(newText);
                if (!matcher.matches()) {
                    return "Group name must be a word";
                }
                if (EncoderToolPreferencePage.this.store.getGroup(newText) != null) {
                    return "Group name must be unique";
                }
                return null;
            }
        });
        int rc = inputDialog.open();
        if (rc == 0) {
            if ("".equals(string)) {
                this.store.newGroup(inputDialog.getValue());
                this.treeViewer.refresh();
                return inputDialog.getValue();
            }
            return inputDialog.getValue();
        }
        return null;
    }

    protected void performDefaults() {
        try {
            this.store = new PropertiesStore(this.getPreferenceStore(), true);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        super.performDefaults();
        this.reloadContents();
    }
}

