/*
 * Decompiled with CFR 0.152.
 */
package tarlog.encoder.tool.eclipse.preferences;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import tarlog.encoder.tool.api.AbstractEncoder;
import tarlog.ui.swt.ddialog.api.fields.InputDirectoryField;
import tarlog.ui.swt.ddialog.api.fields.InputField;
import tarlog.ui.swt.ddialog.api.fields.InputFileField;
import tarlog.ui.swt.ddialog.api.fields.InputListField;
import tarlog.ui.swt.ddialog.api.fields.InputTextField;
import tarlog.ui.swt.ddialog.api.fields.Validator;

public class PropertiesStore {
    private List<EncodersGroup> store = new ArrayList<EncodersGroup>();

    public PropertiesStore(IPreferenceStore preferenceStore, boolean isDefault) throws MalformedURLException {
        int groupsAmount = isDefault ? preferenceStore.getDefaultInt(PropertiesStore.class.getName()) : preferenceStore.getInt(PropertiesStore.class.getName());
        for (int i = 0; i < groupsAmount; ++i) {
            this.store.add(new EncodersGroup(i, preferenceStore, isDefault));
        }
    }

    void moveUp(EncodersGroup group) {
        int indexOf = this.store.indexOf(group);
        if (indexOf > 0) {
            Collections.swap(this.store, indexOf, indexOf - 1);
        }
    }

    void remove(EncodersGroup group) {
        this.store.remove(group);
    }

    boolean canMoveUp(EncodersGroup group) {
        int indexOf = this.store.indexOf(group);
        return indexOf > 0;
    }

    void moveDown(EncodersGroup group) {
        int size;
        int indexOf = this.store.indexOf(group);
        if (indexOf < (size = this.store.size()) - 1) {
            Collections.swap(this.store, indexOf, indexOf + 1);
        }
    }

    boolean canMoveDown(EncodersGroup group) {
        int size;
        int indexOf = this.store.indexOf(group);
        return indexOf < (size = this.store.size()) - 1;
    }

    public EncodersGroup[] getStore() {
        return this.store.toArray(new EncodersGroup[this.store.size()]);
    }

    public void store(IPreferenceStore preferenceStore) {
        preferenceStore.setValue(PropertiesStore.class.getName(), this.store.size());
        for (int i = 0; i < this.store.size(); ++i) {
            this.store.get(i).store(i, preferenceStore);
        }
    }

    public void newGroup(String groupName) {
        EncodersGroup encodersGroup = new EncodersGroup();
        encodersGroup.setGroupName(groupName);
        this.store.add(encodersGroup);
    }

    public Object getGroup(String groupName) {
        for (EncodersGroup group : this.store) {
            if (!group.getGroupName().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    public static class EncoderDef
    implements Validator {
        @InputField(name="Name", required=true)
        @InputTextField(validateNotEmpty=true, validationPattern="\\w.*\\w", validationMessage="Encoder name must be a word")
        String name;
        private boolean enabled = true;
        @InputField(name="Class name", required=true)
        @InputTextField(validateNotEmpty=true)
        String className;
        @InputField(name="Encoding Method")
        String encodingMethod;
        @InputField(name="Classpath")
        @InputFileField(buttonText="Add jar", filterExtensions={"*.jar", "*.*"}, relative=true)
        @InputDirectoryField(buttonText="Add class folder")
        @InputListField(inputType={InputListField.InputType.UP, InputListField.InputType.DOWN})
        String[] classPath;

        EncoderDef() {
        }

        private EncoderDef(int i, int j, IPreferenceStore preferenceStore, boolean isDefault) throws MalformedURLException {
            String prefix = this.getClass().getName() + "." + String.valueOf(i) + "." + String.valueOf(j) + ".";
            String string = this.name = isDefault ? preferenceStore.getDefaultString(prefix + "name") : preferenceStore.getString(prefix + "name");
            this.enabled = preferenceStore.contains(prefix + "enabled") ? (isDefault ? preferenceStore.getDefaultBoolean(prefix + "enabled") : preferenceStore.getBoolean(prefix + "enabled")) : true;
            this.encodingMethod = preferenceStore.contains(prefix + "encodingMethod") ? (isDefault ? preferenceStore.getDefaultString(prefix + "encodingMethod") : preferenceStore.getString(prefix + "encodingMethod")) : null;
            this.className = isDefault ? preferenceStore.getDefaultString(prefix + "className") : preferenceStore.getString(prefix + "className");
            int classPathLength = isDefault ? preferenceStore.getDefaultInt(prefix + "classPath") : preferenceStore.getInt(prefix + "classPath");
            this.classPath = new String[classPathLength];
            for (int k = 0; k < classPathLength; ++k) {
                this.classPath[k] = isDefault ? preferenceStore.getDefaultString(prefix + "classPath." + String.valueOf(k)) : preferenceStore.getString(prefix + "classPath." + String.valueOf(k));
            }
        }

        private void store(int i, int j, IPreferenceStore preferenceStore) {
            String prefix = this.getClass().getName() + "." + String.valueOf(i) + "." + String.valueOf(j) + ".";
            preferenceStore.setValue(prefix + "name", this.name);
            preferenceStore.setValue(prefix + "className", this.className);
            preferenceStore.setValue(prefix + "enabled", this.enabled);
            if (this.encodingMethod != null) {
                preferenceStore.setValue(prefix + "encodingMethod", this.encodingMethod);
            }
            if (this.classPath != null) {
                preferenceStore.setValue(prefix + "classPath", this.classPath.length);
                for (int k = 0; k < this.classPath.length; ++k) {
                    preferenceStore.setValue(prefix + "classPath." + String.valueOf(k), this.classPath[k].toString());
                }
            } else {
                preferenceStore.setValue(prefix + "classPath", 0);
            }
        }

        @Override
        public String isValid() {
            try {
                Class<?> encoderClass = this.getEncoderClass();
                if (!AbstractEncoder.class.isAssignableFrom(encoderClass)) {
                    return "The encoder class must be instance of AbstractEncoder";
                }
            }
            catch (ClassNotFoundException e) {
                return "Class not found";
            }
            catch (MalformedURLException e) {
                return e.getMessage();
            }
            return null;
        }

        public Class<?> getEncoderClass() throws ClassNotFoundException, MalformedURLException {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (this.classPath != null) {
                URL[] urls = new URL[this.classPath.length];
                for (int i = 0; i < this.classPath.length; ++i) {
                    urls[i] = new File(this.classPath[i]).toURI().toURL();
                }
                classLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
            }
            return classLoader.loadClass(this.className);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getName() {
            return this.name;
        }

        public String getEncodingMethod() {
            return this.encodingMethod;
        }
    }

    public static class EncodersGroup {
        private String groupName;
        private boolean enabled = true;
        private List<EncoderDef> list = new ArrayList<EncoderDef>();

        private EncodersGroup() {
        }

        public EncodersGroup(int i, IPreferenceStore preferenceStore, boolean isDefault) throws MalformedURLException {
            String groupStr = this.getClass().getName() + "." + String.valueOf(i) + ".group";
            this.groupName = isDefault ? preferenceStore.getDefaultString(groupStr) : preferenceStore.getString(groupStr);
            String enabledStr = this.getClass().getName() + "." + String.valueOf(i) + ".enabled";
            this.enabled = preferenceStore.contains(enabledStr) ? (isDefault ? preferenceStore.getDefaultBoolean(enabledStr) : preferenceStore.getBoolean(enabledStr)) : true;
            String encodersStr = this.getClass().getName() + "." + String.valueOf(i) + ".encoders";
            int encodersAmount = isDefault ? preferenceStore.getDefaultInt(encodersStr) : preferenceStore.getInt(encodersStr);
            for (int j = 0; j < encodersAmount; ++j) {
                this.list.add(new EncoderDef(i, j, preferenceStore, isDefault));
            }
        }

        public void moveUp(EncoderDef encoderDef) {
            int indexOf = this.list.indexOf(encoderDef);
            if (indexOf > 0) {
                Collections.swap(this.list, indexOf, indexOf - 1);
            }
        }

        public boolean canMoveUp(EncoderDef def) {
            int indexOf = this.list.indexOf(def);
            return indexOf > 0;
        }

        public void moveDown(EncoderDef encoderDef) {
            int size;
            int indexOf = this.list.indexOf(encoderDef);
            if (indexOf < (size = this.list.size()) - 1) {
                Collections.swap(this.list, indexOf, indexOf + 1);
            }
        }

        public boolean canMoveDown(EncoderDef def) {
            int size;
            int indexOf = this.list.indexOf(def);
            return indexOf < (size = this.list.size()) - 1;
        }

        public void store(int i, IPreferenceStore preferenceStore) {
            preferenceStore.setValue(this.getClass().getName() + "." + String.valueOf(i) + ".group", this.groupName);
            preferenceStore.setValue(this.getClass().getName() + "." + String.valueOf(i) + ".enabled", this.enabled);
            preferenceStore.setValue(this.getClass().getName() + "." + String.valueOf(i) + ".encoders", this.list.size());
            for (int j = 0; j < this.list.size(); ++j) {
                this.list.get(j).store(i, j, preferenceStore);
            }
        }

        public void remove(EncoderDef encoderDef) {
            this.list.remove(encoderDef);
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public void setList(List<EncoderDef> list) {
            this.list = list;
        }

        public List<EncoderDef> getList() {
            return this.list;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

