/*
 * Decompiled with CFR 0.152.
 */
package tarlog.encoder.tool.encoders;

import org.apache.commons.lang.StringEscapeUtils;
import tarlog.encoder.tool.api.AbstractEncoder;
import tarlog.ui.swt.ddialog.api.fields.InputField;

public class EscapingEncoder
extends AbstractEncoder {
    @InputField(name="Method", readonly=true, required=true)
    private Methods method;

    @Override
    public Object encode(String source) {
        switch (this.method) {
            case EscapeXML: {
                return StringEscapeUtils.escapeXml((String)source);
            }
            case UnescapeXML: {
                return StringEscapeUtils.unescapeXml((String)source);
            }
            case EscapeHTML: {
                return StringEscapeUtils.escapeHtml((String)source);
            }
            case UnescapeHTML: {
                return StringEscapeUtils.unescapeHtml((String)source);
            }
            case EscapeJava: {
                return StringEscapeUtils.escapeJava((String)source);
            }
            case UnescapeJava: {
                return StringEscapeUtils.unescapeJava((String)source);
            }
            case EscapeJavascript: {
                return StringEscapeUtils.escapeJavaScript((String)source);
            }
            case UnescapeJavascript: {
                return StringEscapeUtils.unescapeJavaScript((String)source);
            }
            case EscapeSql: {
                return StringEscapeUtils.escapeSql((String)source);
            }
        }
        return null;
    }

    @Override
    protected String historyInfo() {
        String historyInfo = super.historyInfo();
        return String.format("%s (%s)", historyInfo, String.valueOf((Object)this.method));
    }

    private static enum Methods {
        EscapeXML,
        UnescapeXML,
        EscapeHTML,
        UnescapeHTML,
        EscapeJava,
        UnescapeJava,
        EscapeJavascript,
        UnescapeJavascript,
        EscapeSql;

    }
}

