/*
 * Decompiled with CFR 0.152.
 */
package tarlog.encoder.tool.encoders;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import tarlog.encoder.tool.SignatureAlgorithms;
import tarlog.encoder.tool.api.AbstractEncoder;
import tarlog.ui.swt.ddialog.api.fields.InputField;
import tarlog.ui.swt.ddialog.api.fields.InputTextField;
import tarlog.ui.swt.ddialog.utils.Utils;

public class X509CertificateEncoder
extends AbstractEncoder {
    private X509Certificate cert;
    @InputField(name="Certificate File", required=true, order=-300)
    private File file;
    @InputField(name="Algorithm", readonly=true)
    private SignatureAlgorithms algorithm = SignatureAlgorithms.SHA1withDSA;
    @InputField(name="Signature", required=true)
    @InputTextField(multiline=true, validateNotEmpty=true)
    private String signature;

    @Override
    protected int beforeEncode() {
        int inputStatus = super.beforeEncode();
        if (inputStatus != 0) {
            return inputStatus;
        }
        try {
            FileInputStream inStream = new FileInputStream(this.file);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.cert = (X509Certificate)cf.generateCertificate(inStream);
            ((InputStream)inStream).close();
            return 0;
        }
        catch (Exception e) {
            this.showException(e);
            return 1;
        }
    }

    @Override
    public Object encode(byte[] source) {
        try {
            PublicKey publicKey = this.cert.getPublicKey();
            Signature sig = Signature.getInstance(this.algorithm.name());
            sig.initVerify(publicKey);
            sig.update(source);
            return String.valueOf(sig.verify(Utils.bytesFromHex(this.signature)));
        }
        catch (Exception e) {
            this.showException(e);
            return null;
        }
    }
}

