/*
 * Decompiled with CFR 0.152.
 */
package tarlog.encoder.tool.ui;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import tarlog.encoder.tool.eclipse.preferences.EncoderToolPreferencePage;
import tarlog.encoder.tool.ui.EncoderUI;
import tarlog.encoder.tool.ui.inner.ExitAction;
import tarlog.ui.swt.ddialog.utils.Utils;

public class EncoderTool
extends ApplicationWindow {
    static final String ENCODER_PROPERTIES = "encoder.properties";
    private static final String VERSION = "0.5.1";
    private static final String TITLE = "Diagnostic Tool";
    private Shell shell;
    private boolean standalone = false;
    private EncoderUI encoderUI;

    public EncoderTool() {
        super(null);
    }

    public void init() throws IOException {
        this.setBlockOnOpen(true);
        if (this.standalone) {
            this.addMenuBar();
        }
        this.open();
    }

    private Image getImage() {
        try {
            InputStream img = Utils.getFile("icons/encoders.jpg");
            ImageLoader imageLoader = new ImageLoader();
            ImageData[] load = imageLoader.load(img);
            return new Image((Device)this.shell.getDisplay(), load[0]);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    protected MenuManager createMenuManager() {
        MenuManager menuManager = super.createMenuManager();
        MenuManager fileMenuManager = new MenuManager("&File");
        fileMenuManager.add((IAction)new OpenPreferencesAction());
        fileMenuManager.add((IAction)new ExitAction((Window)this));
        menuManager.add((IContributionItem)fileMenuManager);
        return menuManager;
    }

    protected Control createContents(Composite parent) {
        this.shell = this.getShell();
        this.shell.setText("Encoder Tool 0.5.1");
        this.shell.setSize(1000, 700);
        Image image = this.getImage();
        if (image != null) {
            this.shell.setImage(image);
        }
        this.encoderUI = new EncoderUI((Composite)this.shell, this.standalone);
        return this.shell;
    }

    public static void main(String[] args) throws Exception {
        EncoderTool encoderTool = new EncoderTool();
        encoderTool.standalone = true;
        encoderTool.init();
        Display.getCurrent().dispose();
    }

    private class OpenPreferencesAction
    extends Action {
        public OpenPreferencesAction() {
            super("Preferences");
        }

        public void run() {
            try {
                EncoderToolPreferencePage page = new EncoderToolPreferencePage(EncoderTool.ENCODER_PROPERTIES);
                page.setTitle(EncoderTool.TITLE);
                PreferenceManager mgr = new PreferenceManager();
                PreferenceNode node = new PreferenceNode("1", (IPreferencePage)page);
                mgr.addToRoot((IPreferenceNode)node);
                PreferenceDialog dialog = new PreferenceDialog(EncoderTool.this.shell, mgr);
                dialog.create();
                dialog.setMessage(page.getTitle());
                int rc = dialog.open();
                if (rc == 0) {
                    EncoderTool.this.encoderUI.reload();
                }
            }
            catch (IOException e) {
                Utils.showException(EncoderTool.this.shell, e);
            }
        }
    }
}

