/*
 * Decompiled with CFR 0.152.
 */
package tarlog.encoder.tool.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tarlog.encoder.tool.api.AbstractEncoder;
import tarlog.encoder.tool.api.Initiable;
import tarlog.encoder.tool.eclipse.Activator;
import tarlog.encoder.tool.eclipse.preferences.PropertiesStore;
import tarlog.encoder.tool.ui.GridComposite;
import tarlog.encoder.tool.ui.inner.HistoryManager;
import tarlog.encoder.tool.ui.inner.InputTextEditor;
import tarlog.encoder.tool.ui.inner.SwapButton;
import tarlog.ui.swt.ddialog.utils.AbstractSelectionListener;
import tarlog.ui.swt.ddialog.utils.Utils;

public class EncoderUI
extends SashForm {
    private Text targetText;
    private Text sourceText;
    private Composite leftComposite;
    private PropertiesStore propertiesStore;
    private HistoryManager historyManager;
    private Shell shell;
    private boolean standalone = false;

    public EncoderUI(Composite parent, boolean standalone) {
        super(parent, 512);
        this.shell = parent.getShell();
        this.standalone = standalone;
        this.createTopPart((Composite)this);
        this.createBottomPart((Composite)this);
        this.setWeights(new int[]{1, 2});
        this.initEncodersStore();
        this.load();
    }

    private void createTopPart(Composite parent) {
        SashForm sashForm = new SashForm(parent, 256);
        GridComposite leftComposite = new GridComposite((Composite)sashForm);
        InputTextEditor textEditor = new InputTextEditor(leftComposite, 2050);
        this.sourceText = textEditor.getText();
        GridComposite textEditorBottomComposite = textEditor.getBottomComposite();
        ++((GridLayout)textEditorBottomComposite.getLayout()).numColumns;
        new SwapButton((Composite)textEditorBottomComposite, this);
        GridComposite rightComposite = new GridComposite((Composite)sashForm);
        GridData gridData = new GridData(0x1000000, 4, false, true);
        rightComposite.setLayoutData(gridData);
        this.historyManager = new HistoryManager(rightComposite, this);
        sashForm.setWeights(new int[]{5, 1});
    }

    private void createBottomPart(Composite parent) {
        SashForm sashForm = new SashForm(parent, 256);
        this.createLeftPart((Composite)sashForm);
        this.createRightPart((Composite)sashForm);
        sashForm.setWeights(new int[]{1, 3});
    }

    private void createLeftPart(Composite parent) {
        ScrolledComposite scrolledComposite = null;
        scrolledComposite = new ScrolledComposite(parent, 2816);
        scrolledComposite.setLayout((Layout)new GridLayout());
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        parent = scrolledComposite;
        this.leftComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.leftComposite.setLayout((Layout)layout);
        this.leftComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite.setContent((Control)this.leftComposite);
    }

    private void initEncodersStore() {
        try {
            IPreferenceStore preferenceStore;
            if (this.standalone) {
                PreferenceStore store = new PreferenceStore("encoder.properties");
                store.load();
                preferenceStore = store;
            } else {
                preferenceStore = Activator.getDefault().getPreferenceStore();
            }
            this.propertiesStore = new PropertiesStore(preferenceStore, false);
        }
        catch (MalformedURLException e) {
            Utils.showException(this.shell, e);
        }
        catch (IOException e) {
            Utils.showException(this.shell, e);
        }
    }

    void reload() throws IOException {
        for (Control control : this.leftComposite.getChildren()) {
            if (control.isDisposed()) continue;
            control.dispose();
        }
        this.initEncodersStore();
        this.load();
        this.leftComposite.layout(true, true);
    }

    private void load() {
        final ArrayList<Button> radioButtons = new ArrayList<Button>();
        for (PropertiesStore.EncodersGroup encodersGroup : this.propertiesStore.getStore()) {
            if (!encodersGroup.isEnabled()) continue;
            Group group = new Group(this.leftComposite, 0);
            group.setText(encodersGroup.getGroupName());
            Group grouping = group;
            grouping.setLayout((Layout)new GridLayout());
            GridData layoutData = new GridData(4, 4, true, true);
            grouping.setLayoutData((Object)layoutData);
            for (PropertiesStore.EncoderDef encoderDef : encodersGroup.getList()) {
                if (!encoderDef.isEnabled()) continue;
                try {
                    Class<?> clazz = encoderDef.getEncoderClass();
                    final AbstractEncoder encoder = (AbstractEncoder)clazz.newInstance();
                    encoder.setSource(this.sourceText);
                    encoder.setTarget(this.targetText);
                    encoder.setName(encoderDef.getName());
                    encoder.setEncodingMethod(encoderDef.getEncodingMethod());
                    encoder.setShell(this.shell);
                    encoder.setHistoryManager(this.historyManager);
                    Composite composite = new Composite((Composite)grouping, 0);
                    composite.setLayoutData((Object)new GridData(4, 4, true, true));
                    RowLayout layout = new RowLayout();
                    layout.type = 256;
                    composite.setLayout((Layout)layout);
                    Button button = new Button(composite, 16);
                    radioButtons.add(button);
                    button.setText(encoder.getName());
                    button.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            for (Button radioButton : radioButtons) {
                                if (e.getSource() == radioButton) continue;
                                radioButton.setSelection(false);
                            }
                        }
                    });
                    button.addSelectionListener((SelectionListener)encoder);
                    if (!(encoder instanceof Initiable)) continue;
                    Button fileButton = new Button(composite, 4);
                    fileButton.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            ((Initiable)((Object)encoder)).init();
                            EncoderUI.this.leftComposite.setSize(EncoderUI.this.leftComposite.computeSize(-1, -1));
                        }
                    });
                }
                catch (Exception e) {
                    Utils.showException(this.shell, e);
                }
            }
        }
        this.leftComposite.setSize(this.leftComposite.computeSize(-1, -1));
    }

    private void createRightPart(Composite parent) {
        InputTextEditor textEditor = new InputTextEditor(parent, 2058);
        this.targetText = textEditor.getText();
    }

    public Text getTargetText() {
        return this.targetText;
    }

    public Text getSourceText() {
        return this.sourceText;
    }
}

