/*
 * Decompiled with CFR 0.152.
 */
package tarlog.encoder.tool.ui.inner;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import tarlog.encoder.tool.ui.EncoderUI;
import tarlog.ui.swt.ddialog.utils.AbstractSelectionListener;

public class HistoryManager {
    private List<Step> history = new ArrayList<Step>();
    private final org.eclipse.swt.widgets.List historyList;
    private final int MAX_HISTORY_SIZE = 50;

    public HistoryManager(Composite rightComposite, final EncoderUI encoderTool) {
        Label label = new Label(rightComposite, 0);
        GridData gridData = new GridData(16384, 1024, false, false);
        label.setLayoutData((Object)gridData);
        label.setText("History:");
        this.historyList = new org.eclipse.swt.widgets.List(rightComposite, 2820);
        this.historyList.setLayoutData((Object)new GridData(4, 4, true, true));
        Menu menu = new Menu((Control)this.historyList);
        this.historyList.setMenu(menu);
        final MenuItem removeMenuItem = new MenuItem(menu, 0);
        removeMenuItem.setText("Remove");
        removeMenuItem.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = HistoryManager.this.historyList.getSelectionIndex();
                HistoryManager.this.remove(selectionIndex);
                HistoryManager.this.historyList.setTopIndex(HistoryManager.this.historyList.getItemCount() > 0 ? HistoryManager.this.historyList.getItemCount() - 1 : 0);
            }
        });
        final MenuItem clearMenuItem = new MenuItem(menu, 0);
        clearMenuItem.setText("Clear");
        clearMenuItem.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                HistoryManager.this.history.clear();
                HistoryManager.this.historyList.removeAll();
            }
        });
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                int selectionIndex = HistoryManager.this.historyList.getSelectionIndex();
                if (selectionIndex != -1) {
                    removeMenuItem.setEnabled(true);
                } else {
                    removeMenuItem.setEnabled(false);
                }
                if (HistoryManager.this.historyList.getItemCount() > 0) {
                    clearMenuItem.setEnabled(true);
                } else {
                    clearMenuItem.setEnabled(false);
                }
            }
        });
        this.historyList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                int selectionIndex = HistoryManager.this.historyList.getSelectionIndex();
                if (selectionIndex != -1) {
                    Step step = (Step)HistoryManager.this.history.get(selectionIndex);
                    Text sourceText = encoderTool.getSourceText();
                    Text targetText = encoderTool.getTargetText();
                    Button sourceBytesButton = (Button)sourceText.getData();
                    Button targetBytesButton = (Button)targetText.getData();
                    sourceText.setText(step.sourceText);
                    sourceBytesButton.setSelection(step.sourceBytesButtonSelection);
                    targetText.setText(step.targetText);
                    targetBytesButton.setSelection(step.targetBytesButtonSelection);
                }
            }
        });
    }

    public void addStep(String name, Text sourceText, Text targetText) {
        if (this.history.size() >= 50) {
            this.remove(0);
        }
        Button sourceBytesButton = (Button)sourceText.getData();
        Button targetBytesButton = (Button)targetText.getData();
        boolean sourceBytesButtonSelection = sourceBytesButton.getSelection();
        boolean targetBytesButtonSelection = targetBytesButton.getSelection();
        this.history.add(new Step(name, sourceText.getText(), targetText.getText(), sourceBytesButtonSelection, targetBytesButtonSelection));
        this.addToHistoryList(this.history.size() - 1, name);
        this.historyList.setTopIndex(this.historyList.getItemCount() > 0 ? this.historyList.getItemCount() - 1 : 0);
    }

    private void addToHistoryList(int index, String name) {
        this.historyList.add(String.format("%d. %s", index + 1, name), index);
    }

    private void remove(int selectionIndex) {
        if (selectionIndex != -1) {
            this.history.remove(selectionIndex);
            this.historyList.removeAll();
            for (int i = 0; i < this.history.size(); ++i) {
                this.addToHistoryList(i, this.history.get((int)i).name);
            }
        }
    }

    private class Step {
        String name;
        String sourceText;
        String targetText;
        boolean sourceBytesButtonSelection;
        boolean targetBytesButtonSelection;

        Step(String name, String sourceText, String targetText, boolean sourceBytesButtonSelection, boolean targetBytesButtonSelection) {
            this.name = name;
            this.sourceText = sourceText;
            this.targetText = targetText;
            this.sourceBytesButtonSelection = sourceBytesButtonSelection;
            this.targetBytesButtonSelection = targetBytesButtonSelection;
        }
    }
}

