/*
 * Decompiled with CFR 0.152.
 */
package tarlog.encoder.tool.ui.inner;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import tarlog.encoder.tool.ui.GridComposite;
import tarlog.encoder.tool.ui.inner.ShowBytesListener;
import tarlog.ui.swt.ddialog.utils.Utils;

public class InputTextEditor
extends GridComposite {
    private final Text text;
    private final GridComposite bottomComposite;

    public GridComposite getBottomComposite() {
        return this.bottomComposite;
    }

    public InputTextEditor(Composite parent, int style) {
        super(parent, style);
        boolean readonly = (style & 8) != 0;
        this.setLayoutData(new GridData(1808));
        this.text = new Text((Composite)this, style | 0x40 | 0x200 | 0x800);
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) != 0) {
                    switch (e.keyCode) {
                        case 65: 
                        case 97: {
                            InputTextEditor.this.text.selectAll();
                        }
                    }
                }
            }
        });
        this.text.setLayoutData((Object)new GridData(1808));
        this.bottomComposite = new GridComposite(this, 0, readonly ? 4 : 5);
        this.bottomComposite.removeMargins();
        this.bottomComposite.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.createShowBytesButton();
        this.createCharsetCombo();
        this.createCleanLink();
        if (!readonly) {
            this.createImportLink();
        }
        this.createExportLink();
    }

    private void createShowBytesButton() {
        Button showBytesButton = new Button((Composite)this.bottomComposite, 32);
        showBytesButton.setData((Object)this.text);
        this.text.setData((Object)showBytesButton);
        showBytesButton.setText("Show bytes");
        showBytesButton.addSelectionListener((SelectionListener)new ShowBytesListener());
    }

    private void createCharsetCombo() {
        Combo combo = new Combo((Composite)this.bottomComposite, 4);
        combo.add("UTF-8");
        combo.add("UTF-16");
        combo.add("US-ASCII");
        combo.add("ISO-8859-1");
        combo.select(0);
        this.text.setData(Charset.class.getName(), (Object)combo);
    }

    private void createCleanLink() {
        Link cleanLink = new Link((Composite)this.bottomComposite, 0);
        cleanLink.setText("<a>Clean</a>");
        cleanLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InputTextEditor.this.text.setText("");
            }
        });
    }

    private void createImportLink() {
        Link importLink = new Link((Composite)this.bottomComposite, 0);
        importLink.setText("<a>Import</a>");
        importLink.addListener(13, new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event) {
                FileInputStream is = null;
                try {
                    FileDialog fileDialog = new FileDialog(InputTextEditor.this.getShell(), 4096);
                    String name = fileDialog.open();
                    if (name != null) {
                        is = new FileInputStream(name);
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        InputTextEditor.copyStream(is, os);
                        String bytes = Utils.bytesToHex(os.toByteArray());
                        ((Button)InputTextEditor.this.text.getData()).setSelection(true);
                        InputTextEditor.this.text.setText(bytes);
                    }
                }
                catch (IOException e) {
                    Utils.showException(InputTextEditor.this.getShell(), e);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    private void createExportLink() {
        Link importLink = new Link((Composite)this.bottomComposite, 0);
        importLink.setText("<a>Export</a>");
        importLink.addListener(13, new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event) {
                FileOutputStream os = null;
                String charsetText = null;
                try {
                    FileDialog fileDialog = new FileDialog(InputTextEditor.this.getShell(), 8192);
                    String name = fileDialog.open();
                    byte[] bytes = null;
                    if (name != null) {
                        boolean selection = ((Button)InputTextEditor.this.text.getData()).getSelection();
                        if (selection) {
                            bytes = Utils.bytesFromHex(InputTextEditor.this.text.getText());
                        } else {
                            Combo charsetCombo = (Combo)InputTextEditor.this.text.getData(Charset.class.getName());
                            charsetText = charsetCombo.getText();
                            Charset charset = Charset.forName(charsetText);
                            bytes = InputTextEditor.this.text.getText().getBytes(charset);
                        }
                        os = new FileOutputStream(name);
                        os.write(bytes);
                    }
                }
                catch (UnsupportedCharsetException e1) {
                    Utils.showErrorMessage(InputTextEditor.this.getShell(), "Unsupported charset", "Unsupported charset: " + charsetText);
                }
                catch (Exception e) {
                    Utils.showException(InputTextEditor.this.getShell(), e);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    private static void copyStream(InputStream src, OutputStream dst) throws IOException {
        byte[] bytes = new byte[1024];
        int read = 0;
        while ((read = src.read(bytes)) != -1) {
            dst.write(bytes, 0, read);
        }
    }

    public final Text getText() {
        return this.text;
    }
}

