/*
 * Decompiled with CFR 0.152.
 */
package tarlog.shavtsak.core.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import tarlog.shavtsak.core.model.ClassEntity;
import tarlog.shavtsak.core.model.Entity;
import tarlog.shavtsak.core.model.EntityMapper;
import tarlog.shavtsak.core.model.EntityStorageCreationException;
import tarlog.shavtsak.core.model.EntityStorageUtils;
import tarlog.shavtsak.core.model.FileNamesManager;
import tarlog.shavtsak.core.model.Mapper;
import tarlog.shavtsak.core.model.StorageIgnore;

public class EntityStorage {
    private static final String LAST_UID = "lastUid";
    public static boolean useDeflate = true;
    private final Properties properties;
    private int lastUid = 100;
    private final EntityStorageUtils entityStorageUtils;
    private Map<Class<? extends Entity>, Integer> cls2id = new HashMap<Class<? extends Entity>, Integer>();
    private Map<Integer, Class<? extends Entity>> id2cls = new HashMap<Integer, Class<? extends Entity>>();
    private FileNamesManager fileNamesManager;
    private Map<Integer, Entity> cache = new HashMap<Integer, Entity>();
    private static final ThreadLocal<Map<Integer, Entity>> threadLocal = new ThreadLocal();

    public EntityStorage(String baseFolder, String baseFileName) throws EntityStorageCreationException {
        this(new Properties());
        if (baseFileName == null || baseFileName == null || baseFolder.trim().isEmpty() || baseFileName.trim().isEmpty()) {
            throw new EntityStorageCreationException("Neither baseFolder nor baseFileName cannot be null or empty");
        }
        File baseFolderFile = new File(baseFolder);
        if (baseFolderFile.exists()) {
            if (!baseFolderFile.isDirectory()) {
                throw new EntityStorageCreationException(baseFolder + " is not a directory.");
            }
        } else {
            try {
                baseFolderFile.createNewFile();
            }
            catch (IOException e) {
                throw new EntityStorageCreationException(e);
            }
        }
        this.fileNamesManager = new FileNamesManager(baseFolderFile, baseFileName);
    }

    private EntityStorage(Properties properties) {
        this.properties = properties;
        this.cls2id.put(ClassEntity.class, 0);
        this.id2cls.put(0, ClassEntity.class);
        this.entityStorageUtils = new EntityStorageUtils(properties, this);
        String lastUidProperty = properties.getProperty(LAST_UID);
        if (lastUidProperty != null) {
            this.lastUid = Integer.parseInt(lastUidProperty);
        }
    }

    private void load(InputStream inputStream) throws IOException {
        if (useDeflate) {
            inputStream = new InflaterInputStream(inputStream);
        }
        this.properties.clear();
        this.cache.clear();
        this.properties.load(inputStream);
        String lastUidProperty = this.properties.getProperty(LAST_UID);
        if (lastUidProperty != null) {
            this.lastUid = Integer.parseInt(lastUidProperty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File file) throws IOException {
        if (file.exists() && file.isFile()) {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(file);
                this.load(inStream);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void loadLatestVersion() throws IOException {
        File latestFile = this.fileNamesManager.getLatestFile();
        if (latestFile != null) {
            this.load(latestFile);
        }
    }

    public boolean isPreviousExists() {
        return this.fileNamesManager.isPreviousExists();
    }

    public boolean isRedoExists() {
        return this.fileNamesManager.isRedoExists();
    }

    public void loadRedoVersion() throws IOException {
        File redoFile = this.fileNamesManager.getRedoFile();
        if (redoFile != null) {
            this.load(redoFile);
        }
    }

    public void cleanRedo() {
        this.fileNamesManager.cleanRedo();
    }

    public void loadPreviousVersion() throws IOException {
        File previousFile = this.fileNamesManager.getPreviousFile();
        if (previousFile != null) {
            this.load(previousFile);
        }
    }

    public void save() throws IOException {
        this.save(this.fileNamesManager.getNextSaveName());
    }

    private void save(OutputStream outputStream) throws IOException {
        this.properties.setProperty(LAST_UID, String.valueOf(this.lastUid));
        if (useDeflate) {
            DeflaterOutputStream os = new DeflaterOutputStream(outputStream);
            this.properties.store(os, null);
            os.finish();
        } else {
            this.properties.store(outputStream, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(File file) throws IOException {
        FileOutputStream outStream = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            outStream = new FileOutputStream(file);
            this.save(outStream);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void storeEntity(Entity entity) throws Exception {
        this.innerStoreEntity(entity, new HashSet<Entity>());
    }

    public void storeEntities(Collection<? extends Entity> col) throws Exception {
        for (Entity entity : col) {
            this.storeEntity(entity);
        }
    }

    void innerStoreEntity(Entity entity, Set<Entity> stored) throws Exception {
        if (!stored.add(entity)) {
            return;
        }
        this.ensureId(entity);
        this.cache.put(entity.getId(), entity);
        Class<?> cls = entity.getClass();
        int id = entity.getId();
        boolean existingEntity = this.properties.getProperty(String.valueOf(id) + ".class") != null;
        String prefix = String.valueOf(id);
        Collection<Field> fields = this.getFields(cls);
        for (Field field : fields) {
            String name = field.getName();
            String propertyName = prefix + "." + name;
            if (existingEntity) {
                String sizeString;
                Class<?> fieldType = field.getType();
                if ((fieldType.isArray() || Collection.class.isAssignableFrom(fieldType)) && (sizeString = this.properties.getProperty(propertyName)) != null) {
                    int size = Integer.parseInt(sizeString);
                    for (int i = 0; i < size; ++i) {
                        this.properties.remove(propertyName + "." + String.valueOf(i));
                    }
                }
                this.properties.remove(propertyName);
            }
            field.setAccessible(true);
            Object object = field.get(entity);
            if (object == null) continue;
            Mapper mapperAnnotation = field.getAnnotation(Mapper.class);
            if (mapperAnnotation != null) {
                Class<? extends EntityMapper> value = mapperAnnotation.value();
                EntityMapper mapper = value.newInstance();
                object = mapper.toEntity(object);
            }
            this.entityStorageUtils.storeField(propertyName, object, stored);
        }
        this.addIdToClass(cls, id);
        this.storeClassName(cls, id);
    }

    private void storeClassName(Class<? extends Entity> cls, int id) throws Exception {
        int classId = this.getClassId(cls);
        this.properties.setProperty(String.format("%d.class", id), String.valueOf(classId));
    }

    private <T extends Entity> int getClassId(Class<T> cls) throws Exception {
        Integer id = this.cls2id.get(cls);
        if (id == null) {
            ClassEntity<T> example = new ClassEntity<T>(cls);
            this.storeEntity(example);
            id = example.getId();
            this.cls2id.put(cls, id);
            this.id2cls.put(id, cls);
        }
        return id;
    }

    private void addIdToClass(Class<?> cls, int iId) {
        String id;
        String ids = this.properties.getProperty(cls.getName());
        LinkedList<String> split = ids == null || ids.isEmpty() ? new LinkedList<String>() : new LinkedList<String>(Arrays.asList(ids.split(";")));
        int binarySearch = Collections.binarySearch(split, id = String.valueOf(iId));
        if (binarySearch < 0) {
            split.add(-binarySearch - 1, id);
            StringBuilder buf = new StringBuilder(split.get(0));
            for (int i = 1; i < split.size(); ++i) {
                buf.append(';');
                buf.append(split.get(i));
            }
            this.properties.setProperty(cls.getName(), buf.toString());
            Class<?> superclass = cls.getSuperclass();
            if (superclass != null && superclass != Entity.class) {
                this.addIdToClass(cls.getSuperclass(), iId);
            }
            for (Class<?> intr : cls.getInterfaces()) {
                this.addIdToClass(intr, iId);
            }
        }
    }

    public <T extends Entity> List<T> getAllEntities(Class<T> cls) throws Exception {
        String ids = this.properties.getProperty(cls.getName());
        if (ids == null) {
            return Collections.emptyList();
        }
        String[] split = ids.split(";");
        ArrayList<T> collection = new ArrayList<T>(split.length);
        for (String id : split) {
            T entity = this.getEntityById(Integer.parseInt(id));
            collection.add(entity);
        }
        return collection;
    }

    public <T extends Entity> T getEntityById(int id) throws Exception {
        threadLocal.set(new HashMap());
        T result = this.innerGetEntityById(id);
        threadLocal.set(null);
        return result;
    }

    <T extends Entity> T innerGetEntityById(int id) throws Exception {
        Entity entity = this.cache.get(id);
        if (entity != null) {
            return (T)entity;
        }
        entity = threadLocal.get().get(id);
        if (entity != null) {
            return (T)entity;
        }
        String classId = this.properties.getProperty(String.valueOf(id) + ".class");
        if (classId != null) {
            T newEntity = this.createEntity(this.getClassById(classId), id);
            this.cache.put(id, (Entity)newEntity);
            return newEntity;
        }
        return null;
    }

    private <T extends Entity> Class<T> getClassById(String classId) throws Exception {
        int id = Integer.parseInt(classId);
        Class<Entity> cls = this.id2cls.get(id);
        if (cls == null) {
            ClassEntity entity = (ClassEntity)this.innerGetEntityById(id);
            cls = entity.getCls();
            this.id2cls.put(id, cls);
            this.cls2id.put(cls, id);
        }
        return cls;
    }

    public <T extends Entity> Set<T> getByExample(T example) throws Exception {
        Class<?> cls = example.getClass();
        HashSet<Entity> collection = new HashSet<Entity>();
        for (Entity entity : this.getAllEntities(cls)) {
            if (!this.entitiesEqualIgnoreNulls(example, entity)) continue;
            collection.add(entity);
        }
        return collection;
    }

    private <T extends Entity> boolean entitiesEqualIgnoreNulls(T e1, T e2) throws Exception {
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e1 == e2) {
            return true;
        }
        if (e1.getClass() != e2.getClass()) {
            return false;
        }
        Collection<Field> fields = this.getFields(e1.getClass());
        for (Field f : fields) {
            if (f.getName().equals("id")) continue;
            f.setAccessible(true);
            Object o1 = f.get(e1);
            Object o2 = f.get(e2);
            if (o1 == null || o2 == null || o1.equals(o2)) continue;
            return false;
        }
        return true;
    }

    public void deleteAll(Class<?> cls) throws Exception {
        String[] split;
        String ids = this.properties.getProperty(cls.getName());
        if (ids == null) {
            return;
        }
        for (String id : split = ids.split(";")) {
            this.delete(Integer.parseInt(id));
        }
    }

    public boolean delete(Entity entity) throws Exception {
        if (entity.getId() < 0) {
            return false;
        }
        return this.delete(entity.getId());
    }

    public boolean delete(int id) throws Exception {
        this.cache.put(id, null);
        String classId = this.properties.getProperty(String.valueOf(id) + ".class");
        if (classId == null) {
            return false;
        }
        Class cls = this.getClassById(classId);
        this.removeIdFromClass(id, cls);
        return true;
    }

    private void removeIdFromClass(int iId, Class<?> cls) {
        String ids = this.properties.getProperty(cls.getName());
        String id = String.valueOf(iId);
        if (ids == null) {
            return;
        }
        LinkedList<String> split = new LinkedList<String>(Arrays.asList(ids.split(";")));
        if (split.isEmpty()) {
            return;
        }
        int binarySearch = Collections.binarySearch(split, id);
        if (binarySearch >= 0) {
            split.remove(binarySearch);
            StringBuilder buf = split.isEmpty() ? new StringBuilder() : new StringBuilder(split.get(0));
            for (int i = 1; i < split.size(); ++i) {
                buf.append(';');
                buf.append(split.get(i));
            }
            this.properties.setProperty(cls.getName(), buf.toString());
            Class<?> superclass = cls.getSuperclass();
            if (superclass != null && superclass != Entity.class) {
                this.removeIdFromClass(iId, cls.getSuperclass());
            }
            for (Class<?> intr : cls.getInterfaces()) {
                this.removeIdFromClass(iId, intr);
            }
        }
    }

    private <T extends Entity> T createEntity(Class<T> cls, int id) throws Exception {
        Entity newInstance = (Entity)cls.newInstance();
        threadLocal.get().put(id, newInstance);
        newInstance.setId(id);
        String prefix = String.valueOf(id);
        Collection<Field> fields = this.getFields(cls);
        for (Field field : fields) {
            String name = field.getName();
            String propertyName = prefix + "." + name;
            String property = this.properties.getProperty(propertyName);
            if (property == null) continue;
            Class<?> type = field.getType();
            Class<?> genericType = field.getGenericType();
            Mapper mapperAnnotation = field.getAnnotation(Mapper.class);
            EntityMapper mapper = null;
            if (mapperAnnotation != null) {
                Class<? extends EntityMapper> mapperClass = mapperAnnotation.value();
                mapper = mapperClass.newInstance();
                type = mapper.getEntityClass();
                genericType = mapper.getEntityClass();
            }
            Object fieldValue = this.entityStorageUtils.retrieveFieldValue(propertyName, type, genericType, property);
            field.setAccessible(true);
            if (mapper == null) {
                field.set(newInstance, fieldValue);
                continue;
            }
            field.set(newInstance, mapper.fromEntity((Entity)fieldValue));
        }
        return (T)newInstance;
    }

    private void ensureId(Entity entity) {
        if (entity.getId() <= 0) {
            entity.setId(++this.lastUid);
        }
    }

    private Collection<Field> getFields(Class<?> cls) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        while (cls != Object.class) {
            Field[] declaredFields;
            for (Field field : declaredFields = cls.getDeclaredFields()) {
                Field old;
                if (Modifier.isStatic(field.getModifiers()) || field.getAnnotation(StorageIgnore.class) != null || (old = map.put(field.getName(), field)) == null) continue;
                throw new RuntimeException(String.format("The field with name %s was already defined by a superclass.", field.getName()));
            }
            cls = cls.getSuperclass();
        }
        return map.values();
    }
}

