/*
 * Decompiled with CFR 0.152.
 */
package tarlog.shavtsak.core.model;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.AbstractCollection;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import tarlog.shavtsak.core.model.Entity;
import tarlog.shavtsak.core.model.EntityStorage;

class EntityStorageUtils {
    private static final String PROPERTIES_VALUE = "%s.%d.value";
    private static final String PROPERTIES_KEY = "%s.%d.key";
    private final Properties properties;
    private final EntityStorage entityStorage;

    public EntityStorageUtils(Properties properties, EntityStorage entityStorage) {
        this.properties = properties;
        this.entityStorage = entityStorage;
    }

    void storeField(String name, Object obj, Set<Entity> storedEntities) throws Exception {
        if (obj == null) {
            return;
        }
        Class<?> type = obj.getClass();
        if (type == String.class) {
            this.properties.setProperty(name, (String)obj);
        } else if (type == Class.class) {
            Class cls = (Class)obj;
            this.properties.setProperty(name, cls.getName());
        } else if (type == Field.class) {
            Field field = (Field)obj;
            this.properties.setProperty(name, field.getName() + "@" + field.getDeclaringClass().getName());
        } else if (Charset.class.isAssignableFrom(type)) {
            Charset charset = (Charset)obj;
            this.properties.setProperty(name, charset.displayName());
        } else if (type == Properties.class) {
            Properties props = (Properties)obj;
            int i = 0;
            for (String key : props.stringPropertyNames()) {
                this.properties.setProperty(String.format(PROPERTIES_KEY, name, i), key);
                this.properties.setProperty(String.format(PROPERTIES_VALUE, name, i), props.getProperty(key));
                ++i;
            }
            this.properties.setProperty(name, String.valueOf(i));
        } else if (type == File.class) {
            File file = (File)obj;
            this.properties.setProperty(name, file.getPath());
        } else if (type == Integer.class || type == Integer.TYPE || type == Boolean.class || type == Character.class || type == Character.TYPE || type == Boolean.TYPE) {
            this.properties.setProperty(name, String.valueOf(obj));
        } else if (type.isArray()) {
            int size = Array.getLength(obj);
            this.properties.setProperty(name, String.valueOf(size));
            for (int i = 0; i < size; ++i) {
                Object o = Array.get(obj, i);
                this.storeField(name + "." + String.valueOf(i), o, storedEntities);
            }
        } else if (Collection.class.isAssignableFrom(type)) {
            Collection set = (Collection)obj;
            int size = set.size();
            this.properties.setProperty(name, String.valueOf(size));
            int i = 0;
            for (Object o : set) {
                this.storeField(name + "." + String.valueOf(i), o, storedEntities);
                ++i;
            }
        } else if (obj instanceof Entity) {
            Entity entity = (Entity)obj;
            this.entityStorage.innerStoreEntity(entity, storedEntities);
            int entityId = entity.getId();
            this.properties.setProperty(name, String.valueOf(entityId));
        } else {
            if (Calendar.class.isAssignableFrom(type)) {
                Calendar calendar = (Calendar)obj;
                obj = calendar.getTime();
            }
            if (obj instanceof Date) {
                Date date = (Date)obj;
                this.properties.setProperty(name, String.valueOf(date.getTime()));
            }
        }
    }

    Object retrieveFieldValue(String propertyName, Class<?> type, Type genericType, String stringValue) throws Exception {
        if (type == String.class) {
            return stringValue;
        }
        if (type == Integer.class) {
            return new Integer(Integer.parseInt(stringValue));
        }
        if (type == Integer.TYPE) {
            return Integer.parseInt(stringValue);
        }
        if (type == Character.class || type == Character.TYPE) {
            return stringValue.length() > 0 ? Character.valueOf(stringValue.charAt(0)) : null;
        }
        if (type == File.class) {
            return new File(stringValue);
        }
        if (type == Boolean.TYPE) {
            return Boolean.parseBoolean(stringValue);
        }
        if (type == Boolean.class) {
            return new Boolean(Boolean.parseBoolean(stringValue));
        }
        if (type == Field.class) {
            String[] split = stringValue.split("@");
            if (split.length != 2) {
                System.out.println("Field format error!");
                return null;
            }
            Class<?> cls = Class.forName(split[1]);
            return cls.getDeclaredField(split[0]);
        }
        if (type == Class.class) {
            return Class.forName(stringValue);
        }
        if (type == Properties.class) {
            Properties props = new Properties();
            int size = Integer.parseInt(stringValue);
            for (int i = 0; i < size; ++i) {
                String key = this.properties.getProperty(String.format(PROPERTIES_KEY, propertyName, i));
                String val = this.properties.getProperty(String.format(PROPERTIES_VALUE, propertyName, i));
                props.setProperty(key, val);
            }
            return props;
        }
        if (type == Set.class || type == LinkedList.class) {
            int size = Integer.parseInt(stringValue);
            AbstractCollection collection = type == Set.class ? new HashSet(size) : new LinkedList();
            for (int i = 0; i < size; ++i) {
                String subName = propertyName + "." + String.valueOf(i);
                String property = this.properties.getProperty(subName);
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                Object subEntity = this.retrieveFieldValue(subName, (Class)parameterizedType.getActualTypeArguments()[0], null, property);
                collection.add(subEntity);
            }
            return collection;
        }
        if (type.isArray()) {
            int size = Integer.parseInt(stringValue);
            Object array = Array.newInstance(type.getComponentType(), size);
            for (int i = 0; i < size; ++i) {
                String subName = propertyName + "." + String.valueOf(i);
                String property = this.properties.getProperty(subName);
                Object subEntity = this.retrieveFieldValue(subName, type.getComponentType(), null, property);
                Array.set(array, i, subEntity);
            }
            return array;
        }
        if (type == Charset.class) {
            return Charset.forName(stringValue);
        }
        if (Calendar.class.isAssignableFrom(type)) {
            long time = Long.parseLong(stringValue);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(time);
            return calendar;
        }
        if (type == Date.class) {
            long time = Long.parseLong(stringValue);
            return new Date(time);
        }
        return this.entityStorage.innerGetEntityById(Integer.parseInt(stringValue));
    }
}

