/*
 * Decompiled with CFR 0.152.
 */
package tarlog.shavtsak.core.model;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileNamesManager {
    private final File baseFolderFile;
    private final String baseFileName;
    private final Pattern namePattern = Pattern.compile(".*-(\\d+)$");
    private final TreeSet<FileWrapper> filesSet;
    private final LinkedList<FileWrapper> redo = new LinkedList();
    private boolean removeOldFiles = true;
    private int amountToKeep = 30;

    public FileNamesManager(File baseFolderFile, String baseFileName) {
        this.baseFolderFile = baseFolderFile;
        this.baseFileName = baseFileName;
        File[] list = baseFolderFile.listFiles(new BaseFileNameFilter());
        this.filesSet = new TreeSet<FileWrapper>(new FilesComparator());
        if (list != null) {
            for (File f : list) {
                Matcher m = this.namePattern.matcher(f.getName());
                if (!m.matches()) continue;
                this.filesSet.add(new FileWrapper(f, m));
            }
        }
        if (this.removeOldFiles && this.filesSet.size() > this.amountToKeep) {
            this.cleanOldFiles();
        }
    }

    private void cleanOldFiles() {
        while (this.filesSet.size() > this.amountToKeep) {
            FileWrapper first = this.filesSet.pollFirst();
            first.file.delete();
        }
    }

    public File getLatestFile() {
        if (this.filesSet.isEmpty()) {
            return null;
        }
        return this.filesSet.last().file;
    }

    public boolean isPreviousExists() {
        return this.filesSet.size() >= 2;
    }

    public File getPreviousFile() {
        if (!this.isPreviousExists()) {
            return null;
        }
        this.redo.addFirst(this.filesSet.pollLast());
        return this.filesSet.last().file;
    }

    public boolean isRedoExists() {
        return !this.redo.isEmpty();
    }

    public File getRedoFile() {
        if (!this.isRedoExists()) {
            return null;
        }
        FileWrapper wrapper = this.redo.pollFirst();
        this.filesSet.add(wrapper);
        return wrapper.file;
    }

    public File getNextSaveName() {
        this.cleanRedo();
        File file = null;
        if (this.filesSet.isEmpty()) {
            file = new File(this.baseFolderFile, this.baseFileName + "-1");
        } else {
            String group = this.filesSet.last().matcher.group(1);
            file = new File(this.baseFolderFile, String.format("%s-%d", this.baseFileName, Integer.parseInt(group) + 1));
        }
        this.filesSet.add(new FileWrapper(file));
        return file;
    }

    public void cleanRedo() {
        for (FileWrapper fileWrapper : this.redo) {
            fileWrapper.file.delete();
        }
        this.redo.clear();
    }

    private class BaseFileNameFilter
    implements FilenameFilter {
        private BaseFileNameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(FileNamesManager.this.baseFileName);
        }
    }

    private class FilesComparator
    implements Comparator<FileWrapper> {
        private FilesComparator() {
        }

        @Override
        public int compare(FileWrapper o1, FileWrapper o2) {
            Matcher m1 = o1.matcher;
            Matcher m2 = o2.matcher;
            String group1 = m1.group(1);
            String group2 = m2.group(1);
            return Integer.parseInt(group1) - Integer.parseInt(group2);
        }
    }

    private class FileWrapper {
        private File file;
        private Matcher matcher;

        public FileWrapper(File file, Matcher matcher) {
            this.file = file;
            this.matcher = matcher;
        }

        public FileWrapper(File f) {
            this(f, fileNamesManager.namePattern.matcher(f.getName()));
            if (!this.matcher.matches()) {
                throw new RuntimeException("Wrong file format: " + f.getName());
            }
        }
    }
}

