/*
 * Decompiled with CFR 0.152.
 */
package tarlog.ui.swt.ddialog.csv;

import java.io.File;
import java.nio.charset.Charset;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import tarlog.ui.swt.ddialog.csv.ImportData;
import tarlog.ui.swt.ddialog.utils.AbstractSelectionListener;
import tarlog.ui.swt.ddialog.utils.ResourceBundleWrapper;

public class CsvOpenFilePage
extends WizardPage {
    private final ImportData importData;
    private final ResourceBundleWrapper resourceBundle;
    private Text fileNameText;
    private Combo charsetCombo;
    private Button commaButton;
    private Button tabButton;

    protected CsvOpenFilePage(ImportData importData, ResourceBundleWrapper resourceBundle) {
        super("Open File", resourceBundle.getString("csv.open.file.title", "Open File"), null);
        this.importData = importData;
        this.resourceBundle = resourceBundle;
    }

    private void validate() {
        this.setPageComplete(false);
        if (this.fileNameText == null || this.charsetCombo == null) {
            return;
        }
        try {
            File file = new File(this.fileNameText.getText());
            String text = this.charsetCombo.getText();
            Charset charset = Charset.forName(text);
            if (file.isFile()) {
                this.setPageComplete(true);
                this.importData.setCsvFile(file);
                this.importData.setCharset(charset);
                if (this.tabButton.getSelection()) {
                    this.importData.setSeparator('\t');
                } else {
                    this.importData.setSeparator(',');
                }
            }
        }
        catch (Exception e) {
            this.setPageComplete(false);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(this.resourceBundle.getString("csv.open.file.fileName", "File name: "));
        this.fileNameText = new Text(composite, 2052);
        this.fileNameText.setLayoutData((Object)new GridData(768));
        if (this.importData.getCsvFile() != null) {
            this.fileNameText.setText(this.importData.getCsvFile().getPath());
        }
        ValidationListener validationListener = new ValidationListener();
        this.fileNameText.addModifyListener((ModifyListener)validationListener);
        Button button = new Button(composite, 8);
        button.setText("...");
        button.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(CsvOpenFilePage.this.getShell(), 0);
                fileDialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
                fileDialog.setFilterNames(new String[]{"Csv files", "All files"});
                fileDialog.setFileName(CsvOpenFilePage.this.fileNameText.getText());
                String open = fileDialog.open();
                if (open != null) {
                    CsvOpenFilePage.this.fileNameText.setText(open);
                }
            }
        });
        label = new Label(composite, 0);
        label.setText(this.resourceBundle.getString("csv.open.file.encoding", "Encoding: "));
        this.charsetCombo = new Combo(composite, 4);
        this.charsetCombo.setItems(new String[]{"UTF-8", "US-ASCII", "ISO-8859-1", "UTF-16"});
        if (this.importData.getCharset() != null) {
            this.charsetCombo.setText(this.importData.getCharset().displayName());
        } else {
            this.charsetCombo.setText("UTF-8");
        }
        this.charsetCombo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.charsetCombo.addModifyListener((ModifyListener)validationListener);
        label = new Label(composite, 0);
        label.setText(this.resourceBundle.getString("csv.open.file.separator", "Separator: "));
        Composite radioComposite = new Composite(composite, 0);
        radioComposite.setLayout((Layout)new RowLayout());
        radioComposite.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.commaButton = new Button(radioComposite, 16);
        this.commaButton.setText("Comma");
        this.commaButton.setSelection(this.importData.getSeparator() != '\t');
        RadioButtonsListener selectionListener = new RadioButtonsListener();
        this.commaButton.addSelectionListener((SelectionListener)selectionListener);
        this.tabButton = new Button(radioComposite, 16);
        this.tabButton.setText("Tab");
        this.tabButton.setSelection(this.importData.getSeparator() == '\t');
        this.tabButton.addSelectionListener((SelectionListener)selectionListener);
        this.setControl((Control)composite);
        this.validate();
    }

    private class ValidationListener
    implements ModifyListener {
        private ValidationListener() {
        }

        public void modifyText(ModifyEvent e) {
            CsvOpenFilePage.this.validate();
        }
    }

    private class RadioButtonsListener
    extends AbstractSelectionListener {
        private RadioButtonsListener() {
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            CsvOpenFilePage.this.commaButton.setSelection(false);
            CsvOpenFilePage.this.tabButton.setSelection(false);
            ((Button)e.widget).setSelection(true);
            if (CsvOpenFilePage.this.commaButton == e.widget) {
                CsvOpenFilePage.this.importData.setSeparator(',');
            } else {
                CsvOpenFilePage.this.importData.setSeparator('\t');
            }
        }
    }
}

