/*
 * Decompiled with CFR 0.152.
 */
package tarlog.ui.swt.ddialog.csv;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public final class CsvReader {
    private final Reader reader;
    private final char separator;
    private boolean endOfLine = false;
    private boolean endOfFile = false;

    public CsvReader(Reader reader) {
        this(reader, ',');
    }

    public CsvReader(Reader reader, char separator) {
        this.reader = reader;
        this.separator = separator;
    }

    public String[] readLine() {
        if (this.endOfFile) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (!this.endOfLine && !this.endOfFile) {
            list.add(this.readCell());
        }
        this.endOfLine = false;
        return list.toArray(new String[list.size()]);
    }

    private String readCell() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            boolean processThisCharacter = false;
            boolean hadQuote = false;
            int read = -1;
            block8: while (processThisCharacter || (read = this.reader.read()) != -1) {
                processThisCharacter = false;
                char character = (char)read;
                if (character == '\"') {
                    if (!hadQuote) {
                        hadQuote = true;
                        continue;
                    }
                    read = this.reader.read();
                    if (read == -1) {
                        this.endOfFile = true;
                        break;
                    }
                    character = (char)read;
                    switch (character) {
                        case '\"': {
                            stringBuilder.append(character);
                            continue block8;
                        }
                    }
                    hadQuote = false;
                    processThisCharacter = true;
                    continue;
                }
                if (character == '\r') {
                    if (hadQuote) {
                        stringBuilder.append(character);
                        continue;
                    }
                    read = this.reader.read();
                    if (read == -1) {
                        this.endOfFile = true;
                        break;
                    }
                    character = (char)read;
                    switch (character) {
                        case '\n': {
                            this.endOfLine = true;
                            break block8;
                        }
                        default: {
                            stringBuilder.append('\r');
                            processThisCharacter = true;
                            break;
                        }
                    }
                    continue;
                }
                if (character == '\n') {
                    if (hadQuote) {
                        stringBuilder.append(character);
                        continue;
                    }
                    this.endOfLine = true;
                    break;
                }
                if (character == this.separator) {
                    if (!hadQuote) break;
                    stringBuilder.append(character);
                    continue;
                }
                stringBuilder.append(character);
            }
            if (read == -1) {
                this.endOfFile = true;
            }
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

