/*
 * Decompiled with CFR 0.152.
 */
package tarlog.ui.swt.ddialog.csv;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import tarlog.ui.swt.ddialog.csv.CsvOpenFilePage;
import tarlog.ui.swt.ddialog.csv.CsvReader;
import tarlog.ui.swt.ddialog.csv.ImportData;
import tarlog.ui.swt.ddialog.csv.mapper.CsvMapperPage;
import tarlog.ui.swt.ddialog.csv.model.ClassFieldToColumn;
import tarlog.ui.swt.ddialog.utils.ResourceBundleWrapper;

public class ImportCsvWizard<T>
extends Wizard {
    private final ImportData importData;
    private final List<T> result = new ArrayList<T>();
    private final ResourceBundleWrapper resourceBundle;

    public ImportCsvWizard(Class<T> clsToMap, ResourceBundleWrapper resourceBundle, Field ... ignore) {
        this(new ImportData(new ClassFieldToColumn(clsToMap, ignore), ignore), resourceBundle);
    }

    public ImportCsvWizard(ImportData importData, ResourceBundleWrapper resourceBundle) {
        this.importData = importData;
        this.resourceBundle = resourceBundle;
    }

    public void addPages() {
        this.addPage((IWizardPage)new CsvOpenFilePage(this.importData, this.resourceBundle));
        this.addPage((IWizardPage)new CsvMapperPage(this.importData, this.resourceBundle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performFinish() {
        FileInputStream is = null;
        try {
            String[] line;
            is = new FileInputStream(this.importData.getCsvFile());
            CsvReader csvReader = new CsvReader(new InputStreamReader((InputStream)new BufferedInputStream(is), this.importData.getCharset()), this.importData.getSeparator());
            ClassFieldToColumn classFieldToColumn = this.importData.getFieldToColumn();
            Class<?> type = classFieldToColumn.getType();
            while ((line = csvReader.readLine()) != null) {
                Object obj = type.newInstance();
                classFieldToColumn.parse(obj, line);
                this.result.add(obj);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List<T> getResult() {
        return this.result;
    }

    public ImportData getImportData() {
        return this.importData;
    }
}

