/*
 * Decompiled with CFR 0.152.
 */
package tarlog.ui.swt.ddialog.csv.mapper;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import tarlog.ui.swt.ddialog.csv.ImportData;
import tarlog.ui.swt.ddialog.csv.mapper.CsvTreeContentProvider;
import tarlog.ui.swt.ddialog.csv.model.ClassFieldToColumn;
import tarlog.ui.swt.ddialog.csv.model.CollectionElement;
import tarlog.ui.swt.ddialog.csv.model.CollectionFieldToColumn;
import tarlog.ui.swt.ddialog.csv.model.ComplexCollectionElement;
import tarlog.ui.swt.ddialog.csv.model.FieldToColumn;
import tarlog.ui.swt.ddialog.csv.model.IFieldToColumn;
import tarlog.ui.swt.ddialog.csv.model.SimpleFieldToColumn;
import tarlog.ui.swt.ddialog.impl.DynamicInputDialog;
import tarlog.ui.swt.ddialog.utils.AbstractSelectionListener;
import tarlog.ui.swt.ddialog.utils.ResourceBundleWrapper;

public class CsvMapperPage
extends WizardPage {
    private static final String UNASSIGNED = "unassigned";
    private final ClassFieldToColumn fieldToColumn;
    private final ResourceBundleWrapper resourceBundle;

    public CsvMapperPage(ImportData importData, ResourceBundleWrapper resourceBundle) {
        super("Csv Mapper", resourceBundle.getString("csv.mapper.page.title", "Csv Mapper"), null);
        this.fieldToColumn = importData.getFieldToColumn();
        this.resourceBundle = resourceBundle;
        this.setPageComplete(this.validateData());
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Shell shell = this.getShell();
        shell.setLayout((Layout)new GridLayout());
        shell.setLayoutData((Object)new GridData(1808));
        TreeViewer treeViewer = new TreeViewer(composite, 68352);
        Tree tree = treeViewer.getTree();
        tree.setMenu(this.createMenu(treeViewer));
        tree.setLayout((Layout)new GridLayout());
        tree.setLayoutData((Object)new GridData(1808));
        treeViewer.setContentProvider((IContentProvider)new CsvTreeContentProvider());
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.createFieldNameColumn(treeViewer);
        this.createOrderColumn(treeViewer);
        treeViewer.setInput((Object)this.fieldToColumn);
        this.setControl((Control)composite);
    }

    private TreeViewerColumn createOrderColumn(final TreeViewer treeViewer) {
        TreeViewerColumn columnOrderViewerColumn = new TreeViewerColumn(treeViewer, 16384);
        TreeColumn columnOrderColumn = columnOrderViewerColumn.getColumn();
        columnOrderColumn.setText(this.resourceBundle.getString("csv.mapper.page.columnOrder", "Column Order"));
        columnOrderColumn.setWidth(200);
        columnOrderViewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof SimpleFieldToColumn) {
                    SimpleFieldToColumn fieldToColumn = (SimpleFieldToColumn)element;
                    Integer column = fieldToColumn.getColumn();
                    if (column != null && column > 0) {
                        cell.setText(String.valueOf(column));
                    } else {
                        cell.setText(CsvMapperPage.this.resourceBundle.getString("csv.mapper.page.unassigned", CsvMapperPage.UNASSIGNED));
                    }
                }
            }
        });
        columnOrderViewerColumn.setEditingSupport(new EditingSupport(columnOrderViewerColumn.getViewer()){

            protected boolean canEdit(Object element) {
                return SimpleFieldToColumn.class.isAssignableFrom(element.getClass());
            }

            protected CellEditor getCellEditor(Object element) {
                return CsvMapperPage.this.createCellEditor((Composite)treeViewer.getTree());
            }

            protected Object getValue(Object element) {
                if (element instanceof SimpleFieldToColumn) {
                    SimpleFieldToColumn fieldToColumn = (SimpleFieldToColumn)element;
                    Integer column = fieldToColumn.getColumn();
                    if (column == null || column < 1) {
                        return CsvMapperPage.this.resourceBundle.getString("csv.mapper.page.unassigned", CsvMapperPage.UNASSIGNED);
                    }
                    return column;
                }
                return null;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof SimpleFieldToColumn) {
                    SimpleFieldToColumn simpleFieldToColumn = (SimpleFieldToColumn)element;
                    if (value.getClass() == String.class) {
                        simpleFieldToColumn.setColumn(null);
                    } else {
                        simpleFieldToColumn.setColumn((Integer)value);
                    }
                    CsvMapperPage.this.setPageComplete(CsvMapperPage.this.validateData());
                    treeViewer.refresh();
                }
            }
        });
        return columnOrderViewerColumn;
    }

    private boolean validateData() {
        HashSet<Integer> set = new HashSet<Integer>();
        boolean validation = this.validateData(this.fieldToColumn, set);
        if (validation) {
            if (set.isEmpty()) {
                this.setErrorMessage(this.resourceBundle.getString("csv.mapper.page.error.msg.noMappedColumns", "At least one field must be mapped to a column."));
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }
        return false;
    }

    private boolean validateData(IFieldToColumn toValidate, Set<Integer> uniqueSet) {
        Class<?> cls = toValidate.getClass();
        if (SimpleFieldToColumn.class.isAssignableFrom(cls)) {
            Integer column = toValidate.getColumn();
            if (column == null || column <= 0) {
                return true;
            }
            if (uniqueSet.add(column)) {
                return true;
            }
            this.setErrorMessage(this.resourceBundle.getString("csv.mapper.page.error.msg.notUnique", "Column {0} us not unique.", (int)column));
            return false;
        }
        if (cls == ClassFieldToColumn.class) {
            ClassFieldToColumn classFieldToColumn = (ClassFieldToColumn)toValidate;
            for (FieldToColumn fieldToColumn : classFieldToColumn.getFieldToColumns()) {
                if (this.validateData(fieldToColumn, uniqueSet)) continue;
                return false;
            }
            return true;
        }
        if (cls == ComplexCollectionElement.class) {
            ComplexCollectionElement collectionElement = (ComplexCollectionElement)toValidate;
            for (FieldToColumn fieldToColumn : collectionElement.getFieldToColumns()) {
                if (this.validateData(fieldToColumn, uniqueSet)) continue;
                return false;
            }
            return true;
        }
        if (cls == CollectionFieldToColumn.class) {
            CollectionFieldToColumn collectionFieldToColumn = (CollectionFieldToColumn)toValidate;
            for (CollectionElement fieldToColumn : collectionFieldToColumn.getFieldToColumns()) {
                if (this.validateData(fieldToColumn, uniqueSet)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void createFieldNameColumn(TreeViewer treeViewer) {
        TreeViewerColumn fieldNameViewerColumn = new TreeViewerColumn(treeViewer, 16384);
        TreeColumn fieldNameColumn = fieldNameViewerColumn.getColumn();
        fieldNameColumn.setText(this.resourceBundle.getString("csv.mapper.page.fieldName", "Field Name"));
        fieldNameColumn.setWidth(200);
        fieldNameViewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof FieldToColumn) {
                    FieldToColumn fieldToColumn = (FieldToColumn)element;
                    cell.setText(fieldToColumn.getName());
                }
            }
        });
    }

    private CellEditor createCellEditor(Composite parent) {
        return new DialogCellEditor(parent){

            protected Object openDialogBox(Control cellEditorWindow) {
                SimpleFieldToColumn simpleFieldToColumn = new SimpleFieldToColumn(null);
                Object value = this.getValue();
                if (value.getClass() == Integer.class) {
                    simpleFieldToColumn.setColumn((Integer)value);
                } else {
                    simpleFieldToColumn.setColumn(0);
                }
                DynamicInputDialog dialog = new DynamicInputDialog(CsvMapperPage.this.getShell(), CsvMapperPage.this.resourceBundle.getString("csv.mapper.page.selectColumn", "Select column number"), simpleFieldToColumn);
                int retValue = dialog.open();
                if (retValue == 0) {
                    return simpleFieldToColumn.getColumn();
                }
                return null;
            }
        };
    }

    private Menu createMenu(final TreeViewer treeViewer) {
        final Tree tree = treeViewer.getTree();
        final Menu menu = new Menu((Control)tree);
        menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                MenuItem[] menuItems = menu.getItems();
                for (int i = 0; i < menuItems.length; ++i) {
                    menuItems[i].dispose();
                }
                TreeItem[] selection = tree.getSelection();
                if (selection.length > 0) {
                    final Object data = selection[0].getData();
                    if (data instanceof CollectionFieldToColumn) {
                        final CollectionFieldToColumn collectionFieldToColumn = (CollectionFieldToColumn)data;
                        MenuItem menuItem = new MenuItem(menu, 0);
                        menuItem.setText(CsvMapperPage.this.resourceBundle.getString("csv.mapper.page.add", "Add"));
                        menuItem.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

                            @Override
                            public void widgetSelected(SelectionEvent e) {
                                collectionFieldToColumn.add();
                                treeViewer.refresh();
                            }
                        });
                    } else if (data instanceof CollectionElement) {
                        TreeItem parentItem = selection[0].getParentItem();
                        final CollectionFieldToColumn collectionFieldToColumn = (CollectionFieldToColumn)parentItem.getData();
                        MenuItem menuItem = new MenuItem(menu, 0);
                        menuItem.setText(CsvMapperPage.this.resourceBundle.getString("csv.mapper.page.remove", "Remove"));
                        menuItem.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

                            @Override
                            public void widgetSelected(SelectionEvent e) {
                                CollectionElement collectionElement = (CollectionElement)data;
                                collectionFieldToColumn.remove(collectionElement);
                                treeViewer.refresh();
                            }
                        });
                    }
                }
            }
        });
        return menu;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }
}

