/*
 * Decompiled with CFR 0.152.
 */
package tarlog.ui.swt.ddialog.csv.model;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import tarlog.ui.swt.ddialog.csv.model.ClassFieldToColumn;
import tarlog.ui.swt.ddialog.csv.model.CollectionFieldToColumn;
import tarlog.ui.swt.ddialog.csv.model.FieldToColumn;
import tarlog.ui.swt.ddialog.csv.model.SimpleFieldToColumn;

public abstract class ArrayFieldToColumn
extends FieldToColumn {
    private static final FieldToColumn[] EMPTY_ARRAY = new FieldToColumn[0];
    private FieldToColumn[] fieldToColumns;

    public ArrayFieldToColumn(Field field, FieldToColumn[] fieldToColumns) {
        super(field);
        this.fieldToColumns = fieldToColumns;
    }

    @Override
    public void parse(Object obj, String[] str) {
        for (FieldToColumn fieldToColumn : this.fieldToColumns) {
            fieldToColumn.parse(obj, str);
        }
    }

    public FieldToColumn[] getFieldToColumns() {
        return this.fieldToColumns;
    }

    public static FieldToColumn[] createFieldToColumn(Class<?> cls, Field ... ignore) {
        ArrayList<FieldToColumn> list = new ArrayList<FieldToColumn>();
        while (cls != Object.class) {
            Field[] declaredFields;
            block1: for (Field field : declaredFields = cls.getDeclaredFields()) {
                FieldToColumn created;
                if (ignore != null && ignore.length > 0) {
                    for (Field ign : ignore) {
                        if (field.equals(ign)) continue block1;
                    }
                }
                if ((created = ArrayFieldToColumn.createFieldToColumn(field, ignore)) == null) continue;
                list.add(created);
            }
            cls = cls.getSuperclass();
        }
        return list.toArray(EMPTY_ARRAY);
    }

    private static FieldToColumn createFieldToColumn(Field field, Field ... ignore) {
        Class<?> type = field.getType();
        if (type == Date.class || type == Calendar.class) {
            return null;
        }
        if (type == String.class || type == Boolean.class || type.isPrimitive() || Number.class.isAssignableFrom(type)) {
            return new SimpleFieldToColumn(field);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return new CollectionFieldToColumn(field, ignore);
        }
        return new ClassFieldToColumn(field, ignore);
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.fieldToColumns);
    }
}

