/*
 * Decompiled with CFR 0.152.
 */
package tarlog.ui.swt.ddialog.csv.model;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import tarlog.ui.swt.ddialog.csv.model.CollectionElement;
import tarlog.ui.swt.ddialog.csv.model.ComplexCollectionElement;
import tarlog.ui.swt.ddialog.csv.model.FieldToColumn;
import tarlog.ui.swt.ddialog.csv.model.SimpleCollectionElement;

public final class CollectionFieldToColumn
extends FieldToColumn {
    private final LinkedList<CollectionElement> fieldToColumns = new LinkedList();
    private Field[] ignore;

    public CollectionFieldToColumn() {
        super(null);
    }

    public CollectionFieldToColumn(Field field, Field ... ignore) {
        super(field);
        this.ignore = ignore;
    }

    public LinkedList<CollectionElement> getFieldToColumns() {
        return this.fieldToColumns;
    }

    public void add() {
        ParameterizedType ptype;
        Type[] actualTypeArguments;
        Field field = this.getField();
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType && (actualTypeArguments = (ptype = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && Class.class == actualTypeArguments[0].getClass()) {
            this.fieldToColumns.add(this.createCollectionElement((Class)actualTypeArguments[0]));
            return;
        }
    }

    private CollectionElement createCollectionElement(Class<?> cls) {
        if (cls == String.class || cls == Boolean.class || cls.isPrimitive() || Number.class.isAssignableFrom(cls)) {
            return new SimpleCollectionElement(cls, this);
        }
        return new ComplexCollectionElement(cls, this, this.ignore);
    }

    public void remove(CollectionElement collectionElement) {
        this.fieldToColumns.remove(collectionElement);
    }

    @Override
    public boolean hasChildren() {
        return this.fieldToColumns.size() > 0;
    }

    @Override
    public String getName() {
        return super.getName() + " []";
    }

    @Override
    public void parse(Object obj, String[] str) {
        block7: {
            try {
                if (!this.hasChildren()) break block7;
                Field field = this.getField();
                field.setAccessible(true);
                Class<?> type = field.getType();
                ArrayList<Object> collection = null;
                if (List.class == type) {
                    collection = new ArrayList(this.fieldToColumns.size());
                } else if (Set.class == type) {
                    collection = new HashSet(this.fieldToColumns.size());
                }
                if (collection != null) {
                    for (CollectionElement collectionElement : this.fieldToColumns) {
                        collectionElement.parse(collection, str);
                    }
                    field.set(obj, collection);
                    break block7;
                }
                throw new RuntimeException("Could not find suitable collection for type " + String.valueOf(type));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public String toString() {
        return this.fieldToColumns.toString();
    }
}

