/*
 * Decompiled with CFR 0.152.
 */
package tarlog.ui.swt.ddialog.csv.model;

import java.util.Arrays;
import java.util.Collection;
import tarlog.ui.swt.ddialog.csv.model.CollectionElement;
import tarlog.ui.swt.ddialog.csv.model.CollectionFieldToColumn;
import tarlog.ui.swt.ddialog.csv.model.SimpleFieldToColumn;

public class SimpleCollectionElement
extends SimpleFieldToColumn
implements CollectionElement {
    private Class<?> type;
    private CollectionFieldToColumn parent;

    public SimpleCollectionElement() {
        super(null);
    }

    public SimpleCollectionElement(Class<?> cls, CollectionFieldToColumn parent) {
        super(null);
        this.type = cls;
        this.parent = parent;
    }

    @Override
    public String getName() {
        return String.format("[%d]", this.parent.getFieldToColumns().indexOf(this));
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public void parse(Object obj, String[] str) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void parse(Collection<Object> collection, String[] str) {
        Integer column = this.getColumn();
        if (column != null && column > 0) {
            if (column > str.length) {
                System.out.println(String.format("The column %d cannot be mapped, since line %s has %d columns", (int)column, Arrays.toString(str), str.length));
            } else {
                Object value = str[column - 1];
                if (this.type == Integer.class) {
                    value = Integer.parseInt(str[column - 1]);
                } else if (this.type == Boolean.class) {
                    value = Boolean.parseBoolean(str[column - 1]);
                } else if (this.type != String.class) {
                    System.out.println("Unsupported type " + String.valueOf(this.type));
                    return;
                }
                collection.add(value);
            }
        }
    }
}

