/*
 * Decompiled with CFR 0.152.
 */
package tarlog.ui.swt.ddialog.csv.model;

import java.lang.reflect.Field;
import java.util.Arrays;
import tarlog.ui.swt.ddialog.api.fields.InputField;
import tarlog.ui.swt.ddialog.csv.model.FieldToColumn;

public class SimpleFieldToColumn
extends FieldToColumn {
    @InputField(name="csv.mapper.page.columnOrder", required=true)
    private Integer column = null;

    public SimpleFieldToColumn() {
        super(null);
    }

    public SimpleFieldToColumn(Field field) {
        super(field);
    }

    @Override
    public Integer getColumn() {
        return this.column;
    }

    public void setColumn(Integer column) {
        this.column = column;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public void parse(Object obj, String[] str) {
        if (this.column != null && this.column > 0) {
            if (this.column > str.length) {
                System.out.println(String.format("The column %d cannot be mapped, since line %s has %d columns", (int)this.column, Arrays.toString(str), str.length));
            } else {
                Field field = this.getField();
                field.setAccessible(true);
                Class<?> type = field.getType();
                Object value = str[this.column - 1];
                if (type == Integer.class) {
                    value = Integer.parseInt(str[this.column - 1]);
                } else if (type == Boolean.class) {
                    value = Boolean.parseBoolean(str[this.column - 1]);
                } else if (type != String.class) {
                    System.out.println("Unsupported type " + String.valueOf(type));
                    return;
                }
                try {
                    field.set(obj, value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

