/*
 * Decompiled with CFR 0.152.
 */
package tarlog.ui.swt.ddialog.impl;

import java.io.File;
import java.lang.reflect.Field;
import org.eclipse.osgi.framework.adaptor.FilePath;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import tarlog.ui.swt.ddialog.api.fields.InputDirectoryField;
import tarlog.ui.swt.ddialog.api.fields.InputFileField;
import tarlog.ui.swt.ddialog.impl.CreateField;
import tarlog.ui.swt.ddialog.impl.DynamicInputDialog;
import tarlog.ui.swt.ddialog.utils.AbstractSelectionListener;

public class CreateFileDialog
extends CreateField {
    private static final String absolutePath = new File(".").getAbsolutePath();

    public CreateFileDialog(DynamicInputDialog inputDialog) {
        super(inputDialog);
    }

    Control createDialog(Font font, Composite parent, final DynamicInputDialog.FieldWrapper fieldWrapper, String fieldName) {
        this.createLabel(font, parent, fieldName);
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        final Text text = new Text(composite, 0x800 | (fieldWrapper.inputField.readonly() ? 8 : 0));
        layoutData = new GridData(4, 0x1000000, true, false);
        text.setLayoutData((Object)layoutData);
        Object value = fieldWrapper.initialValue;
        if (value != null) {
            String fileName = ((File)value).getAbsolutePath();
            text.setText(fileName);
        }
        final InputFileField fileFieldAnnotation = fieldWrapper.field.getAnnotation(InputFileField.class);
        final InputDirectoryField directoryField = fieldWrapper.field.getAnnotation(InputDirectoryField.class);
        if (fileFieldAnnotation != null && directoryField != null) {
            throw new RuntimeException(String.format("Only one of %s or %s is permitted.", InputFileField.class.getName(), InputDirectoryField.class.getName()));
        }
        Button button = new Button(composite, 8);
        button.setEnabled(!fieldWrapper.inputField.readonly());
        button.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        if (fileFieldAnnotation != null) {
            button.setText(fileFieldAnnotation.buttonText());
        } else if (directoryField != null) {
            button.setText(directoryField.buttonText());
        } else {
            button.setText("...");
        }
        button.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String filterPath = null;
                String file = null;
                if (fileFieldAnnotation != null) {
                    String[] filterExtensions = fileFieldAnnotation.filterExtensions().length > 0 ? fileFieldAnnotation.filterExtensions() : null;
                    String[] filterNames = fileFieldAnnotation.filterNames().length > 0 ? fileFieldAnnotation.filterNames() : null;
                    filterPath = fileFieldAnnotation.filterPath().equals("") ? null : fileFieldAnnotation.filterPath();
                    FileDialog fileDialog = new FileDialog(CreateFileDialog.this.shell, 4096);
                    fileDialog.setFileName(text.getText());
                    fileDialog.setFilterExtensions(filterExtensions);
                    fileDialog.setFilterNames(filterNames);
                    fileDialog.setFilterPath(filterPath);
                    file = fileDialog.open();
                    if (file != null) {
                        String fileName = fileDialog.getFileName();
                        String path = fileFieldAnnotation.relative() ? new FilePath(absolutePath).makeRelative(new FilePath(fileDialog.getFilterPath())) : fileDialog.getFilterPath();
                        String sep = File.separator;
                        if (path.contains("/")) {
                            if (File.separatorChar == '\\') {
                                sep = "\\\\";
                            }
                            path = path.replaceAll("/", sep);
                        }
                        file = path + File.separator + fileName;
                    }
                } else if (directoryField != null) {
                    filterPath = directoryField.filterPath().equals("") ? null : directoryField.filterPath();
                    DirectoryDialog directoryDialog = new DirectoryDialog(CreateFileDialog.this.shell);
                    directoryDialog.setText(text.getText());
                    directoryDialog.setFilterPath(filterPath);
                    file = directoryDialog.open();
                } else {
                    FileDialog fileDialog = new FileDialog(CreateFileDialog.this.shell);
                    fileDialog.setFileName(text.getText());
                    file = fileDialog.open();
                }
                if (file != null) {
                    text.setText(file);
                }
            }
        });
        if (this.inputDialog.toValidateInput()) {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CreateFileDialog.this.inputDialog.setFields();
                    CreateFileDialog.this.inputDialog.validateInput();
                }
            });
        }
        this.fieldControls.add(new DynamicInputDialog.FieldControl(){

            @Override
            public Field getField() {
                return fieldWrapper.field;
            }

            @Override
            public Object getValue() {
                if (!text.getText().equals("")) {
                    return new File(text.getText());
                }
                return null;
            }
        });
        return composite;
    }
}

