/*
 * Decompiled with CFR 0.152.
 */
package tarlog.ui.swt.ddialog.impl;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.osgi.framework.adaptor.FilePath;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.dialogs.ListDialog;
import tarlog.ui.swt.ddialog.api.fields.InputDirectoryField;
import tarlog.ui.swt.ddialog.api.fields.InputFileField;
import tarlog.ui.swt.ddialog.api.fields.InputListField;
import tarlog.ui.swt.ddialog.api.fields.ListConverter;
import tarlog.ui.swt.ddialog.impl.CreateField;
import tarlog.ui.swt.ddialog.impl.DynamicInputDialog;
import tarlog.ui.swt.ddialog.utils.AbstractLabelProvider;
import tarlog.ui.swt.ddialog.utils.AbstractSelectionListener;
import tarlog.ui.swt.ddialog.utils.DDialogResources;
import tarlog.ui.swt.ddialog.utils.Utils;

public class CreateList
extends CreateField {
    private static final ListConverter<String> stringConverter = new StringConverter();
    private static final ListConverter<URL> urlConverter = new URLConverter();
    private static final String absolutePath = new File(".").getAbsolutePath();
    private ListConverter converter = null;
    private List list;
    private String fieldName;

    public CreateList(DynamicInputDialog inputDialog) {
        super(inputDialog);
    }

    public Composite createField(Font font, Composite parent, final DynamicInputDialog.FieldWrapper fieldWrapper, String fieldName) {
        Class<? extends ListConverter> converterClass;
        this.fieldName = fieldName;
        this.createLabel(font, parent, fieldName);
        InputListField inputListFieldAnnotation = fieldWrapper.field.getAnnotation(InputListField.class);
        if (inputListFieldAnnotation != null && (converterClass = inputListFieldAnnotation.converter()) != ListConverter.class) {
            try {
                this.converter = converterClass.newInstance();
            }
            catch (InstantiationException e) {
                Utils.showException(this.shell, e);
            }
            catch (IllegalAccessException e) {
                Utils.showException(this.shell, e);
            }
        }
        if (this.converter == null) {
            Class<?> fieldType = fieldWrapper.field.getType();
            Class<?> type = null;
            if (fieldType.isArray()) {
                type = fieldType.getComponentType();
            }
            if (type == String.class) {
                this.converter = stringConverter;
            } else if (type == URL.class) {
                this.converter = urlConverter;
            } else {
                throw new RuntimeException("Converter must be defined for this array type: " + type.getName());
            }
        }
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, false, true);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.list = new List(composite, (fieldWrapper.inputField.readonly() ? 8 : 0) | 4 | 0x800 | 0x100 | 0x200);
        layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = this.inputDialog.convertVerticalDLUsToPixels(50);
        layoutData.widthHint = this.inputDialog.convertHorizontalDLUsToPixels(90);
        this.list.setLayoutData((Object)layoutData);
        Object[] value = fieldWrapper.initialValue instanceof Collection ? ((Collection)fieldWrapper.initialValue).toArray() : (Object[])fieldWrapper.initialValue;
        if (value != null) {
            this.list.setItems(this.converter.toList(value));
        }
        if (this.inputDialog.toValidateInput()) {
            this.list.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    CreateList.this.inputDialog.setFields();
                    CreateList.this.inputDialog.validateInput();
                }

                public void widgetSelected(SelectionEvent e) {
                }
            });
        }
        this.addButtons(composite, fieldWrapper);
        this.fieldControls.add(new DynamicInputDialog.FieldControl(){

            @Override
            public Field getField() {
                return fieldWrapper.field;
            }

            @Override
            public Object getValue() {
                return CreateList.this.converter.fromList(CreateList.this.list.getItems(), fieldWrapper.initialValue);
            }
        });
        return composite;
    }

    private void addButtons(Composite parent, DynamicInputDialog.FieldWrapper fieldWrapper) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 128, false, true);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        InputListField inputListField = fieldWrapper.field.getAnnotation(InputListField.class);
        InputDirectoryField inputDirectoryField = fieldWrapper.field.getAnnotation(InputDirectoryField.class);
        InputFileField inputFileField = fieldWrapper.field.getAnnotation(InputFileField.class);
        if (inputDirectoryField == null && inputListField == null && inputFileField == null) {
            this.createStringInputButton(composite);
            this.createRemoveButton(composite);
        } else {
            if (inputDirectoryField != null) {
                this.createFolderInputButton(composite, inputDirectoryField);
            }
            if (inputFileField != null) {
                this.createFileInputButton(composite, inputFileField);
            }
            if (inputListField != null) {
                if (inputListField.values().length > 0 || !inputListField.valuesMethod().isEmpty()) {
                    this.createListInputButton(composite, inputListField);
                }
                for (InputListField.InputType inputType : inputListField.inputType()) {
                    if (inputType == InputListField.InputType.UP) {
                        this.createUpButton(composite);
                        continue;
                    }
                    if (inputType == InputListField.InputType.DOWN) {
                        this.createDownButton(composite);
                        continue;
                    }
                    if (inputListField.values().length == 0 && inputListField.valuesMethod().isEmpty() && inputType == InputListField.InputType.STRING) {
                        this.createStringInputButton(composite);
                        continue;
                    }
                    if (inputType != InputListField.InputType.REMOVE) continue;
                    this.createRemoveButton(composite);
                }
            }
        }
    }

    private void createListInputButton(Composite composite, final InputListField inputListField) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        button.setText(DDialogResources.ADD);
        button.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                ListDialog listDialog = new ListDialog(CreateList.this.shell){

                    protected boolean isResizable() {
                        return false;
                    }
                };
                listDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                listDialog.setLabelProvider((ILabelProvider)new AbstractLabelProvider());
                listDialog.setMessage(DDialogResources.getCreateList_SelectFromList_Message(CreateList.this.fieldName));
                listDialog.setTitle(DDialogResources.getCreateList_SelectFromList_Title(CreateList.this.fieldName));
                listDialog.setInput(this.getInput());
                if (listDialog.open() == 0 && (result = listDialog.getResult()) != null && result.length > 0) {
                    CreateList.this.list.add((String)result[0]);
                }
            }

            private Object getInput() {
                ArrayList<String> asList = new ArrayList<String>();
                Object[] items = CreateList.this.list.getItems();
                Arrays.sort(items);
                for (String str : inputListField.values()) {
                    if (Arrays.binarySearch(items, str) >= 0) continue;
                    asList.add(str);
                }
                try {
                    String[] values;
                    Method method;
                    String valuesMethod = inputListField.valuesMethod();
                    if (!valuesMethod.isEmpty() && (method = CreateList.this.inputDialog.object.getClass().getMethod(valuesMethod, new Class[0])).getReturnType() == String[].class && (values = (String[])method.invoke(CreateList.this.inputDialog.object, new Object[0])) != null) {
                        for (String val : values) {
                            if (Arrays.binarySearch(items, val) >= 0) continue;
                            asList.add(val);
                        }
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                return asList;
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateList.this.inputDialog.setFields();
                CreateList.this.inputDialog.validateInput();
            }
        });
    }

    private void createUpButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        button.setText(DDialogResources.UP);
        button.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = CreateList.this.list.getSelectionIndex();
                if (selectionIndex > 0) {
                    String item = CreateList.this.list.getItem(selectionIndex);
                    CreateList.this.list.setItem(selectionIndex, CreateList.this.list.getItem(selectionIndex - 1));
                    CreateList.this.list.setItem(selectionIndex - 1, item);
                    CreateList.this.list.setSelection(selectionIndex - 1);
                }
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateList.this.inputDialog.setFields();
                CreateList.this.inputDialog.validateInput();
            }
        });
    }

    private void createDownButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        button.setText(DDialogResources.DOWN);
        button.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = CreateList.this.list.getSelectionIndex();
                if (selectionIndex != -1 && selectionIndex < CreateList.this.list.getItemCount() - 1) {
                    String item = CreateList.this.list.getItem(selectionIndex);
                    CreateList.this.list.setItem(selectionIndex, CreateList.this.list.getItem(selectionIndex + 1));
                    CreateList.this.list.setItem(selectionIndex + 1, item);
                    CreateList.this.list.setSelection(selectionIndex + 1);
                }
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateList.this.inputDialog.setFields();
                CreateList.this.inputDialog.validateInput();
            }
        });
    }

    private void createRemoveButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        button.setText(DDialogResources.REMOVE);
        button.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                int selectionIndex;
                while ((selectionIndex = CreateList.this.list.getSelectionIndex()) != -1) {
                    CreateList.this.list.remove(selectionIndex);
                }
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateList.this.inputDialog.setFields();
                CreateList.this.inputDialog.validateInput();
            }
        });
    }

    private void createFileInputButton(Composite composite, final InputFileField inputFileField) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        button.setText(inputFileField.buttonText());
        button.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String file = null;
                FileDialog fileDialog = new FileDialog(CreateList.this.shell, 4098);
                String[] filterExtensions = inputFileField.filterExtensions().length > 0 ? inputFileField.filterExtensions() : null;
                String[] filterNames = inputFileField.filterNames().length > 0 ? inputFileField.filterNames() : null;
                String filterPath = inputFileField.filterPath().equals("") ? null : inputFileField.filterPath();
                fileDialog.setFilterExtensions(filterExtensions);
                fileDialog.setFilterNames(filterNames);
                fileDialog.setFilterPath(filterPath == null ? absolutePath : filterPath);
                file = fileDialog.open();
                if (file != null) {
                    String[] fileNames = fileDialog.getFileNames();
                    String path = inputFileField.relative() ? new FilePath(absolutePath).makeRelative(new FilePath(fileDialog.getFilterPath())) : fileDialog.getFilterPath();
                    String sep = File.separator;
                    if (path.contains("/")) {
                        if (File.separatorChar == '\\') {
                            sep = "\\\\";
                        }
                        path = path.replaceAll("/", sep);
                    }
                    for (String fileName : fileNames) {
                        fileName = path + File.separator + fileName;
                        CreateList.this.list.add(fileName);
                    }
                }
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateList.this.inputDialog.setFields();
                CreateList.this.inputDialog.validateInput();
            }
        });
    }

    private void createFolderInputButton(Composite composite, final InputDirectoryField inputDirectoryField) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        button.setText(inputDirectoryField.buttonText());
        button.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String file = null;
                DirectoryDialog directoryDialog = new DirectoryDialog(CreateList.this.shell);
                String filterPath = inputDirectoryField.filterPath().equals("") ? null : inputDirectoryField.filterPath();
                directoryDialog.setFilterPath(filterPath == null ? absolutePath : filterPath);
                file = directoryDialog.open();
                if (file != null) {
                    CreateList.this.list.add(file);
                }
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateList.this.inputDialog.setFields();
                CreateList.this.inputDialog.validateInput();
            }
        });
    }

    private void createStringInputButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        button.setText("Add");
        button.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                InputDialog inputDialog = new InputDialog(CreateList.this.shell, "Add string", "Enter string", "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.trim().equals("")) {
                            return "String cannot be empty";
                        }
                        return null;
                    }
                });
                int rc = inputDialog.open();
                if (rc == 0) {
                    CreateList.this.list.add(inputDialog.getValue());
                }
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateList.this.inputDialog.setFields();
                CreateList.this.inputDialog.validateInput();
            }
        });
    }

    private static class URLConverter
    implements ListConverter<URL> {
        private URLConverter() {
        }

        public URL[] fromList(String[] list, Object initialValue) {
            if (list == null) {
                return null;
            }
            URL[] array = new URL[list.length];
            for (int i = 0; i < list.length; ++i) {
                try {
                    File file = new File(list[i]);
                    if (file.isFile() || file.isDirectory()) {
                        array[i] = file.toURI().toURL();
                        continue;
                    }
                    array[i] = new URL(list[i]);
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            return array;
        }

        public String[] toList(URL[] list) {
            if (list == null) {
                return null;
            }
            String[] array = new String[list.length];
            for (int i = 0; i < list.length; ++i) {
                array[i] = list[i].toString();
            }
            return array;
        }
    }

    public static class StringConverter
    implements ListConverter<String> {
        public String[] fromList(String[] list, Object initialValue) {
            return list;
        }

        public String[] toList(String[] list) {
            return list;
        }
    }
}

