/*
 * Decompiled with CFR 0.152.
 */
package tarlog.ui.swt.ddialog.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import tarlog.ui.swt.ddialog.impl.CreateField;
import tarlog.ui.swt.ddialog.impl.DynamicInputDialog;
import tarlog.ui.swt.ddialog.utils.AbstractTableLabelProvider;

public class CreatePropertiesDialog
extends CreateField {
    private static final String VALUE = "Value";
    private static final String NAME = "Name";
    private static final String[] columnNames = new String[]{"Name", "Value"};
    private boolean enabled = true;

    public CreatePropertiesDialog(DynamicInputDialog inputDialog) {
        super(inputDialog);
    }

    public Control createDialog(Composite parent, final DynamicInputDialog.FieldWrapper fieldWrapper, String fieldName) {
        this.enabled = !fieldWrapper.inputField.readonly() && fieldWrapper.inputField.enabled();
        Group group = new Group(parent, 0);
        group.setText(fieldName);
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        group.setLayout((Layout)new GridLayout(2, false));
        Table table = this.createTable(group);
        table.setEnabled(this.enabled);
        final ArrayList<Pair> tableInput = new ArrayList<Pair>();
        Object value = fieldWrapper.initialValue;
        if (value instanceof Properties) {
            Properties props = (Properties)value;
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                tableInput.add(new Pair(entry));
            }
        }
        table.setData(tableInput);
        TableViewer tableViewer = this.createTableViewer(table);
        this.createButtonsArea(group, tableViewer);
        this.fieldControls.add(new DynamicInputDialog.FieldControl(){

            @Override
            public Field getField() {
                return fieldWrapper.field;
            }

            @Override
            public Object getValue() {
                Properties properties = new Properties();
                for (Pair pair : tableInput) {
                    properties.setProperty(pair.key, pair.value);
                }
                return properties;
            }
        });
        return table;
    }

    private Table createTable(Group group) {
        Table table = new Table((Composite)group, 67586);
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(columnNames[0]);
        tableColumn.setWidth(100);
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(columnNames[1]);
        tableColumn.setWidth(150);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = this.inputDialog.convertVerticalDLUsToPixels(60);
        table.setLayoutData((Object)layoutData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        return table;
    }

    private void createButtonsArea(Group group, final TableViewer tableViewer) {
        Composite buttonsComposite = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)gridLayout);
        buttonsComposite.setLayoutData((Object)new GridData(16384, 128, false, false));
        Button addButton = new Button(buttonsComposite, 8);
        addButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        addButton.setText("Add");
        addButton.setEnabled(this.enabled);
        final Table table = tableViewer.getTable();
        final List tableInput = (List)table.getData();
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                tableInput.add(new Pair());
                tableViewer.refresh();
                table.setSelection(tableInput.size() - 1);
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreatePropertiesDialog.this.inputDialog.setFields();
                CreatePropertiesDialog.this.inputDialog.validateInput();
            }
        });
        Button removeButton = new Button(buttonsComposite, 8);
        removeButton.setText("Remove");
        removeButton.setEnabled(this.enabled);
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        addButton.setSize(removeButton.getSize());
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int selectionIndex = table.getSelectionIndex();
                if (selectionIndex >= 0 && selectionIndex < tableInput.size()) {
                    tableInput.remove(selectionIndex);
                    tableViewer.refresh();
                    table.setSelection(selectionIndex);
                }
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreatePropertiesDialog.this.inputDialog.setFields();
                CreatePropertiesDialog.this.inputDialog.validateInput();
            }
        });
    }

    private TableViewer createTableViewer(Table table) {
        final TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new AbstractTableLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                Pair entry = (Pair)element;
                return columnIndex == 0 ? entry.key : entry.value;
            }
        });
        List tableInput = (List)table.getData();
        tableViewer.setInput((Object)tableInput);
        tableViewer.setColumnProperties(columnNames);
        tableViewer.setCellEditors((CellEditor[])new TextCellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                Pair entry = (Pair)element;
                if (property.equals(CreatePropertiesDialog.NAME)) {
                    return entry.key;
                }
                return entry.value;
            }

            public void modify(Object element, String property, Object value) {
                TableItem item = (TableItem)element;
                Pair pair = (Pair)item.getData();
                if (property.equals(CreatePropertiesDialog.NAME)) {
                    pair.key = (String)value;
                } else {
                    pair.value = (String)value;
                }
                tableViewer.refresh();
            }
        });
        return tableViewer;
    }

    class Pair {
        String key;
        String value;

        Pair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public Pair(Map.Entry<Object, Object> entry) {
            this((String)entry.getKey(), (String)entry.getValue());
        }

        public Pair() {
            this("", "");
        }
    }
}

