/*
 * Decompiled with CFR 0.152.
 */
package tarlog.ui.swt.ddialog.impl;

import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import tarlog.ui.swt.ddialog.api.fields.InputTextField;
import tarlog.ui.swt.ddialog.api.fields.Validator;
import tarlog.ui.swt.ddialog.impl.CreateField;
import tarlog.ui.swt.ddialog.impl.DynamicInputDialog;

public class CreateText
extends CreateField {
    public CreateText(DynamicInputDialog inputDialog) {
        super(inputDialog);
    }

    public Text createField(Font font, Composite parent, final DynamicInputDialog.FieldWrapper fieldWrapper, final String fieldName) {
        this.createLabel(font, parent, fieldName);
        final InputTextField textField = fieldWrapper.field.getAnnotation(InputTextField.class);
        boolean isMultiline = false;
        boolean isPassword = false;
        if (textField != null) {
            isMultiline = textField.multiline();
            isPassword = textField.password();
            if (textField.validateNotEmpty()) {
                this.inputDialog.validators.add(this.inputDialog.validators.isEmpty() ? 0 : this.inputDialog.validators.size() - 1, new Validator(){

                    @Override
                    public String isValid() {
                        Object value = fieldWrapper.getValue(CreateText.this.object, fieldWrapper.field);
                        if (value == null || ((String)value).trim().isEmpty()) {
                            return fieldName + " cannot be empty.";
                        }
                        return null;
                    }
                });
            }
            if (!textField.validationPattern().equals("")) {
                this.inputDialog.validators.add(this.inputDialog.validators.isEmpty() ? 0 : this.inputDialog.validators.size() - 1, new Validator(){
                    final Pattern pattern;
                    {
                        this.pattern = Pattern.compile(textField.validationPattern());
                    }

                    @Override
                    public String isValid() {
                        Object value = fieldWrapper.getValue(CreateText.this.object, fieldWrapper.field);
                        Matcher matcher = this.pattern.matcher((String)value);
                        if (!matcher.matches()) {
                            return textField.validationMessage();
                        }
                        return null;
                    }
                });
            }
        }
        final Text text = new Text(parent, (isMultiline ? 2 : 4) | 0x800 | 0x200 | (fieldWrapper.inputField.readonly() ? 8 : 0));
        if (isPassword) {
            text.setEchoChar('*');
        }
        GridData layoutData = new GridData(4, isMultiline ? 4 : 0x1000000, true, isMultiline);
        if (isMultiline) {
            layoutData.heightHint = this.inputDialog.convertHorizontalDLUsToPixels(30);
        }
        text.setLayoutData((Object)layoutData);
        String value = (String)fieldWrapper.initialValue;
        if (value != null) {
            text.setText(value);
        }
        if (this.inputDialog.toValidateInput()) {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CreateText.this.inputDialog.setFields();
                    CreateText.this.inputDialog.validateInput();
                }
            });
        }
        this.fieldControls.add(new DynamicInputDialog.FieldControl(){

            @Override
            public Field getField() {
                return fieldWrapper.field;
            }

            @Override
            public Object getValue() {
                return text.getText();
            }
        });
        return text;
    }
}

