/*
 * Decompiled with CFR 0.152.
 */
package tarlog.ui.swt.ddialog.impl;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tarlog.ui.swt.ddialog.api.fields.InputField;
import tarlog.ui.swt.ddialog.api.fields.InputTextField;
import tarlog.ui.swt.ddialog.api.fields.Validator;
import tarlog.ui.swt.ddialog.impl.CreateCheckButton;
import tarlog.ui.swt.ddialog.impl.CreateCombo;
import tarlog.ui.swt.ddialog.impl.CreateDate;
import tarlog.ui.swt.ddialog.impl.CreateFileDialog;
import tarlog.ui.swt.ddialog.impl.CreateList;
import tarlog.ui.swt.ddialog.impl.CreatePropertiesDialog;
import tarlog.ui.swt.ddialog.impl.CreateSpinner;
import tarlog.ui.swt.ddialog.impl.CreateText;
import tarlog.ui.swt.ddialog.utils.ResourceBundleWrapper;
import tarlog.ui.swt.ddialog.utils.Utils;

public class DynamicInputDialog
extends Dialog {
    private static ResourceBundleWrapper resourceBundle;
    final Object object;
    private final List<FieldWrapper> fields;
    final String title;
    final List<FieldControl> fieldControls;
    final List<Validator> validators = new ArrayList<Validator>();
    private Text errorMessageText;
    private String errorMessage;

    public DynamicInputDialog(Shell parentShell, String title, Object object) {
        this(parentShell, title, object, DynamicInputDialog.getInputFields(object));
    }

    public static List<FieldWrapper> getInputFields(Object object) {
        ArrayList<FieldWrapper> fields = new ArrayList<FieldWrapper>();
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                InputField inputField = field.getAnnotation(InputField.class);
                if (inputField == null) continue;
                fields.add(new FieldWrapper(object, field, inputField));
            }
        }
        Collections.sort(fields, new Comparator<FieldWrapper>(){

            @Override
            public int compare(FieldWrapper o1, FieldWrapper o2) {
                return o1.inputField.order() - o2.inputField.order();
            }
        });
        return fields;
    }

    public DynamicInputDialog(Shell parentShell, String title, Object object, List<FieldWrapper> fields) {
        super(parentShell);
        this.object = object;
        this.fields = fields;
        this.title = title;
        this.fieldControls = new ArrayList<FieldControl>(fields.size());
        if (object instanceof Validator) {
            this.validators.add((Validator)object);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)data);
        for (final FieldWrapper fieldWrapper : this.fields) {
            Object control;
            Class<?> fieldType;
            String fieldName;
            String tmpName = fieldWrapper.inputField.name().equals("") ? fieldWrapper.field.getName() : fieldWrapper.inputField.name();
            String string = fieldName = resourceBundle != null ? resourceBundle.getString(tmpName) : tmpName;
            if (fieldWrapper.inputField.required()) {
                this.validators.add(this.validators.isEmpty() ? 0 : this.validators.size() - 1, new Validator(){

                    @Override
                    public String isValid() {
                        Object value = fieldWrapper.getValue(DynamicInputDialog.this.object, fieldWrapper.field);
                        if (value == null) {
                            return fieldName + " is required";
                        }
                        return null;
                    }
                });
            }
            if ((fieldType = fieldWrapper.field.getType()).equals(String.class)) {
                InputTextField textField = fieldWrapper.field.getAnnotation(InputTextField.class);
                control = !(textField == null || textField.values().length <= 0 && textField.valuesMethod().isEmpty()) ? new CreateCombo(this).createComboField(parent.getFont(), composite, fieldWrapper, fieldName, fieldType) : new CreateText(this).createField(parent.getFont(), composite, fieldWrapper, fieldName);
            } else if (fieldType.equals(Date.class)) {
                control = new CreateDate(this).createDialog(parent.getFont(), composite, fieldWrapper, fieldName);
            } else if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
                control = new CreateCheckButton(this).createDialog(composite, fieldWrapper, fieldName);
            } else if (fieldType.isEnum()) {
                control = new CreateCombo(this).createComboFieldOfEnum(parent.getFont(), composite, fieldWrapper, fieldName, fieldType);
            } else if (fieldType.equals(Integer.class)) {
                control = new CreateSpinner(this).createDialog(parent.getFont(), composite, fieldWrapper, fieldName);
            } else if (fieldType.equals(File.class)) {
                control = new CreateFileDialog(this).createDialog(parent.getFont(), composite, fieldWrapper, fieldName);
            } else if (fieldType.equals(Properties.class)) {
                control = new CreatePropertiesDialog(this).createDialog(composite, fieldWrapper, fieldName);
            } else if (fieldType.isArray() || fieldType.equals(Set.class)) {
                control = new CreateList(this).createField(parent.getFont(), composite, fieldWrapper, fieldName);
            } else {
                throw new RuntimeException("Unsupported type : " + fieldType.getName());
            }
            control.setEnabled(fieldWrapper.inputField.enabled());
        }
        this.errorMessageText = new Text(composite, 72);
        this.errorMessageText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.errorMessage);
        DynamicInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.validateInput();
        return contents;
    }

    protected void validateInput() {
        Validator validator;
        String errorMessage = null;
        Iterator<Validator> i$ = this.validators.iterator();
        while (i$.hasNext() && (errorMessage = (validator = i$.next()).isValid()) == null) {
        }
        this.setErrorMessage(errorMessage);
    }

    protected boolean toValidateInput() {
        return !this.validators.isEmpty();
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    public int convertHorizontalDLUsToPixels(int dlus) {
        return super.convertHorizontalDLUsToPixels(dlus);
    }

    public int convertVerticalDLUsToPixels(int dlus) {
        return super.convertVerticalDLUsToPixels(dlus);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.setFields();
        } else {
            this.restoreFields();
        }
        super.buttonPressed(buttonId);
    }

    private void restoreFields() {
        for (FieldWrapper fieldWrapper : this.fields) {
            Object value = fieldWrapper.initialValue;
            try {
                final Field f = fieldWrapper.field;
                if (!f.isAccessible()) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            f.setAccessible(true);
                            return null;
                        }
                    });
                }
                f.set(this.object, value);
            }
            catch (Exception e) {
                Utils.showException(this.getShell(), e);
            }
        }
    }

    protected void setFields() {
        for (FieldControl fieldWrapper : this.fieldControls) {
            Object value = fieldWrapper.getValue();
            try {
                final Field f = fieldWrapper.getField();
                if (!f.isAccessible()) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            f.setAccessible(true);
                            return null;
                        }
                    });
                }
                f.set(this.object, value);
            }
            catch (Exception e) {
                Utils.showException(this.getShell(), e);
            }
        }
    }

    public static void setResourceBundle(ResourceBundleWrapper resourceBundle) {
        DynamicInputDialog.resourceBundle = resourceBundle;
    }

    public static ResourceBundleWrapper getResourceBundle() {
        return resourceBundle;
    }

    public List<FieldWrapper> getFields() {
        return this.fields;
    }

    public static class FieldWrapper {
        public InputField inputField;
        public Field field;
        public Object initialValue;

        private FieldWrapper(Object obj, Field field, InputField inputField) {
            this.field = field;
            this.inputField = inputField;
            this.initialValue = this.getValue(obj, field);
        }

        protected Object getValue(Object object, Field field) {
            try {
                AccessibleObject.setAccessible(new Field[]{field}, true);
                return field.get(object);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static interface FieldControl {
        public Field getField();

        public Object getValue();
    }
}

