/*
 * Decompiled with CFR 0.152.
 */
package tarlog.ui.swt.ddialog.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class Utils {
    private static final long ONE_DAY = 86400000L;

    public static InputStream getFile(String name) throws FileNotFoundException {
        InputStream img = Utils.class.getClassLoader().getResourceAsStream(name);
        if (img == null) {
            img = new FileInputStream(name);
        }
        return img;
    }

    public static void showErrorMessage(Shell shell, String title, String text) {
        MessageBox messageBox = new MessageBox(shell, 33);
        messageBox.setMessage(String.valueOf(text));
        messageBox.setText(String.valueOf(title));
        messageBox.open();
    }

    public static boolean askYesNoQuestion(Shell shell, String title, String text) {
        MessageBox messageBox = new MessageBox(shell, 196);
        messageBox.setMessage(String.valueOf(text));
        messageBox.setText(String.valueOf(title));
        return messageBox.open() == 64;
    }

    public static void showInformationMessage(Shell shell, String title, String text) {
        MessageBox messageBox = new MessageBox(shell, 34);
        messageBox.setMessage(text);
        messageBox.setText(title);
        messageBox.open();
    }

    public static void showException(Shell shell, Throwable t) {
        t.printStackTrace();
        MultiStatus info = new MultiStatus("OK", 4, t.getMessage(), t);
        for (StackTraceElement stackTraceElement : t.getStackTrace()) {
            info.add((IStatus)new Status(4, "OK", stackTraceElement.toString()));
        }
        ErrorDialog.openError((Shell)shell, (String)"Exception occured", null, (IStatus)info);
    }

    public static String bytesToHex(String string) {
        byte[] textAsBytes = string.getBytes();
        return Utils.bytesToHex(textAsBytes);
    }

    public static String bytesToHex(byte[] textAsBytes) {
        char[] encodeHex = Hex.encodeHex((byte[])textAsBytes);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < encodeHex.length; ++i) {
            builder.append(encodeHex[i]);
            if (i % 2 == 0) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    public static byte[] bytesFromHex(String hex) throws DecoderException {
        String text = hex.replaceAll("\\s", "");
        return Hex.decodeHex((char[])text.toCharArray());
    }

    public static Boolean getBooleanInput(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue) {
        InputDialog inputDialog = new InputDialog(parentShell, dialogTitle, dialogMessage, initialValue, new IInputValidator(){

            public String isValid(String newText) {
                if (newText.equals("true") || newText.equals("false")) {
                    return null;
                }
                return "Should be true or false";
            }
        });
        int rc = inputDialog.open();
        if (rc == 0) {
            return Boolean.parseBoolean(inputDialog.getValue());
        }
        return null;
    }

    public static void setDate(DateTime dateTime, Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int day = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1);
        dateTime.setDate(year, month, day);
    }

    public static Date getDate(DateTime dateTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, dateTime.getYear());
        calendar.set(2, dateTime.getMonth());
        calendar.set(5, dateTime.getDay());
        calendar.set(11, dateTime.getHours());
        calendar.set(12, dateTime.getMinutes());
        calendar.set(13, dateTime.getSeconds());
        return calendar.getTime();
    }

    public static boolean dayEquals(Date d1, Date d2) {
        GregorianCalendar c1 = new GregorianCalendar();
        c1.setTime(d1);
        c1.set(11, 0);
        c1.set(12, 0);
        c1.set(13, 0);
        GregorianCalendar c2 = new GregorianCalendar();
        c2.setTime(d2);
        c2.set(11, 0);
        c2.set(12, 0);
        c2.set(13, 0);
        return c1.equals(c2);
    }

    public static int daysBetween(Date d1, Date d2) {
        return (int)TimeUnit.DAYS.convert(d2.getTime() - d1.getTime(), TimeUnit.MILLISECONDS);
    }

    public static Date nextDay(Date d) {
        return new Date(d.getTime() + 86400000L);
    }
}

