/*
 * Decompiled with CFR 0.152.
 */
package net.dilmerkezi.foreign;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.dilmerkezi.arac.ArrayArac;
import net.dilmerkezi.arac.LC;
import net.dilmerkezi.arac.RD;
import net.dilmerkezi.arac.XArrayArac;

public class Sozluk
extends JPanel {
    private SimpleAttributeSet tr = new SimpleAttributeSet();
    private SimpleAttributeSet ar = new SimpleAttributeSet();
    private SimpleAttributeSet en = new SimpleAttributeSet();
    private StyledDocument doc;
    private JTextField trfield;
    private JTextField arfield;
    private JTextPane tp;
    private static JFrame fr;
    private final IListener alis = new IListener();

    protected Sozluk() {
        super(new BorderLayout());
        JMenuItem jMenuItem;
        int n;
        this.setBorder(BorderFactory.createTitledBorder("Dictionary"));
        this.setStyles();
        this.tp = new JTextPane();
        this.tp.setEditable(false);
        this.tp.setDragEnabled(true);
        this.doc = this.tp.getStyledDocument();
        JPanel jPanel = this.getNorthPanel();
        this.add("North", jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.add(this.tp);
        jPanel2.add("Center", jScrollPane);
        this.add("Center", jPanel2);
        JMenuBar jMenuBar = new JMenuBar();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("Center", jMenuBar);
        String[] stringArray = new String[]{"\u00e1", "\u00e9", "\u00ed", "\u00f3", "\u00fa", "\u00f1", "\u00c1", "\u00c9", "\u00cd", "\u00d3", "\u00fa", "\u00d1"};
        JMenu jMenu = new JMenu("Characters1");
        jMenu.setBorder(BorderFactory.createLineBorder(Color.red));
        jMenu.setMnemonic(67);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Characters2");
        jMenu2.setBorder(BorderFactory.createLineBorder(Color.green));
        jMenuBar.add(jMenu2);
        int n2 = stringArray.length;
        for (n = 0; n < 6; ++n) {
            jMenuItem = this.makeItem(stringArray[n]);
            jMenu.add(jMenuItem);
        }
        for (n = 6; n < n2; ++n) {
            jMenuItem = this.makeItem(stringArray[n]);
            jMenu2.add(jMenuItem);
        }
        this.add("South", jPanel3);
    }

    private JMenuItem makeItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setPreferredSize(new Dimension(60, 25));
        jMenuItem.setMargin(new Insets(4, 4, 4, 4));
        jMenuItem.setFont(LC.getXFont());
        jMenuItem.addActionListener(this.alis);
        return jMenuItem;
    }

    private final JPanel getNorthPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 2, 2, 2));
        jPanel.setPreferredSize(new Dimension(160, 65));
        JLabel jLabel = new JLabel("English", 0);
        jPanel.add(jLabel);
        this.trfield = new JTextField();
        this.trfield.getDocument().addDocumentListener(new TRDocumentListener());
        this.trfield.setFont(new Font("Serif", 1, 12));
        jPanel.add(this.trfield);
        JLabel jLabel2 = new JLabel("Spanish", 0);
        jPanel.add(jLabel2);
        this.arfield = new JTextField();
        this.arfield.getDocument().addDocumentListener(new ARDocumentListener());
        this.arfield.setFont(LC.getXFont());
        jPanel.add(this.arfield);
        return jPanel;
    }

    private final void setStyles() {
        StyleConstants.setBackground(this.tr, new Color(0xEEEEEE));
        StyleConstants.setForeground(this.tr, Color.red);
        StyleConstants.setFontFamily(this.tr, "Lucida Sans Demi Bold");
        StyleConstants.setFontSize(this.tr, 17);
        StyleConstants.setBold(this.tr, true);
        StyleConstants.setBackground(this.ar, new Color(0xFFEEEE));
        StyleConstants.setForeground(this.ar, Color.blue);
        StyleConstants.setFontFamily(this.ar, LC.getXFont().getFamily());
        StyleConstants.setFontSize(this.ar, 17);
        StyleConstants.setBold(this.ar, true);
        StyleConstants.setBackground(this.en, new Color(0xEEEEFF));
        StyleConstants.setForeground(this.en, Color.green.darker());
        StyleConstants.setFontFamily(this.en, "Serif");
        StyleConstants.setFontSize(this.en, 17);
        StyleConstants.setBold(this.en, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeStream(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    protected static final void showDictWindow(boolean bl) {
        fr.setVisible(bl);
    }

    protected static final void showFrame() {
        fr = new JFrame("Dictionary");
        fr.setDefaultCloseOperation(3);
        Sozluk sozluk = new Sozluk();
        sozluk.setOpaque(true);
        fr.setContentPane(sozluk);
        fr.pack();
        fr.setSize(600, 500);
        fr.setResizable(false);
        fr.setLocation(100, 100);
        fr.setVisible(true);
    }

    public static final void main(String[] stringArray) {
        Runnable runnable = new Runnable(){

            public void run() {
                Sozluk.showFrame();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private final class IListener
    implements ActionListener {
        private IListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)object;
                Sozluk.this.arfield.setText(Sozluk.this.arfield.getText() + jMenuItem.getText());
                return;
            }
        }
    }

    private final class ARDocumentListener
    implements DocumentListener {
        private ARDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Sozluk.this.tp.setText("");
            this.insertMeans();
            Sozluk.this.tp.setCaretPosition(0);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            Sozluk.this.tp.setText("");
            this.insertMeans();
            Sozluk.this.tp.setCaretPosition(0);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private final void insertMeans() {
            String string = Sozluk.this.arfield.getText();
            if (string == null) {
                return;
            }
            int n = string.length();
            if (n < 2) {
                return;
            }
            String string2 = "";
            string2 = XArrayArac.getName(string.toLowerCase());
            DataInputStream dataInputStream = null;
            try {
                dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(string2))));
            }
            catch (Exception exception) {
                dataInputStream = null;
            }
            if (dataInputStream == null) {
                return;
            }
            String string3 = "";
            String string4 = "";
            String[] stringArray = null;
            int n2 = 0;
            try {
                int n3;
                boolean bl = false;
                while ((string3 = RD.read(dataInputStream)) != null && (stringArray = string3.split(": ")) != null && (n3 = stringArray.length) >= 2) {
                    string4 = stringArray[0];
                    if (string.equalsIgnoreCase(string4)) {
                        bl = true;
                        Sozluk.this.doc.remove(0, Sozluk.this.doc.getLength());
                        Sozluk.this.doc.insertString(Sozluk.this.doc.getLength(), string4 + "\n\n", Sozluk.this.tr);
                        Sozluk.this.doc.insertString(Sozluk.this.doc.getLength(), stringArray[1] + "\n\n", Sozluk.this.ar);
                        if (n3 < 3) break;
                        Sozluk.this.doc.insertString(Sozluk.this.doc.getLength(), stringArray[2] + "\n\n", Sozluk.this.en);
                        break;
                    }
                    if (string4.startsWith(string)) {
                        Sozluk.this.doc.insertString(Sozluk.this.doc.getLength(), string3 + "\n", Sozluk.this.ar);
                        ++n2;
                    }
                    if (n2 < 5) continue;
                }
                if (!bl) {
                    Sozluk.this.doc.insertString(Sozluk.this.doc.getLength(), string + "--> Not Found!!!", Sozluk.this.tr);
                }
            }
            catch (Exception exception) {
                Sozluk.this.closeStream(dataInputStream);
                return;
            }
            Sozluk.this.closeStream(dataInputStream);
        }
    }

    private final class TRDocumentListener
    implements DocumentListener {
        private TRDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Sozluk.this.tp.setText("");
            this.insertMeans();
            Sozluk.this.tp.setCaretPosition(0);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            Sozluk.this.tp.setText("");
            this.insertMeans();
            Sozluk.this.tp.setCaretPosition(0);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private final void insertMeans() {
            String string = Sozluk.this.trfield.getText();
            if (string == null) {
                return;
            }
            int n = string.length();
            if (n < 2) {
                return;
            }
            String string2 = "";
            string2 = string.startsWith("to ") && n >= 4 ? ArrayArac.getName(string.substring(3).toLowerCase()) : ArrayArac.getName(string.toLowerCase());
            DataInputStream dataInputStream = null;
            try {
                dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(string2))));
            }
            catch (Exception exception) {
                dataInputStream = null;
            }
            if (dataInputStream == null) {
                return;
            }
            String string3 = "";
            String string4 = "";
            String[] stringArray = null;
            int n2 = 0;
            try {
                int n3;
                boolean bl = false;
                while ((string3 = RD.read(dataInputStream)) != null && (stringArray = string3.split(": ")) != null && (n3 = stringArray.length) >= 2) {
                    string4 = stringArray[0];
                    if (string.equalsIgnoreCase(string4)) {
                        bl = true;
                        Sozluk.this.doc.remove(0, Sozluk.this.doc.getLength());
                        Sozluk.this.doc.insertString(Sozluk.this.doc.getLength(), string4 + "\n\n", Sozluk.this.tr);
                        Sozluk.this.doc.insertString(Sozluk.this.doc.getLength(), stringArray[1] + "\n\n", Sozluk.this.ar);
                        if (n3 < 3) break;
                        Sozluk.this.doc.insertString(Sozluk.this.doc.getLength(), stringArray[2] + "\n\n", Sozluk.this.en);
                        break;
                    }
                    if (string4.startsWith(string)) {
                        Sozluk.this.doc.insertString(Sozluk.this.doc.getLength(), string3 + "\n", Sozluk.this.ar);
                        ++n2;
                    }
                    if (n2 < 5) continue;
                }
                if (!bl) {
                    Sozluk.this.doc.insertString(Sozluk.this.doc.getLength(), string + "--> Not Found!!!", Sozluk.this.tr);
                }
            }
            catch (Exception exception) {
                Sozluk.this.closeStream(dataInputStream);
                return;
            }
            Sozluk.this.closeStream(dataInputStream);
        }
    }
}

