/*
 * Decompiled with CFR 0.152.
 */
package Mapping;

import Reps.AttributeRep;
import UI.Constants;
import java.util.ArrayList;
import java.util.Iterator;

public class Relation {
    private String fName;
    private final ArrayList fKeyAttributes;
    private ArrayList fNonKeyAttributes;
    private boolean fIsRelationship;

    public Relation(String name, boolean isRelationship) {
        this.fName = name;
        this.fKeyAttributes = new ArrayList();
        this.fNonKeyAttributes = new ArrayList();
        this.fIsRelationship = isRelationship;
    }

    public void addKeyAttribute(AttributeRep attribute) {
        this.fKeyAttributes.add(attribute);
    }

    public void addNonKeyAttribute(AttributeRep attribute) {
        this.fNonKeyAttributes.add(attribute);
    }

    public void addAllKeyAttributes(ArrayList attributes) {
        this.fKeyAttributes.addAll(attributes);
    }

    public void addAllNonKeyAttributes(ArrayList attributes) {
        this.fNonKeyAttributes.addAll(attributes);
    }

    public ArrayList getKeyAttributes() {
        return this.fKeyAttributes;
    }

    public ArrayList getNonKeyAttributes() {
        return this.fNonKeyAttributes;
    }

    public String getName() {
        return this.fName;
    }

    public ArrayList getReferences() {
        ArrayList attributes = new ArrayList();
        attributes.addAll(this.fKeyAttributes);
        attributes.addAll(this.fNonKeyAttributes);
        ArrayList<String> references = new ArrayList<String>();
        for (AttributeRep attr : attributes) {
            String name = attr.getAttributedElement().getName();
            if (name.equals(this.fName) || references.contains(name)) continue;
            references.add(name);
        }
        return references;
    }

    public String getSQL() {
        String name;
        AttributeRep attr2;
        String sql = "CREATE TABLE " + this.fName + "(";
        ArrayList attributes = new ArrayList();
        attributes.addAll(this.fKeyAttributes);
        attributes.addAll(this.fNonKeyAttributes);
        Iterator itAttributes = attributes.iterator();
        while (itAttributes.hasNext()) {
            sql = sql + "\n";
            attr2 = (AttributeRep)itAttributes.next();
            name = this.alreadyExists(attr2) ? attr2.getAttributedElement().getName() + "_" + attr2.getName() : attr2.getName();
            sql = sql + " " + name + " " + attr2.getDataType();
            boolean showLength = false;
            for (int i = 0; i < Constants.kTypeWithLength.length; ++i) {
                if (!Constants.kTypeWithLength[i].equals(attr2.getDataType())) continue;
                showLength = true;
            }
            if (showLength) {
                sql = sql + "(" + attr2.getLength() + ")";
            }
            if (!this.fIsRelationship) {
                if (attr2.isUnique()) {
                    sql = sql + " UNIQUE";
                }
                if (attr2.isRequired()) {
                    sql = sql + " NOT NULL";
                }
            } else {
                sql = sql + " NOT NULL";
            }
            if (!itAttributes.hasNext()) continue;
            sql = sql + ",";
        }
        for (AttributeRep attr2 : attributes) {
            if (attr2.getAttributedElement().getName().equals(this.fName)) continue;
            sql = sql + ",\nFOREIGN KEY (";
            sql = sql + attr2.getName() + ") REFERENCES " + attr2.getAttributedElement().getName() + " (" + attr2.getName() + ")";
        }
        sql = sql + ",\nPRIMARY KEY (";
        itAttributes = this.fKeyAttributes.iterator();
        while (itAttributes.hasNext()) {
            attr2 = (AttributeRep)itAttributes.next();
            name = this.alreadyExists(attr2) ? attr2.getAttributedElement().getName() + "_" + attr2.getName() : attr2.getName();
            sql = sql + name;
            if (!itAttributes.hasNext()) continue;
            sql = sql + ",";
        }
        sql = sql + "));\n";
        return sql;
    }

    public int getNrAttributes() {
        return this.fKeyAttributes.size() + this.fNonKeyAttributes.size();
    }

    public boolean alreadyExists(AttributeRep attribute) {
        for (AttributeRep attr : this.fKeyAttributes) {
            if (attribute.equals(attr) || !attribute.getName().equals(attr.getName())) continue;
            return true;
        }
        for (AttributeRep attr : this.fNonKeyAttributes) {
            if (attribute.equals(attr) || !attribute.getName().equals(attr.getName())) continue;
            return true;
        }
        return false;
    }
}

