/*
 * Decompiled with CFR 0.152.
 */
package Reps;

import Exceptions.AttributeRepException;
import Exceptions.AttributedElementException;
import Mapping.Relation;
import Reps.AttributedElement;
import Reps.Element;
import Reps.EntityRep;
import Reps.RelationshipRep;
import java.io.IOException;
import java.io.Writer;

public class AttributeRep
extends Element {
    public static final String kNormal = "normal";
    public static final String kKey = "key";
    public static final String kMultivalued = "multivalued";
    private static int fAttributeRepCount = 0;
    private AttributedElement fAttributedElement = null;
    private String fType = "normal";
    private String fDataType = "varchar";
    private boolean fRequired = false;
    private boolean fUnique = false;
    private int fLength = 50;

    public AttributeRep(String name, String type) {
        super(name);
        this.fType = type;
        ++fAttributeRepCount;
    }

    public AttributeRep() {
        super("Attribute" + ++fAttributeRepCount);
    }

    public String getType() {
        return this.fType;
    }

    public String getDataType() {
        return this.fDataType;
    }

    public boolean isUnique() {
        return this.fUnique;
    }

    public Relation getMappedRelation() {
        if (!this.fType.equals(kMultivalued) || this.fAttributedElement == null) {
            return null;
        }
        Relation relation = new Relation(this.fAttributedElement.getName() + "_" + this.getName(), false);
        relation.addAllKeyAttributes(this.fAttributedElement.getPrimaryKey());
        relation.addKeyAttribute(this);
        return relation;
    }

    public boolean isRequired() {
        return this.fRequired;
    }

    @Override
    public boolean isWeak() {
        return false;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setType(String type) throws AttributeRepException {
        if (this.fAttributedElement != null) {
            if (this.fAttributedElement instanceof RelationshipRep) {
                throw new AttributeRepException("Relationship cannot have key attributes...");
            }
            EntityRep entity = (EntityRep)this.fAttributedElement;
            if (entity.isSubEntity() && type.equals(kKey)) {
                throw new AttributeRepException("Sub Entities cannot have key attributes...");
            }
            if (this.fType.equals(kKey) && entity.givesDependency()) {
                throw new AttributeRepException("There are entities dependent on this key attribute...");
            }
        }
        if (type == kKey) {
            this.fRequired = true;
        }
        this.fType = type;
    }

    public void setRequired(boolean required) throws AttributeRepException {
        if (!required && this.fType == kKey) {
            throw new AttributeRepException("A Key field is always required...");
        }
        this.fRequired = required;
    }

    public void setUnique(boolean unique) {
        this.fUnique = unique;
    }

    public void setDataType(String dataType) {
        this.fDataType = dataType;
    }

    public void setLength(int length) {
        this.fLength = length;
    }

    @Override
    public void setName(String name) throws AttributeRepException {
        String oldName = this.getName();
        try {
            super.setName(name);
            if (this.fAttributedElement != null && this.fAttributedElement.attributeAlreadyExists(this)) {
                super.setName(oldName);
                throw new AttributedElementException("An attribute with the same name is already connected to this element...");
            }
        }
        catch (Exception e) {
            throw new AttributeRepException(e.getMessage());
        }
    }

    protected void setAttributedElement(AttributedElement attributedElement) {
        this.fAttributedElement = attributedElement;
    }

    public AttributedElement getAttributedElement() {
        return this.fAttributedElement;
    }

    @Override
    public String check() {
        if (this.fAttributedElement == null) {
            return "Attribute \"" + this.getName() + "\" not connected to an entity";
        }
        return null;
    }

    @Override
    public void writeReference(Writer out) throws IOException {
    }

    @Override
    public void write(Writer out) throws IOException {
        out.write("\t\t<attributeid id=\"" + this.getID() + "\" posX=\"" + this.getX() + "\" posY=\"" + this.getY() + "\" type=\"" + this.fType + "\" name=\"" + this.getName() + "\" required=\"" + this.fRequired + "\" unique=\"" + this.fUnique + "\" datatype=\"" + this.fDataType + "\" length=\"" + this.fLength + "\">");
        out.write("</attributeid>\n");
    }
}

