/*
 * Decompiled with CFR 0.152.
 */
package Reps;

import Exceptions.AttributedElementException;
import Mapping.Relation;
import Reps.AttributeRep;
import Reps.Element;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public abstract class AttributedElement
extends Element {
    public ArrayList fAttributes = new ArrayList();

    public AttributedElement(String name) {
        super(name);
    }

    public void addAttribute(AttributeRep attribute) throws AttributedElementException {
        if (this.fAttributes.contains(attribute)) {
            throw new AttributedElementException("Attribute already belongs to this element...");
        }
        if (this.isSubEntity() && attribute.getType().equals("key")) {
            throw new AttributedElementException("Sub Entities cannot have key attributes...");
        }
        if (attribute.getAttributedElement() != null) {
            throw new AttributedElementException("Attribute already belongs to another element...");
        }
        if (this.attributeAlreadyExists(attribute)) {
            throw new AttributedElementException("An attribute with the same name is already connected to this element...");
        }
        this.fAttributes.add(attribute);
        attribute.setAttributedElement(this);
    }

    public boolean canAddAttribute(AttributeRep attribute) {
        if (this.fAttributes.contains(attribute)) {
            return false;
        }
        if (this.isSubEntity() && attribute.getType().equals("key")) {
            return false;
        }
        if (attribute.getAttributedElement() != null) {
            return false;
        }
        return !this.attributeAlreadyExists(attribute);
    }

    protected abstract boolean isSubEntity();

    public ArrayList getAttributes() {
        return this.fAttributes;
    }

    public abstract ArrayList getPrimaryKey();

    public void removeAttribute(AttributeRep attribute) {
        this.fAttributes.remove(attribute);
        attribute.setAttributedElement(null);
    }

    public abstract Relation getMappedRelation();

    protected void writeAttributeList(Writer out) throws IOException {
        out.write("\t\t<attributelist>\n");
        for (AttributeRep attribute : this.fAttributes) {
            out.write("\t\t\t<attribute id=\"" + attribute.getID() + "\"></attribute>\n");
        }
        out.write("\t\t</attributelist>\n");
    }

    @Override
    public abstract void write(Writer var1) throws IOException;

    @Override
    public abstract void writeReference(Writer var1) throws IOException;

    protected boolean attributeAlreadyExists(AttributeRep attribute) {
        for (AttributeRep currentAttribute : this.fAttributes) {
            if (currentAttribute == attribute || !attribute.getName().equals(currentAttribute.getName())) continue;
            return true;
        }
        return false;
    }
}

