/*
 * Decompiled with CFR 0.152.
 */
package Reps;

import Exceptions.EntityRepException;
import Exceptions.RelationshipRepException;
import Mapping.Relation;
import Reps.AttributeRep;
import Reps.AttributedElement;
import Reps.RelationshipRep;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;

public class EntityRep
extends AttributedElement {
    private static int fEntityRepCount = 0;
    private ArrayList fSuperEntities = new ArrayList();
    private ArrayList fConnectedRelationships = new ArrayList();
    private ArrayList fDependentRelationships = new ArrayList();

    public EntityRep(String name) {
        super(name);
        ++fEntityRepCount;
    }

    public EntityRep() {
        super("Entity" + ++fEntityRepCount);
    }

    public ArrayList getConnectedRelationships() {
        return this.fConnectedRelationships;
    }

    public boolean hasDependency(RelationshipRep relationship) {
        return this.fDependentRelationships.contains(relationship);
    }

    private ArrayList getAllKeyAttributes() {
        ArrayList<AttributeRep> keyAttributes = new ArrayList<AttributeRep>();
        for (AttributeRep attr : this.getAttributes()) {
            if (!attr.getType().equals("key")) continue;
            keyAttributes.add(attr);
        }
        for (RelationshipRep relationship : this.fDependentRelationships) {
            EntityRep entity = relationship.getOtherEntityFromTwo(this);
            keyAttributes.addAll(entity.getPrimaryKey());
        }
        return keyAttributes;
    }

    private ArrayList getAllNonKeyAttributes() {
        ArrayList<AttributeRep> attributes = new ArrayList<AttributeRep>();
        for (AttributeRep attr : this.getAttributes()) {
            if (attr.getType().equals("key")) continue;
            attributes.add(attr);
        }
        return attributes;
    }

    public boolean hasKeyAttributes() {
        return !this.getAllKeyAttributes().isEmpty();
    }

    @Override
    public ArrayList getPrimaryKey() {
        if (this.fSuperEntities.isEmpty()) {
            return this.getAllKeyAttributes();
        }
        ArrayList<AttributeRep> primaryKey = new ArrayList<AttributeRep>();
        for (EntityRep entity : this.fSuperEntities) {
            for (AttributeRep attribute : entity.getPrimaryKey()) {
                if (primaryKey.contains(attribute)) continue;
                primaryKey.add(attribute);
            }
        }
        return primaryKey;
    }

    @Override
    public String check() {
        if (this.getPrimaryKey().isEmpty()) {
            return "Entity \"" + this.getName() + "\" has no primary key";
        }
        return null;
    }

    @Override
    public Relation getMappedRelation() {
        Relation relation = new Relation(this.getName(), false);
        relation.addAllKeyAttributes(this.getPrimaryKey());
        relation.addAllNonKeyAttributes(this.getAllNonKeyAttributes());
        return relation;
    }

    protected void removeSuperEntity(EntityRep entity) {
        this.fSuperEntities.remove(entity);
    }

    @Override
    public boolean isWeak() {
        return !this.fDependentRelationships.isEmpty();
    }

    public void addDependency(RelationshipRep relationship, boolean skipCheck) throws EntityRepException {
        try {
            if (!skipCheck) {
                if (this.fSuperEntities.size() != 0) {
                    throw new EntityRepException("Sub Entity cannot have key attributes, so it cannot be weak...");
                }
                if (!this.fConnectedRelationships.contains(relationship)) {
                    throw new EntityRepException("Relationship is not connected to this entity...");
                }
                if (this.fDependentRelationships.contains(relationship)) {
                    throw new EntityRepException("Entity already depends on this relationship...");
                }
                if (relationship.getRoles().size() == 2 && this.isDependentOn(relationship.getOtherEntityFromTwo(this))) {
                    throw new EntityRepException("Entity already depends on this relationship...");
                }
            }
            relationship.setWeakEntity(this, skipCheck);
            this.fDependentRelationships.add(relationship);
        }
        catch (RelationshipRepException e) {
            throw new EntityRepException(e.getMessage());
        }
    }

    public boolean canBeSetDependentOf(RelationshipRep relationship) {
        if (this.fSuperEntities.size() != 0) {
            return false;
        }
        if (!this.fConnectedRelationships.contains(relationship)) {
            return false;
        }
        if (this.fDependentRelationships.contains(relationship)) {
            return false;
        }
        if (relationship.getRoles().size() == 2 && this.isDependentOn(relationship.getOtherEntityFromTwo(this))) {
            return false;
        }
        return relationship.canBeSetWeak(this);
    }

    public void removeDependency(RelationshipRep relationship) {
        relationship.removeWeakEntity();
        this.fDependentRelationships.remove(relationship);
    }

    @Override
    public void removeAttribute(AttributeRep attribute) {
        super.removeAttribute(attribute);
        this.adjustDependencies();
    }

    public ArrayList getDependentRelationships() {
        return this.fDependentRelationships;
    }

    @Override
    public void writeReference(Writer out) throws IOException {
        if (this.isWeak()) {
            out.write("\t<weakentity id=\"" + this.getID() + "\">\n");
            this.writeAttributeList(out);
            out.write("\t\t<dependencylist>\n");
            for (RelationshipRep relationship : this.fDependentRelationships) {
                out.write("\t\t\t<dependencyref relationshipid=\"" + relationship.getID() + "\"></dependencyref>\n");
            }
            out.write("\t\t</dependencylist>\n");
            out.write("\t</weakentity>\n");
        } else if (!this.getAttributes().isEmpty()) {
            out.write("\t<entity id=\"" + this.getID() + "\">\n");
            this.writeAttributeList(out);
            out.write("\t</entity>\n");
        }
    }

    @Override
    public void write(Writer out) throws IOException {
        if (this.isWeak()) {
            out.write("\t\t<weakentityid id=\"" + this.getID() + "\" posX=\"" + this.getX() + "\" posY=\"" + this.getY() + "\" name=\"" + this.getName() + "\">");
            out.write("</weakentityid>\n");
        } else {
            out.write("\t\t<entityid id=\"" + this.getID() + "\" posX=\"" + this.getX() + "\" posY=\"" + this.getY() + "\" name=\"" + this.getName() + "\">");
            out.write("</entityid>\n");
        }
    }

    protected boolean givesDependency() {
        for (RelationshipRep relationship : this.fConnectedRelationships) {
            if (!relationship.isWeak() || relationship.getWeakEntity().equals(this)) continue;
            return true;
        }
        return false;
    }

    private void adjustDependencies() {
        if (this.getPrimaryKey().isEmpty()) {
            for (RelationshipRep relationship : this.fConnectedRelationships) {
                if (!relationship.isWeak()) continue;
                EntityRep weakEntity = relationship.getWeakEntity();
                weakEntity.removeDependency(relationship);
                weakEntity.adjustDependencies();
            }
        }
    }

    protected void addSuperEntity(EntityRep entity) {
        if (!this.fSuperEntities.contains(entity)) {
            this.fSuperEntities.add(entity);
        }
    }

    protected void addConnectedRelationship(RelationshipRep relationship) {
        this.fConnectedRelationships.add(relationship);
    }

    protected void removeConnectedRelationship(RelationshipRep relationship) {
        this.fConnectedRelationships.remove(relationship);
    }

    protected boolean isSuperEntityOf(EntityRep superEntity) {
        Iterator itSuperEntities = this.fSuperEntities.iterator();
        if (itSuperEntities.hasNext()) {
            EntityRep entity = (EntityRep)itSuperEntities.next();
            if (entity.equals(superEntity)) {
                return true;
            }
            return entity.isSuperEntityOf(superEntity);
        }
        return false;
    }

    private boolean isDependentOn(EntityRep entity) {
        ArrayList key = entity.getPrimaryKey();
        for (AttributeRep keyAttribute : key) {
            if (!keyAttribute.getAttributedElement().equals(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isSubEntity() {
        return this.fSuperEntities.size() != 0;
    }
}

