/*
 * Decompiled with CFR 0.152.
 */
package Reps;

import Exceptions.ISARepException;
import Reps.Element;
import Reps.EntityRep;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;

public class ISARep
extends Element {
    private EntityRep fSuperEntity = null;
    private ArrayList fSubEntities = new ArrayList();

    public ISARep() {
        super("ISA");
    }

    public void addSubEntity(EntityRep entity) throws ISARepException {
        if (this.fSuperEntity == entity) {
            throw new ISARepException("Entity is the super entity of this ISA Relationship...");
        }
        if (entity.hasKeyAttributes()) {
            throw new ISARepException("Sub Entities cannot have key attributes...");
        }
        if (this.isSubEntity(entity)) {
            throw new ISARepException("Entity is already a sub entity of this ISA Relationship...");
        }
        if (this.fSuperEntity != null && this.fSuperEntity.isSuperEntityOf(entity)) {
            throw new ISARepException("ISA cycles are not allowed...");
        }
        this.fSubEntities.add(entity);
        if (this.fSuperEntity != null) {
            entity.addSuperEntity(this.fSuperEntity);
        }
    }

    public boolean canAddSubEntity(EntityRep entity) {
        if (this.fSuperEntity == entity) {
            return false;
        }
        if (entity.hasKeyAttributes()) {
            return false;
        }
        if (this.isSubEntity(entity)) {
            return false;
        }
        return this.fSuperEntity == null || !this.fSuperEntity.isSuperEntityOf(entity);
    }

    public ArrayList getSubEntities() {
        return this.fSubEntities;
    }

    @Override
    public String check() {
        if (this.fSubEntities.isEmpty() && this.fSuperEntity == null) {
            return "ISA Relationship has no super entity and no sub entities";
        }
        if (this.fSubEntities.isEmpty()) {
            return "ISA Relationship has no subentities";
        }
        if (this.fSuperEntity == null) {
            return "ISA Relationship has no super entity";
        }
        return null;
    }

    public EntityRep getSuperEntity() {
        return this.fSuperEntity;
    }

    @Override
    public boolean isWeak() {
        return false;
    }

    public void setSuperEntity(EntityRep entity) throws ISARepException {
        if (this.fSuperEntity == entity) {
            throw new ISARepException("Entity is already the super entity of this ISA Relationship...");
        }
        if (this.fSuperEntity != null) {
            throw new ISARepException("ISA Relationship already has a super entity...");
        }
        if (this.isSubEntity(entity)) {
            throw new ISARepException("ISA cycles are not allowed...");
        }
        this.fSuperEntity = entity;
        for (EntityRep subEntity : this.fSubEntities) {
            subEntity.addSuperEntity(entity);
        }
    }

    public boolean canSetSuperEntity(EntityRep entity) {
        if (this.fSuperEntity == entity) {
            return false;
        }
        if (this.fSuperEntity != null) {
            return false;
        }
        return !this.isSubEntity(entity);
    }

    public void removeEntity(EntityRep entity) throws ISARepException {
        if (!this.fSubEntities.contains(entity) && this.fSuperEntity != entity) {
            throw new ISARepException("Entity not found...");
        }
        if (this.fSuperEntity == entity) {
            this.fSuperEntity = null;
            for (EntityRep subEntity : this.fSubEntities) {
                subEntity.removeSuperEntity(entity);
            }
        } else {
            this.fSubEntities.remove(entity);
            if (this.fSuperEntity != null) {
                entity.removeSuperEntity(this.fSuperEntity);
            }
        }
    }

    @Override
    public void write(Writer out) throws IOException {
        out.write("\t\t<isaid id=\"" + this.getID() + "\" posX=\"" + this.getX() + "\" posY=\"" + this.getY() + "\"></isaid>\n");
    }

    @Override
    public void writeReference(Writer out) throws IOException {
        out.write("\t<isa id=\"" + this.getID() + "\">\n");
        if (this.fSuperEntity != null) {
            out.write("\t\t<superentity id=\"" + this.fSuperEntity.getID() + "\"></superentity>\n");
        }
        if (!this.fSubEntities.isEmpty()) {
            out.write("\t\t<subentitylist>\n");
            for (EntityRep subEntity : this.fSubEntities) {
                out.write("\t\t\t<subentity id=\"" + subEntity.getID() + "\"></subentity>\n");
            }
            out.write("\t\t</subentitylist>\n");
        }
        out.write("\t</isa>\n");
    }

    private boolean isSubEntity(EntityRep entity) {
        Iterator itSubEntities = this.fSubEntities.iterator();
        if (itSubEntities.hasNext()) {
            EntityRep subEntity = (EntityRep)itSubEntities.next();
            if (subEntity.equals(entity)) {
                return true;
            }
            return entity.isSuperEntityOf(subEntity);
        }
        return false;
    }
}

