/*
 * Decompiled with CFR 0.152.
 */
package Reps;

import Exceptions.RelationshipRepException;
import Exceptions.RoleException;
import Mapping.Relation;
import Reps.AttributedElement;
import Reps.EntityRep;
import Reps.Role;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class RelationshipRep
extends AttributedElement {
    private ArrayList fRoles = new ArrayList();
    private static int fRelationshipRepCount = 0;
    private EntityRep fWeakEntity = null;

    public RelationshipRep(String name) {
        super(name);
        ++fRelationshipRepCount;
    }

    public RelationshipRep() {
        super("Rel" + ++fRelationshipRepCount);
    }

    public void addRole(Role role) throws RoleException {
        if (this.isWeak() && this.fRoles.size() == 2) {
            throw new RoleException("Only 2 roles are allowed for a weak relationship...");
        }
        EntityRep entity = role.getEntity();
        if (this.isRecursive(entity)) {
            throw new RoleException("Only 2 roles to the same entity are allowed...");
        }
        this.fRoles.add(role);
        entity.addConnectedRelationship(this);
    }

    public boolean canAddRole(Role role) {
        if (this.isWeak() && this.fRoles.size() == 2) {
            return false;
        }
        return !this.isRecursive(role.getEntity());
    }

    public void removeRole(Role role) throws RoleException {
        if (!this.fRoles.contains(role)) {
            throw new RoleException("Role doesn't exist...");
        }
        EntityRep entity = role.getEntity();
        entity.removeConnectedRelationship(this);
        if (this.isWeak()) {
            this.fWeakEntity.removeDependency(this);
        }
        this.fRoles.remove(role);
    }

    @Override
    public boolean isWeak() {
        return this.fWeakEntity != null;
    }

    public boolean isRecursive(EntityRep entity) {
        int count = 0;
        for (Role role : this.fRoles) {
            EntityRep entity1 = role.getEntity();
            if (!entity1.equals(entity)) continue;
            ++count;
        }
        return count > 1;
    }

    public Role getFirstRecursiveRole(EntityRep entity) {
        boolean count = false;
        for (Role role : this.fRoles) {
            if (!role.getEntity().equals(entity)) continue;
            return role;
        }
        return null;
    }

    public EntityRep getWeakEntity() {
        return this.fWeakEntity;
    }

    protected void setWeakEntity(EntityRep entity, boolean skipCheck) throws RelationshipRepException {
        if (!skipCheck) {
            if (this.fRoles.size() != 2) {
                throw new RelationshipRepException("Weak relationship should have exactly two roles...");
            }
            if (this.isWeak()) {
                throw new RelationshipRepException("Relationship is already weak...");
            }
            if (this.getOtherEntityFromTwo(entity).getPrimaryKey().isEmpty()) {
                throw new RelationshipRepException("Entity should have a primary key...");
            }
        }
        this.fWeakEntity = entity;
    }

    @Override
    protected boolean isSubEntity() {
        return false;
    }

    public boolean canBeSetWeak(EntityRep entity) {
        if (this.fRoles.size() != 2) {
            return false;
        }
        if (this.isWeak()) {
            return false;
        }
        return !this.getOtherEntityFromTwo(entity).getPrimaryKey().isEmpty();
    }

    protected void removeWeakEntity() {
        this.fWeakEntity = null;
    }

    protected EntityRep getOtherEntityFromTwo(EntityRep entity) {
        if (this.fRoles.size() == 2) {
            EntityRep entity1 = ((Role)this.fRoles.get(0)).getEntity();
            EntityRep entity2 = ((Role)this.fRoles.get(1)).getEntity();
            if (entity1.equals(entity)) {
                return entity2;
            }
            return entity1;
        }
        return null;
    }

    @Override
    public String check() {
        if (this.fRoles.size() <= 1) {
            return "Relationship \"" + this.getName() + "\" should have at least 2 entities";
        }
        return null;
    }

    @Override
    public ArrayList getPrimaryKey() {
        ArrayList primaryKey = new ArrayList();
        for (Role role : this.fRoles) {
            primaryKey.addAll(role.getEntity().getPrimaryKey());
        }
        return primaryKey;
    }

    @Override
    public Relation getMappedRelation() {
        if (this.isWeak()) {
            return null;
        }
        Relation relation = new Relation(this.getName(), true);
        if (this.fRoles.size() == 2) {
            Role role1 = (Role)this.fRoles.get(0);
            Role role2 = (Role)this.fRoles.get(1);
            if (role1.isOneOne()) {
                relation = role2.getEntity().getMappedRelation();
                relation.addAllNonKeyAttributes(role1.getEntity().getPrimaryKey());
                return relation;
            }
            if (role2.isOneOne()) {
                relation = role1.getEntity().getMappedRelation();
                relation.addAllNonKeyAttributes(role2.getEntity().getPrimaryKey());
                return relation;
            }
        }
        relation.addAllNonKeyAttributes(this.getAttributes());
        relation.addAllKeyAttributes(this.getPrimaryKey());
        return relation;
    }

    public ArrayList getRoles() {
        return this.fRoles;
    }

    @Override
    public void writeReference(Writer out) throws IOException {
        if (this.isWeak()) {
            out.write("\t<weakrelationship id=\"" + this.getID() + "\">\n");
        } else {
            out.write("\t<relationship id=\"" + this.getID() + "\">\n");
            if (!this.getAttributes().isEmpty()) {
                this.writeAttributeList(out);
            }
        }
        if (!this.fRoles.isEmpty()) {
            out.write("\t\t<rolelist>\n");
            for (Role role : this.fRoles) {
                role.write(out);
            }
            out.write("\t\t</rolelist>\n");
        }
        if (this.isWeak()) {
            out.write("\t</weakrelationship>\n");
        } else {
            out.write("\t</relationship>\n");
        }
    }

    @Override
    public void write(Writer out) throws IOException {
        if (this.isWeak()) {
            out.write("\t\t<weakrelationshipid id=\"" + this.getID() + "\" posX=\"" + this.getX() + "\" posY=\"" + this.getY() + "\" name=\"" + this.getName() + "\">");
            out.write("</weakrelationshipid>\n");
        } else {
            out.write("\t\t<relationshipid id=\"" + this.getID() + "\" posX=\"" + this.getX() + "\" posY=\"" + this.getY() + "\" name=\"" + this.getName() + "\">");
            out.write("</relationshipid>\n");
        }
    }
}

